// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



/**
 * Limits that are related to concurrency and storage. All file and storage sizes are in bytes.
 */
class AccountLimit private constructor(builder: Builder) {
    /**
     * The maximum size of a function's deployment package and layers when they're extracted.
     */
    val codeSizeUnzipped: kotlin.Long = builder.codeSizeUnzipped
    /**
     * The maximum size of a deployment package when it's uploaded directly to Lambda. Use Amazon S3 for larger files.
     */
    val codeSizeZipped: kotlin.Long = builder.codeSizeZipped
    /**
     * The maximum number of simultaneous function executions.
     */
    val concurrentExecutions: kotlin.Int = builder.concurrentExecutions
    /**
     * The amount of storage space that you can use for all deployment packages and layer archives.
     */
    val totalCodeSize: kotlin.Long = builder.totalCodeSize
    /**
     * The maximum number of simultaneous function executions, minus the capacity that's reserved for individual functions with PutFunctionConcurrency.
     */
    val unreservedConcurrentExecutions: kotlin.Int? = builder.unreservedConcurrentExecutions

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.AccountLimit = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountLimit(")
        append("codeSizeUnzipped=$codeSizeUnzipped,")
        append("codeSizeZipped=$codeSizeZipped,")
        append("concurrentExecutions=$concurrentExecutions,")
        append("totalCodeSize=$totalCodeSize,")
        append("unreservedConcurrentExecutions=$unreservedConcurrentExecutions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeSizeUnzipped.hashCode()
        result = 31 * result + (codeSizeZipped.hashCode())
        result = 31 * result + (concurrentExecutions)
        result = 31 * result + (totalCodeSize.hashCode())
        result = 31 * result + (unreservedConcurrentExecutions ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountLimit

        if (codeSizeUnzipped != other.codeSizeUnzipped) return false
        if (codeSizeZipped != other.codeSizeZipped) return false
        if (concurrentExecutions != other.concurrentExecutions) return false
        if (totalCodeSize != other.totalCodeSize) return false
        if (unreservedConcurrentExecutions != other.unreservedConcurrentExecutions) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.AccountLimit = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum size of a function's deployment package and layers when they're extracted.
         */
        var codeSizeUnzipped: kotlin.Long = 0L
        /**
         * The maximum size of a deployment package when it's uploaded directly to Lambda. Use Amazon S3 for larger files.
         */
        var codeSizeZipped: kotlin.Long = 0L
        /**
         * The maximum number of simultaneous function executions.
         */
        var concurrentExecutions: kotlin.Int = 0
        /**
         * The amount of storage space that you can use for all deployment packages and layer archives.
         */
        var totalCodeSize: kotlin.Long = 0L
        /**
         * The maximum number of simultaneous function executions, minus the capacity that's reserved for individual functions with PutFunctionConcurrency.
         */
        var unreservedConcurrentExecutions: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.AccountLimit) : this() {
            this.codeSizeUnzipped = x.codeSizeUnzipped
            this.codeSizeZipped = x.codeSizeZipped
            this.concurrentExecutions = x.concurrentExecutions
            this.totalCodeSize = x.totalCodeSize
            this.unreservedConcurrentExecutions = x.unreservedConcurrentExecutions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.AccountLimit = AccountLimit(this)
    }
}
