// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



class AddLayerVersionPermissionRequest private constructor(builder: Builder) {
    /**
     * The API action that grants access to the layer. For example, `lambda:GetLayerVersion`.
     */
    val action: kotlin.String? = builder.action
    /**
     * The name or Amazon Resource Name (ARN) of the layer.
     */
    val layerName: kotlin.String? = requireNotNull(builder.layerName) { "A non-null value must be provided for layerName" }
    /**
     * With the principal set to `*`, grant permission to all accounts in the specified organization.
     */
    val organizationId: kotlin.String? = builder.organizationId
    /**
     * An account ID, or `*` to grant layer usage permission to all accounts in an organization, or all Amazon Web Services accounts (if `organizationId` is not specified). For the last case, make sure that you really do want all Amazon Web Services accounts to have usage permission to this layer.
     */
    val principal: kotlin.String? = builder.principal
    /**
     * Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.
     */
    val revisionId: kotlin.String? = builder.revisionId
    /**
     * An identifier that distinguishes the policy from others on the same layer version.
     */
    val statementId: kotlin.String? = builder.statementId
    /**
     * The version number.
     */
    val versionNumber: kotlin.Long = requireNotNull(builder.versionNumber) { "A non-null value must be provided for versionNumber" }

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.AddLayerVersionPermissionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddLayerVersionPermissionRequest(")
        append("action=$action,")
        append("layerName=$layerName,")
        append("organizationId=$organizationId,")
        append("principal=$principal,")
        append("revisionId=$revisionId,")
        append("statementId=$statementId,")
        append("versionNumber=$versionNumber)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (layerName?.hashCode() ?: 0)
        result = 31 * result + (organizationId?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (statementId?.hashCode() ?: 0)
        result = 31 * result + (versionNumber.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddLayerVersionPermissionRequest

        if (action != other.action) return false
        if (layerName != other.layerName) return false
        if (organizationId != other.organizationId) return false
        if (principal != other.principal) return false
        if (revisionId != other.revisionId) return false
        if (statementId != other.statementId) return false
        if (versionNumber != other.versionNumber) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.AddLayerVersionPermissionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The API action that grants access to the layer. For example, `lambda:GetLayerVersion`.
         */
        var action: kotlin.String? = null
        /**
         * The name or Amazon Resource Name (ARN) of the layer.
         */
        var layerName: kotlin.String? = null
        /**
         * With the principal set to `*`, grant permission to all accounts in the specified organization.
         */
        var organizationId: kotlin.String? = null
        /**
         * An account ID, or `*` to grant layer usage permission to all accounts in an organization, or all Amazon Web Services accounts (if `organizationId` is not specified). For the last case, make sure that you really do want all Amazon Web Services accounts to have usage permission to this layer.
         */
        var principal: kotlin.String? = null
        /**
         * Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.
         */
        var revisionId: kotlin.String? = null
        /**
         * An identifier that distinguishes the policy from others on the same layer version.
         */
        var statementId: kotlin.String? = null
        /**
         * The version number.
         */
        var versionNumber: kotlin.Long = 0L

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.AddLayerVersionPermissionRequest) : this() {
            this.action = x.action
            this.layerName = x.layerName
            this.organizationId = x.organizationId
            this.principal = x.principal
            this.revisionId = x.revisionId
            this.statementId = x.statementId
            this.versionNumber = x.versionNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.AddLayerVersionPermissionRequest = AddLayerVersionPermissionRequest(this)
    }
}
