// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



/**
 * The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for your Lambda function URL. Use CORS to grant access to your function URL from any origin. You can also use CORS to control access for specific HTTP headers and methods in requests to your function URL.
 */
class Cors private constructor(builder: Builder) {
    /**
     * Whether to allow cookies or other credentials in requests to your function URL. The default is `false`.
     */
    val allowCredentials: kotlin.Boolean? = builder.allowCredentials
    /**
     * The HTTP headers that origins can include in requests to your function URL. For example: `Date`, `Keep-Alive`, `X-Custom-Header`.
     */
    val allowHeaders: List<String>? = builder.allowHeaders
    /**
     * The HTTP methods that are allowed when calling your function URL. For example: `GET`, `POST`, `DELETE`, or the wildcard character (`*`).
     */
    val allowMethods: List<String>? = builder.allowMethods
    /**
     * The origins that can access your function URL. You can list any number of specific origins, separated by a comma. For example: `https://www.example.com`, `http://localhost:60905`.
     *
     * Alternatively, you can grant access to all origins using the wildcard character (`*`).
     */
    val allowOrigins: List<String>? = builder.allowOrigins
    /**
     * The HTTP headers in your function response that you want to expose to origins that call your function URL. For example: `Date`, `Keep-Alive`, `X-Custom-Header`.
     */
    val exposeHeaders: List<String>? = builder.exposeHeaders
    /**
     * The maximum amount of time, in seconds, that web browsers can cache results of a preflight request. By default, this is set to `0`, which means that the browser doesn't cache results.
     */
    val maxAge: kotlin.Int? = builder.maxAge

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.Cors = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Cors(")
        append("allowCredentials=$allowCredentials,")
        append("allowHeaders=$allowHeaders,")
        append("allowMethods=$allowMethods,")
        append("allowOrigins=$allowOrigins,")
        append("exposeHeaders=$exposeHeaders,")
        append("maxAge=$maxAge)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowCredentials?.hashCode() ?: 0
        result = 31 * result + (allowHeaders?.hashCode() ?: 0)
        result = 31 * result + (allowMethods?.hashCode() ?: 0)
        result = 31 * result + (allowOrigins?.hashCode() ?: 0)
        result = 31 * result + (exposeHeaders?.hashCode() ?: 0)
        result = 31 * result + (maxAge ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Cors

        if (allowCredentials != other.allowCredentials) return false
        if (allowHeaders != other.allowHeaders) return false
        if (allowMethods != other.allowMethods) return false
        if (allowOrigins != other.allowOrigins) return false
        if (exposeHeaders != other.exposeHeaders) return false
        if (maxAge != other.maxAge) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.Cors = Builder(this).apply(block).build()

    class Builder {
        /**
         * Whether to allow cookies or other credentials in requests to your function URL. The default is `false`.
         */
        var allowCredentials: kotlin.Boolean? = null
        /**
         * The HTTP headers that origins can include in requests to your function URL. For example: `Date`, `Keep-Alive`, `X-Custom-Header`.
         */
        var allowHeaders: List<String>? = null
        /**
         * The HTTP methods that are allowed when calling your function URL. For example: `GET`, `POST`, `DELETE`, or the wildcard character (`*`).
         */
        var allowMethods: List<String>? = null
        /**
         * The origins that can access your function URL. You can list any number of specific origins, separated by a comma. For example: `https://www.example.com`, `http://localhost:60905`.
         *
         * Alternatively, you can grant access to all origins using the wildcard character (`*`).
         */
        var allowOrigins: List<String>? = null
        /**
         * The HTTP headers in your function response that you want to expose to origins that call your function URL. For example: `Date`, `Keep-Alive`, `X-Custom-Header`.
         */
        var exposeHeaders: List<String>? = null
        /**
         * The maximum amount of time, in seconds, that web browsers can cache results of a preflight request. By default, this is set to `0`, which means that the browser doesn't cache results.
         */
        var maxAge: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.Cors) : this() {
            this.allowCredentials = x.allowCredentials
            this.allowHeaders = x.allowHeaders
            this.allowMethods = x.allowMethods
            this.allowOrigins = x.allowOrigins
            this.exposeHeaders = x.exposeHeaders
            this.maxAge = x.maxAge
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.Cors = Cors(this)
    }
}
