// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



class CreateFunctionUrlConfigResponse private constructor(builder: Builder) {
    /**
     * The type of authentication that your function URL uses. Set to `AWS_IAM` if you want to restrict access to authenticated `IAM` users only. Set to `NONE` if you want to bypass IAM authentication to create a public endpoint. For more information, see [ Security and auth model for Lambda function URLs](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html).
     */
    val authType: aws.sdk.kotlin.services.lambda.model.FunctionUrlAuthType? = builder.authType
    /**
     * The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for your function URL.
     */
    val cors: aws.sdk.kotlin.services.lambda.model.Cors? = builder.cors
    /**
     * When the function URL was created, in [ISO-8601 format](https://www.w3.org/TR/NOTE-datetime) (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    val creationTime: kotlin.String? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of your function.
     */
    val functionArn: kotlin.String? = builder.functionArn
    /**
     * The HTTP URL endpoint for your function.
     */
    val functionUrl: kotlin.String? = builder.functionUrl

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.CreateFunctionUrlConfigResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFunctionUrlConfigResponse(")
        append("authType=$authType,")
        append("cors=$cors,")
        append("creationTime=$creationTime,")
        append("functionArn=$functionArn,")
        append("functionUrl=$functionUrl)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authType?.hashCode() ?: 0
        result = 31 * result + (cors?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (functionArn?.hashCode() ?: 0)
        result = 31 * result + (functionUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFunctionUrlConfigResponse

        if (authType != other.authType) return false
        if (cors != other.cors) return false
        if (creationTime != other.creationTime) return false
        if (functionArn != other.functionArn) return false
        if (functionUrl != other.functionUrl) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.CreateFunctionUrlConfigResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of authentication that your function URL uses. Set to `AWS_IAM` if you want to restrict access to authenticated `IAM` users only. Set to `NONE` if you want to bypass IAM authentication to create a public endpoint. For more information, see [ Security and auth model for Lambda function URLs](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html).
         */
        var authType: aws.sdk.kotlin.services.lambda.model.FunctionUrlAuthType? = null
        /**
         * The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for your function URL.
         */
        var cors: aws.sdk.kotlin.services.lambda.model.Cors? = null
        /**
         * When the function URL was created, in [ISO-8601 format](https://www.w3.org/TR/NOTE-datetime) (YYYY-MM-DDThh:mm:ss.sTZD).
         */
        var creationTime: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of your function.
         */
        var functionArn: kotlin.String? = null
        /**
         * The HTTP URL endpoint for your function.
         */
        var functionUrl: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.CreateFunctionUrlConfigResponse) : this() {
            this.authType = x.authType
            this.cors = x.cors
            this.creationTime = x.creationTime
            this.functionArn = x.functionArn
            this.functionUrl = x.functionUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.CreateFunctionUrlConfigResponse = CreateFunctionUrlConfigResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.Cors] inside the given [block]
         */
        fun cors(block: aws.sdk.kotlin.services.lambda.model.Cors.Builder.() -> kotlin.Unit) {
            this.cors = aws.sdk.kotlin.services.lambda.model.Cors.invoke(block)
        }
    }
}
