// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



/**
 * Details about the connection between a Lambda function and an [Amazon EFS file system](https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html).
 */
class FileSystemConfig private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon EFS access point that provides access to the file system.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The path where the function can access the file system, starting with `/mnt/`.
     */
    val localMountPath: kotlin.String? = builder.localMountPath

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.FileSystemConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileSystemConfig(")
        append("arn=$arn,")
        append("localMountPath=$localMountPath)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (localMountPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileSystemConfig

        if (arn != other.arn) return false
        if (localMountPath != other.localMountPath) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.FileSystemConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon EFS access point that provides access to the file system.
         */
        var arn: kotlin.String? = null
        /**
         * The path where the function can access the file system, starting with `/mnt/`.
         */
        var localMountPath: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.FileSystemConfig) : this() {
            this.arn = x.arn
            this.localMountPath = x.localMountPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.FileSystemConfig = FileSystemConfig(this)
    }
}
