// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



class InvokeResponse private constructor(builder: Builder) {
    /**
     * The version of the function that executed. When you invoke a function with an alias, this indicates which version the alias resolved to.
     */
    val executedVersion: kotlin.String? = builder.executedVersion
    /**
     * If present, indicates that an error occurred during function execution. Details about the error are included in the response payload.
     */
    val functionError: kotlin.String? = builder.functionError
    /**
     * The last 4 KB of the execution log, which is base64 encoded.
     */
    val logResult: kotlin.String? = builder.logResult
    /**
     * The response from the function, or an error object.
     */
    val payload: kotlin.ByteArray? = builder.payload
    /**
     * The HTTP status code is in the 200 range for a successful request. For the `RequestResponse` invocation type, this status code is 200. For the `Event` invocation type, this status code is 202. For the `DryRun` invocation type, the status code is 204.
     */
    val statusCode: kotlin.Int = builder.statusCode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.InvokeResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvokeResponse(")
        append("executedVersion=$executedVersion,")
        append("functionError=$functionError,")
        append("logResult=$logResult,")
        append("payload=*** Sensitive Data Redacted ***,")
        append("statusCode=$statusCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = executedVersion?.hashCode() ?: 0
        result = 31 * result + (functionError?.hashCode() ?: 0)
        result = 31 * result + (logResult?.hashCode() ?: 0)
        result = 31 * result + (payload?.contentHashCode() ?: 0)
        result = 31 * result + (statusCode)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvokeResponse

        if (executedVersion != other.executedVersion) return false
        if (functionError != other.functionError) return false
        if (logResult != other.logResult) return false
        if (payload != null) {
            if (other.payload == null) return false
            if (!payload.contentEquals(other.payload)) return false
        } else if (other.payload != null) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.InvokeResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The version of the function that executed. When you invoke a function with an alias, this indicates which version the alias resolved to.
         */
        var executedVersion: kotlin.String? = null
        /**
         * If present, indicates that an error occurred during function execution. Details about the error are included in the response payload.
         */
        var functionError: kotlin.String? = null
        /**
         * The last 4 KB of the execution log, which is base64 encoded.
         */
        var logResult: kotlin.String? = null
        /**
         * The response from the function, or an error object.
         */
        var payload: kotlin.ByteArray? = null
        /**
         * The HTTP status code is in the 200 range for a successful request. For the `RequestResponse` invocation type, this status code is 200. For the `Event` invocation type, this status code is 202. For the `DryRun` invocation type, the status code is 204.
         */
        var statusCode: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.InvokeResponse) : this() {
            this.executedVersion = x.executedVersion
            this.functionError = x.functionError
            this.logResult = x.logResult
            this.payload = x.payload
            this.statusCode = x.statusCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.InvokeResponse = InvokeResponse(this)
    }
}
