// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



/**
 * Details about a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
 */
class LayerVersionContentOutput private constructor(builder: Builder) {
    /**
     * The SHA-256 hash of the layer archive.
     */
    val codeSha256: kotlin.String? = builder.codeSha256
    /**
     * The size of the layer archive in bytes.
     */
    val codeSize: kotlin.Long = builder.codeSize
    /**
     * A link to the layer archive in Amazon S3 that is valid for 10 minutes.
     */
    val location: kotlin.String? = builder.location
    /**
     * The Amazon Resource Name (ARN) of a signing job.
     */
    val signingJobArn: kotlin.String? = builder.signingJobArn
    /**
     * The Amazon Resource Name (ARN) for a signing profile version.
     */
    val signingProfileVersionArn: kotlin.String? = builder.signingProfileVersionArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.LayerVersionContentOutput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LayerVersionContentOutput(")
        append("codeSha256=$codeSha256,")
        append("codeSize=$codeSize,")
        append("location=$location,")
        append("signingJobArn=$signingJobArn,")
        append("signingProfileVersionArn=$signingProfileVersionArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeSha256?.hashCode() ?: 0
        result = 31 * result + (codeSize.hashCode())
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (signingJobArn?.hashCode() ?: 0)
        result = 31 * result + (signingProfileVersionArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LayerVersionContentOutput

        if (codeSha256 != other.codeSha256) return false
        if (codeSize != other.codeSize) return false
        if (location != other.location) return false
        if (signingJobArn != other.signingJobArn) return false
        if (signingProfileVersionArn != other.signingProfileVersionArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.LayerVersionContentOutput = Builder(this).apply(block).build()

    class Builder {
        /**
         * The SHA-256 hash of the layer archive.
         */
        var codeSha256: kotlin.String? = null
        /**
         * The size of the layer archive in bytes.
         */
        var codeSize: kotlin.Long = 0L
        /**
         * A link to the layer archive in Amazon S3 that is valid for 10 minutes.
         */
        var location: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of a signing job.
         */
        var signingJobArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for a signing profile version.
         */
        var signingProfileVersionArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.LayerVersionContentOutput) : this() {
            this.codeSha256 = x.codeSha256
            this.codeSize = x.codeSize
            this.location = x.location
            this.signingJobArn = x.signingJobArn
            this.signingProfileVersionArn = x.signingProfileVersionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.LayerVersionContentOutput = LayerVersionContentOutput(this)
    }
}
