// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



class ListFunctionUrlConfigsRequest private constructor(builder: Builder) {
    /**
     * The name of the Lambda function.
     *
     * **Name formats**
     * + **Function name** - `my-function`.
     * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
     * + **Partial ARN** - `123456789012:function:my-function`.
     *
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    val functionName: kotlin.String? = requireNotNull(builder.functionName) { "A non-null value must be provided for functionName" }
    /**
     * Specify the pagination token that's returned by a previous request to retrieve the next page of results.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of function URLs to return in the response. Note that `ListFunctionUrlConfigs` returns a maximum of 50 items in each response, even if you set the number higher.
     */
    val maxItems: kotlin.Int? = builder.maxItems

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.ListFunctionUrlConfigsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListFunctionUrlConfigsRequest(")
        append("functionName=$functionName,")
        append("marker=$marker,")
        append("maxItems=$maxItems)")
    }

    override fun hashCode(): kotlin.Int {
        var result = functionName?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListFunctionUrlConfigsRequest

        if (functionName != other.functionName) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.ListFunctionUrlConfigsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the Lambda function.
         *
         * **Name formats**
         * + **Function name** - `my-function`.
         * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
         * + **Partial ARN** - `123456789012:function:my-function`.
         *
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         */
        var functionName: kotlin.String? = null
        /**
         * Specify the pagination token that's returned by a previous request to retrieve the next page of results.
         */
        var marker: kotlin.String? = null
        /**
         * The maximum number of function URLs to return in the response. Note that `ListFunctionUrlConfigs` returns a maximum of 50 items in each response, even if you set the number higher.
         */
        var maxItems: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.ListFunctionUrlConfigsRequest) : this() {
            this.functionName = x.functionName
            this.marker = x.marker
            this.maxItems = x.maxItems
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.ListFunctionUrlConfigsRequest = ListFunctionUrlConfigsRequest(this)
    }
}
