// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



class PublishVersionRequest private constructor(builder: Builder) {
    /**
     * Only publish a version if the hash value matches the value that's specified. Use this option to avoid publishing a version if the function code has changed since you last updated it. You can get the hash for the version that you uploaded from the output of UpdateFunctionCode.
     */
    val codeSha256: kotlin.String? = builder.codeSha256
    /**
     * A description for the version to override the description in the function configuration.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name of the Lambda function.
     *
     * **Name formats**
     * + **Function name** - `MyFunction`.
     * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
     * + **Partial ARN** - `123456789012:function:MyFunction`.
     *
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    val functionName: kotlin.String? = requireNotNull(builder.functionName) { "A non-null value must be provided for functionName" }
    /**
     * Only update the function if the revision ID matches the ID that's specified. Use this option to avoid publishing a version if the function configuration has changed since you last updated it.
     */
    val revisionId: kotlin.String? = builder.revisionId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.PublishVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PublishVersionRequest(")
        append("codeSha256=$codeSha256,")
        append("description=$description,")
        append("functionName=$functionName,")
        append("revisionId=$revisionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeSha256?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PublishVersionRequest

        if (codeSha256 != other.codeSha256) return false
        if (description != other.description) return false
        if (functionName != other.functionName) return false
        if (revisionId != other.revisionId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.PublishVersionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Only publish a version if the hash value matches the value that's specified. Use this option to avoid publishing a version if the function code has changed since you last updated it. You can get the hash for the version that you uploaded from the output of UpdateFunctionCode.
         */
        var codeSha256: kotlin.String? = null
        /**
         * A description for the version to override the description in the function configuration.
         */
        var description: kotlin.String? = null
        /**
         * The name of the Lambda function.
         *
         * **Name formats**
         * + **Function name** - `MyFunction`.
         * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
         * + **Partial ARN** - `123456789012:function:MyFunction`.
         *
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         */
        var functionName: kotlin.String? = null
        /**
         * Only update the function if the revision ID matches the ID that's specified. Use this option to avoid publishing a version if the function configuration has changed since you last updated it.
         */
        var revisionId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.PublishVersionRequest) : this() {
            this.codeSha256 = x.codeSha256
            this.description = x.description
            this.functionName = x.functionName
            this.revisionId = x.revisionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.PublishVersionRequest = PublishVersionRequest(this)
    }
}
