// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



class PutFunctionConcurrencyRequest private constructor(builder: Builder) {
    /**
     * The name of the Lambda function.
     *
     * **Name formats**
     * + **Function name** - `my-function`.
     * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
     * + **Partial ARN** - `123456789012:function:my-function`.
     *
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    val functionName: kotlin.String? = requireNotNull(builder.functionName) { "A non-null value must be provided for functionName" }
    /**
     * The number of simultaneous executions to reserve for the function.
     */
    val reservedConcurrentExecutions: kotlin.Int? = builder.reservedConcurrentExecutions

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.PutFunctionConcurrencyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutFunctionConcurrencyRequest(")
        append("functionName=$functionName,")
        append("reservedConcurrentExecutions=$reservedConcurrentExecutions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = functionName?.hashCode() ?: 0
        result = 31 * result + (reservedConcurrentExecutions ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutFunctionConcurrencyRequest

        if (functionName != other.functionName) return false
        if (reservedConcurrentExecutions != other.reservedConcurrentExecutions) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.PutFunctionConcurrencyRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the Lambda function.
         *
         * **Name formats**
         * + **Function name** - `my-function`.
         * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
         * + **Partial ARN** - `123456789012:function:my-function`.
         *
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         */
        var functionName: kotlin.String? = null
        /**
         * The number of simultaneous executions to reserve for the function.
         */
        var reservedConcurrentExecutions: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.PutFunctionConcurrencyRequest) : this() {
            this.functionName = x.functionName
            this.reservedConcurrentExecutions = x.reservedConcurrentExecutions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.PutFunctionConcurrencyRequest = PutFunctionConcurrencyRequest(this)
    }
}
