// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A mapping between an Amazon Web Services resource and a Lambda function. For details, see CreateEventSourceMapping.
 */
class UpdateEventSourceMappingResponse private constructor(builder: Builder) {
    /**
     * The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).
     *
     * Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.
     *
     * Related setting: When you set `BatchSize` to a value greater than 10, you must set `MaximumBatchingWindowInSeconds` to at least 1.
     */
    val batchSize: kotlin.Int? = builder.batchSize
    /**
     * (Streams only) If the function returns an error, split the batch in two and retry. The default value is false.
     */
    val bisectBatchOnFunctionError: kotlin.Boolean? = builder.bisectBatchOnFunctionError
    /**
     * (Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
     */
    val destinationConfig: aws.sdk.kotlin.services.lambda.model.DestinationConfig? = builder.destinationConfig
    /**
     * The Amazon Resource Name (ARN) of the event source.
     */
    val eventSourceArn: kotlin.String? = builder.eventSourceArn
    /**
     * (Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see [Lambda event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html).
     */
    val filterCriteria: aws.sdk.kotlin.services.lambda.model.FilterCriteria? = builder.filterCriteria
    /**
     * The ARN of the Lambda function.
     */
    val functionArn: kotlin.String? = builder.functionArn
    /**
     * (Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.
     */
    val functionResponseTypes: List<FunctionResponseType>? = builder.functionResponseTypes
    /**
     * The date that the event source mapping was last updated or that its state changed.
     */
    val lastModified: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModified
    /**
     * The result of the last Lambda invocation of your function.
     */
    val lastProcessingResult: kotlin.String? = builder.lastProcessingResult
    /**
     * (Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.
     *
     * Default: 0
     *
     * Related setting: When you set `BatchSize` to a value greater than 10, you must set `MaximumBatchingWindowInSeconds` to at least 1.
     */
    val maximumBatchingWindowInSeconds: kotlin.Int? = builder.maximumBatchingWindowInSeconds
    /**
     * (Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.
     */
    val maximumRecordAgeInSeconds: kotlin.Int? = builder.maximumRecordAgeInSeconds
    /**
     * (Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.
     */
    val maximumRetryAttempts: kotlin.Int? = builder.maximumRetryAttempts
    /**
     * (Streams only) The number of batches to process concurrently from each shard. The default value is 1.
     */
    val parallelizationFactor: kotlin.Int? = builder.parallelizationFactor
    /**
     * (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
     */
    val queues: List<String>? = builder.queues
    /**
     * The self-managed Apache Kafka cluster for your event source.
     */
    val selfManagedEventSource: aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource? = builder.selfManagedEventSource
    /**
     * An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.
     */
    val sourceAccessConfigurations: List<SourceAccessConfiguration>? = builder.sourceAccessConfigurations
    /**
     * The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. `AT_TIMESTAMP` is supported only for Amazon Kinesis streams.
     */
    val startingPosition: aws.sdk.kotlin.services.lambda.model.EventSourcePosition? = builder.startingPosition
    /**
     * With `StartingPosition` set to `AT_TIMESTAMP`, the time from which to start reading.
     */
    val startingPositionTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.startingPositionTimestamp
    /**
     * The state of the event source mapping. It can be one of the following: `Creating`, `Enabling`, `Enabled`, `Disabling`, `Disabled`, `Updating`, or `Deleting`.
     */
    val state: kotlin.String? = builder.state
    /**
     * Indicates whether a user or Lambda made the last change to the event source mapping.
     */
    val stateTransitionReason: kotlin.String? = builder.stateTransitionReason
    /**
     * The name of the Kafka topic.
     */
    val topics: List<String>? = builder.topics
    /**
     * (Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.
     */
    val tumblingWindowInSeconds: kotlin.Int? = builder.tumblingWindowInSeconds
    /**
     * The identifier of the event source mapping.
     */
    val uuid: kotlin.String? = builder.uuid

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.UpdateEventSourceMappingResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateEventSourceMappingResponse(")
        append("batchSize=$batchSize,")
        append("bisectBatchOnFunctionError=$bisectBatchOnFunctionError,")
        append("destinationConfig=$destinationConfig,")
        append("eventSourceArn=$eventSourceArn,")
        append("filterCriteria=$filterCriteria,")
        append("functionArn=$functionArn,")
        append("functionResponseTypes=$functionResponseTypes,")
        append("lastModified=$lastModified,")
        append("lastProcessingResult=$lastProcessingResult,")
        append("maximumBatchingWindowInSeconds=$maximumBatchingWindowInSeconds,")
        append("maximumRecordAgeInSeconds=$maximumRecordAgeInSeconds,")
        append("maximumRetryAttempts=$maximumRetryAttempts,")
        append("parallelizationFactor=$parallelizationFactor,")
        append("queues=$queues,")
        append("selfManagedEventSource=$selfManagedEventSource,")
        append("sourceAccessConfigurations=$sourceAccessConfigurations,")
        append("startingPosition=$startingPosition,")
        append("startingPositionTimestamp=$startingPositionTimestamp,")
        append("state=$state,")
        append("stateTransitionReason=$stateTransitionReason,")
        append("topics=$topics,")
        append("tumblingWindowInSeconds=$tumblingWindowInSeconds,")
        append("uuid=$uuid)")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchSize ?: 0
        result = 31 * result + (bisectBatchOnFunctionError?.hashCode() ?: 0)
        result = 31 * result + (destinationConfig?.hashCode() ?: 0)
        result = 31 * result + (eventSourceArn?.hashCode() ?: 0)
        result = 31 * result + (filterCriteria?.hashCode() ?: 0)
        result = 31 * result + (functionArn?.hashCode() ?: 0)
        result = 31 * result + (functionResponseTypes?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (lastProcessingResult?.hashCode() ?: 0)
        result = 31 * result + (maximumBatchingWindowInSeconds ?: 0)
        result = 31 * result + (maximumRecordAgeInSeconds ?: 0)
        result = 31 * result + (maximumRetryAttempts ?: 0)
        result = 31 * result + (parallelizationFactor ?: 0)
        result = 31 * result + (queues?.hashCode() ?: 0)
        result = 31 * result + (selfManagedEventSource?.hashCode() ?: 0)
        result = 31 * result + (sourceAccessConfigurations?.hashCode() ?: 0)
        result = 31 * result + (startingPosition?.hashCode() ?: 0)
        result = 31 * result + (startingPositionTimestamp?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateTransitionReason?.hashCode() ?: 0)
        result = 31 * result + (topics?.hashCode() ?: 0)
        result = 31 * result + (tumblingWindowInSeconds ?: 0)
        result = 31 * result + (uuid?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateEventSourceMappingResponse

        if (batchSize != other.batchSize) return false
        if (bisectBatchOnFunctionError != other.bisectBatchOnFunctionError) return false
        if (destinationConfig != other.destinationConfig) return false
        if (eventSourceArn != other.eventSourceArn) return false
        if (filterCriteria != other.filterCriteria) return false
        if (functionArn != other.functionArn) return false
        if (functionResponseTypes != other.functionResponseTypes) return false
        if (lastModified != other.lastModified) return false
        if (lastProcessingResult != other.lastProcessingResult) return false
        if (maximumBatchingWindowInSeconds != other.maximumBatchingWindowInSeconds) return false
        if (maximumRecordAgeInSeconds != other.maximumRecordAgeInSeconds) return false
        if (maximumRetryAttempts != other.maximumRetryAttempts) return false
        if (parallelizationFactor != other.parallelizationFactor) return false
        if (queues != other.queues) return false
        if (selfManagedEventSource != other.selfManagedEventSource) return false
        if (sourceAccessConfigurations != other.sourceAccessConfigurations) return false
        if (startingPosition != other.startingPosition) return false
        if (startingPositionTimestamp != other.startingPositionTimestamp) return false
        if (state != other.state) return false
        if (stateTransitionReason != other.stateTransitionReason) return false
        if (topics != other.topics) return false
        if (tumblingWindowInSeconds != other.tumblingWindowInSeconds) return false
        if (uuid != other.uuid) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.UpdateEventSourceMappingResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).
         *
         * Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.
         *
         * Related setting: When you set `BatchSize` to a value greater than 10, you must set `MaximumBatchingWindowInSeconds` to at least 1.
         */
        var batchSize: kotlin.Int? = null
        /**
         * (Streams only) If the function returns an error, split the batch in two and retry. The default value is false.
         */
        var bisectBatchOnFunctionError: kotlin.Boolean? = null
        /**
         * (Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         */
        var destinationConfig: aws.sdk.kotlin.services.lambda.model.DestinationConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the event source.
         */
        var eventSourceArn: kotlin.String? = null
        /**
         * (Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see [Lambda event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html).
         */
        var filterCriteria: aws.sdk.kotlin.services.lambda.model.FilterCriteria? = null
        /**
         * The ARN of the Lambda function.
         */
        var functionArn: kotlin.String? = null
        /**
         * (Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.
         */
        var functionResponseTypes: List<FunctionResponseType>? = null
        /**
         * The date that the event source mapping was last updated or that its state changed.
         */
        var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The result of the last Lambda invocation of your function.
         */
        var lastProcessingResult: kotlin.String? = null
        /**
         * (Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.
         *
         * Default: 0
         *
         * Related setting: When you set `BatchSize` to a value greater than 10, you must set `MaximumBatchingWindowInSeconds` to at least 1.
         */
        var maximumBatchingWindowInSeconds: kotlin.Int? = null
        /**
         * (Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.
         */
        var maximumRecordAgeInSeconds: kotlin.Int? = null
        /**
         * (Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.
         */
        var maximumRetryAttempts: kotlin.Int? = null
        /**
         * (Streams only) The number of batches to process concurrently from each shard. The default value is 1.
         */
        var parallelizationFactor: kotlin.Int? = null
        /**
         * (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
         */
        var queues: List<String>? = null
        /**
         * The self-managed Apache Kafka cluster for your event source.
         */
        var selfManagedEventSource: aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource? = null
        /**
         * An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.
         */
        var sourceAccessConfigurations: List<SourceAccessConfiguration>? = null
        /**
         * The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. `AT_TIMESTAMP` is supported only for Amazon Kinesis streams.
         */
        var startingPosition: aws.sdk.kotlin.services.lambda.model.EventSourcePosition? = null
        /**
         * With `StartingPosition` set to `AT_TIMESTAMP`, the time from which to start reading.
         */
        var startingPositionTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the event source mapping. It can be one of the following: `Creating`, `Enabling`, `Enabled`, `Disabling`, `Disabled`, `Updating`, or `Deleting`.
         */
        var state: kotlin.String? = null
        /**
         * Indicates whether a user or Lambda made the last change to the event source mapping.
         */
        var stateTransitionReason: kotlin.String? = null
        /**
         * The name of the Kafka topic.
         */
        var topics: List<String>? = null
        /**
         * (Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.
         */
        var tumblingWindowInSeconds: kotlin.Int? = null
        /**
         * The identifier of the event source mapping.
         */
        var uuid: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.UpdateEventSourceMappingResponse) : this() {
            this.batchSize = x.batchSize
            this.bisectBatchOnFunctionError = x.bisectBatchOnFunctionError
            this.destinationConfig = x.destinationConfig
            this.eventSourceArn = x.eventSourceArn
            this.filterCriteria = x.filterCriteria
            this.functionArn = x.functionArn
            this.functionResponseTypes = x.functionResponseTypes
            this.lastModified = x.lastModified
            this.lastProcessingResult = x.lastProcessingResult
            this.maximumBatchingWindowInSeconds = x.maximumBatchingWindowInSeconds
            this.maximumRecordAgeInSeconds = x.maximumRecordAgeInSeconds
            this.maximumRetryAttempts = x.maximumRetryAttempts
            this.parallelizationFactor = x.parallelizationFactor
            this.queues = x.queues
            this.selfManagedEventSource = x.selfManagedEventSource
            this.sourceAccessConfigurations = x.sourceAccessConfigurations
            this.startingPosition = x.startingPosition
            this.startingPositionTimestamp = x.startingPositionTimestamp
            this.state = x.state
            this.stateTransitionReason = x.stateTransitionReason
            this.topics = x.topics
            this.tumblingWindowInSeconds = x.tumblingWindowInSeconds
            this.uuid = x.uuid
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.UpdateEventSourceMappingResponse = UpdateEventSourceMappingResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.DestinationConfig] inside the given [block]
         */
        fun destinationConfig(block: aws.sdk.kotlin.services.lambda.model.DestinationConfig.Builder.() -> kotlin.Unit) {
            this.destinationConfig = aws.sdk.kotlin.services.lambda.model.DestinationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.FilterCriteria] inside the given [block]
         */
        fun filterCriteria(block: aws.sdk.kotlin.services.lambda.model.FilterCriteria.Builder.() -> kotlin.Unit) {
            this.filterCriteria = aws.sdk.kotlin.services.lambda.model.FilterCriteria.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource] inside the given [block]
         */
        fun selfManagedEventSource(block: aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource.Builder.() -> kotlin.Unit) {
            this.selfManagedEventSource = aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource.invoke(block)
        }
    }
}
