// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



class UpdateFunctionUrlConfigRequest private constructor(builder: Builder) {
    /**
     * The type of authentication that your function URL uses. Set to `AWS_IAM` if you want to restrict access to authenticated `IAM` users only. Set to `NONE` if you want to bypass IAM authentication to create a public endpoint. For more information, see [ Security and auth model for Lambda function URLs](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html).
     */
    val authType: aws.sdk.kotlin.services.lambda.model.FunctionUrlAuthType? = builder.authType
    /**
     * The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for your function URL.
     */
    val cors: aws.sdk.kotlin.services.lambda.model.Cors? = builder.cors
    /**
     * The name of the Lambda function.
     *
     * **Name formats**
     * + **Function name** - `my-function`.
     * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
     * + **Partial ARN** - `123456789012:function:my-function`.
     *
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    val functionName: kotlin.String? = requireNotNull(builder.functionName) { "A non-null value must be provided for functionName" }
    /**
     * The alias name.
     */
    val qualifier: kotlin.String? = builder.qualifier

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.UpdateFunctionUrlConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFunctionUrlConfigRequest(")
        append("authType=$authType,")
        append("cors=$cors,")
        append("functionName=$functionName,")
        append("qualifier=$qualifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authType?.hashCode() ?: 0
        result = 31 * result + (cors?.hashCode() ?: 0)
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (qualifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFunctionUrlConfigRequest

        if (authType != other.authType) return false
        if (cors != other.cors) return false
        if (functionName != other.functionName) return false
        if (qualifier != other.qualifier) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.UpdateFunctionUrlConfigRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of authentication that your function URL uses. Set to `AWS_IAM` if you want to restrict access to authenticated `IAM` users only. Set to `NONE` if you want to bypass IAM authentication to create a public endpoint. For more information, see [ Security and auth model for Lambda function URLs](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html).
         */
        var authType: aws.sdk.kotlin.services.lambda.model.FunctionUrlAuthType? = null
        /**
         * The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for your function URL.
         */
        var cors: aws.sdk.kotlin.services.lambda.model.Cors? = null
        /**
         * The name of the Lambda function.
         *
         * **Name formats**
         * + **Function name** - `my-function`.
         * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
         * + **Partial ARN** - `123456789012:function:my-function`.
         *
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         */
        var functionName: kotlin.String? = null
        /**
         * The alias name.
         */
        var qualifier: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.UpdateFunctionUrlConfigRequest) : this() {
            this.authType = x.authType
            this.cors = x.cors
            this.functionName = x.functionName
            this.qualifier = x.qualifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.UpdateFunctionUrlConfigRequest = UpdateFunctionUrlConfigRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.Cors] inside the given [block]
         */
        fun cors(block: aws.sdk.kotlin.services.lambda.model.Cors.Builder.() -> kotlin.Unit) {
            this.cors = aws.sdk.kotlin.services.lambda.model.Cors.invoke(block)
        }
    }
}
