// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lambda.model.DestinationConfig
import aws.sdk.kotlin.services.lambda.model.GetFunctionEventInvokeConfigResponse
import aws.sdk.kotlin.services.lambda.model.LambdaException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetFunctionEventInvokeConfigOperationDeserializer: HttpDeserialize<GetFunctionEventInvokeConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetFunctionEventInvokeConfigResponse {
        if (!response.status.isSuccess()) {
            throwGetFunctionEventInvokeConfigError(context, response)
        }
        val builder = GetFunctionEventInvokeConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetFunctionEventInvokeConfigOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetFunctionEventInvokeConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LambdaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LambdaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetFunctionEventInvokeConfigOperationBody(builder: GetFunctionEventInvokeConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESTINATIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DestinationConfig"))
    val FUNCTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FunctionArn"))
    val LASTMODIFIED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModified"))
    val MAXIMUMEVENTAGEINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaximumEventAgeInSeconds"))
    val MAXIMUMRETRYATTEMPTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaximumRetryAttempts"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESTINATIONCONFIG_DESCRIPTOR)
        field(FUNCTIONARN_DESCRIPTOR)
        field(LASTMODIFIED_DESCRIPTOR)
        field(MAXIMUMEVENTAGEINSECONDS_DESCRIPTOR)
        field(MAXIMUMRETRYATTEMPTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESTINATIONCONFIG_DESCRIPTOR.index -> builder.destinationConfig = deserializeDestinationConfigDocument(deserializer)
                FUNCTIONARN_DESCRIPTOR.index -> builder.functionArn = deserializeString()
                LASTMODIFIED_DESCRIPTOR.index -> builder.lastModified = deserializeString().let { Instant.fromEpochSeconds(it) }
                MAXIMUMEVENTAGEINSECONDS_DESCRIPTOR.index -> builder.maximumEventAgeInSeconds = deserializeInt()
                MAXIMUMRETRYATTEMPTS_DESCRIPTOR.index -> builder.maximumRetryAttempts = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
