// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.transform

import aws.sdk.kotlin.services.lambda.model.InvocationType
import aws.sdk.kotlin.services.lambda.model.InvokeRequest
import aws.sdk.kotlin.services.lambda.model.LogType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class InvokeOperationSerializer: HttpSerialize<InvokeRequest> {
    override suspend fun serialize(context: ExecutionContext, input: InvokeRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "2015-03-31",
                "functions",
                "${input.functionName}".encodeLabel(),
                "invocations",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.qualifier != null) append("Qualifier", input.qualifier)
            }
        }

        builder.headers {
            if (input.clientContext?.isNotEmpty() == true) append("X-Amz-Client-Context", input.clientContext)
            if (input.invocationType != null) append("X-Amz-Invocation-Type", input.invocationType.value)
            if (input.logType != null) append("X-Amz-Log-Type", input.logType.value)
        }

        if (input.payload != null) {
            builder.body = ByteArrayContent(input.payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.payload == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
