// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.lambda.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.lambda.model.*
import aws.sdk.kotlin.services.lambda.model.AddLayerVersionPermissionRequest
import aws.sdk.kotlin.services.lambda.model.AddLayerVersionPermissionResponse
import aws.sdk.kotlin.services.lambda.model.AddPermissionRequest
import aws.sdk.kotlin.services.lambda.model.AddPermissionResponse
import aws.sdk.kotlin.services.lambda.model.CreateAliasRequest
import aws.sdk.kotlin.services.lambda.model.CreateAliasResponse
import aws.sdk.kotlin.services.lambda.model.CreateCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.CreateCodeSigningConfigResponse
import aws.sdk.kotlin.services.lambda.model.CreateEventSourceMappingRequest
import aws.sdk.kotlin.services.lambda.model.CreateEventSourceMappingResponse
import aws.sdk.kotlin.services.lambda.model.CreateFunctionRequest
import aws.sdk.kotlin.services.lambda.model.CreateFunctionResponse
import aws.sdk.kotlin.services.lambda.model.CreateFunctionUrlConfigRequest
import aws.sdk.kotlin.services.lambda.model.CreateFunctionUrlConfigResponse
import aws.sdk.kotlin.services.lambda.model.DeleteAliasRequest
import aws.sdk.kotlin.services.lambda.model.DeleteAliasResponse
import aws.sdk.kotlin.services.lambda.model.DeleteCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.DeleteCodeSigningConfigResponse
import aws.sdk.kotlin.services.lambda.model.DeleteEventSourceMappingRequest
import aws.sdk.kotlin.services.lambda.model.DeleteEventSourceMappingResponse
import aws.sdk.kotlin.services.lambda.model.DeleteFunctionCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.DeleteFunctionCodeSigningConfigResponse
import aws.sdk.kotlin.services.lambda.model.DeleteFunctionConcurrencyRequest
import aws.sdk.kotlin.services.lambda.model.DeleteFunctionConcurrencyResponse
import aws.sdk.kotlin.services.lambda.model.DeleteFunctionEventInvokeConfigRequest
import aws.sdk.kotlin.services.lambda.model.DeleteFunctionEventInvokeConfigResponse
import aws.sdk.kotlin.services.lambda.model.DeleteFunctionRequest
import aws.sdk.kotlin.services.lambda.model.DeleteFunctionResponse
import aws.sdk.kotlin.services.lambda.model.DeleteFunctionUrlConfigRequest
import aws.sdk.kotlin.services.lambda.model.DeleteFunctionUrlConfigResponse
import aws.sdk.kotlin.services.lambda.model.DeleteLayerVersionRequest
import aws.sdk.kotlin.services.lambda.model.DeleteLayerVersionResponse
import aws.sdk.kotlin.services.lambda.model.DeleteProvisionedConcurrencyConfigRequest
import aws.sdk.kotlin.services.lambda.model.DeleteProvisionedConcurrencyConfigResponse
import aws.sdk.kotlin.services.lambda.model.GetAccountSettingsRequest
import aws.sdk.kotlin.services.lambda.model.GetAccountSettingsResponse
import aws.sdk.kotlin.services.lambda.model.GetAliasRequest
import aws.sdk.kotlin.services.lambda.model.GetAliasResponse
import aws.sdk.kotlin.services.lambda.model.GetCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.GetCodeSigningConfigResponse
import aws.sdk.kotlin.services.lambda.model.GetEventSourceMappingRequest
import aws.sdk.kotlin.services.lambda.model.GetEventSourceMappingResponse
import aws.sdk.kotlin.services.lambda.model.GetFunctionCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.GetFunctionCodeSigningConfigResponse
import aws.sdk.kotlin.services.lambda.model.GetFunctionConcurrencyRequest
import aws.sdk.kotlin.services.lambda.model.GetFunctionConcurrencyResponse
import aws.sdk.kotlin.services.lambda.model.GetFunctionConfigurationRequest
import aws.sdk.kotlin.services.lambda.model.GetFunctionConfigurationResponse
import aws.sdk.kotlin.services.lambda.model.GetFunctionEventInvokeConfigRequest
import aws.sdk.kotlin.services.lambda.model.GetFunctionEventInvokeConfigResponse
import aws.sdk.kotlin.services.lambda.model.GetFunctionRequest
import aws.sdk.kotlin.services.lambda.model.GetFunctionResponse
import aws.sdk.kotlin.services.lambda.model.GetFunctionUrlConfigRequest
import aws.sdk.kotlin.services.lambda.model.GetFunctionUrlConfigResponse
import aws.sdk.kotlin.services.lambda.model.GetLayerVersionByArnRequest
import aws.sdk.kotlin.services.lambda.model.GetLayerVersionByArnResponse
import aws.sdk.kotlin.services.lambda.model.GetLayerVersionPolicyRequest
import aws.sdk.kotlin.services.lambda.model.GetLayerVersionPolicyResponse
import aws.sdk.kotlin.services.lambda.model.GetLayerVersionRequest
import aws.sdk.kotlin.services.lambda.model.GetLayerVersionResponse
import aws.sdk.kotlin.services.lambda.model.GetPolicyRequest
import aws.sdk.kotlin.services.lambda.model.GetPolicyResponse
import aws.sdk.kotlin.services.lambda.model.GetProvisionedConcurrencyConfigRequest
import aws.sdk.kotlin.services.lambda.model.GetProvisionedConcurrencyConfigResponse
import aws.sdk.kotlin.services.lambda.model.InvokeAsyncRequest
import aws.sdk.kotlin.services.lambda.model.InvokeAsyncResponse
import aws.sdk.kotlin.services.lambda.model.InvokeRequest
import aws.sdk.kotlin.services.lambda.model.InvokeResponse
import aws.sdk.kotlin.services.lambda.model.ListAliasesRequest
import aws.sdk.kotlin.services.lambda.model.ListAliasesResponse
import aws.sdk.kotlin.services.lambda.model.ListCodeSigningConfigsRequest
import aws.sdk.kotlin.services.lambda.model.ListCodeSigningConfigsResponse
import aws.sdk.kotlin.services.lambda.model.ListEventSourceMappingsRequest
import aws.sdk.kotlin.services.lambda.model.ListEventSourceMappingsResponse
import aws.sdk.kotlin.services.lambda.model.ListFunctionEventInvokeConfigsRequest
import aws.sdk.kotlin.services.lambda.model.ListFunctionEventInvokeConfigsResponse
import aws.sdk.kotlin.services.lambda.model.ListFunctionUrlConfigsRequest
import aws.sdk.kotlin.services.lambda.model.ListFunctionUrlConfigsResponse
import aws.sdk.kotlin.services.lambda.model.ListFunctionsByCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.ListFunctionsByCodeSigningConfigResponse
import aws.sdk.kotlin.services.lambda.model.ListFunctionsRequest
import aws.sdk.kotlin.services.lambda.model.ListFunctionsResponse
import aws.sdk.kotlin.services.lambda.model.ListLayerVersionsRequest
import aws.sdk.kotlin.services.lambda.model.ListLayerVersionsResponse
import aws.sdk.kotlin.services.lambda.model.ListLayersRequest
import aws.sdk.kotlin.services.lambda.model.ListLayersResponse
import aws.sdk.kotlin.services.lambda.model.ListProvisionedConcurrencyConfigsRequest
import aws.sdk.kotlin.services.lambda.model.ListProvisionedConcurrencyConfigsResponse
import aws.sdk.kotlin.services.lambda.model.ListTagsRequest
import aws.sdk.kotlin.services.lambda.model.ListTagsResponse
import aws.sdk.kotlin.services.lambda.model.ListVersionsByFunctionRequest
import aws.sdk.kotlin.services.lambda.model.ListVersionsByFunctionResponse
import aws.sdk.kotlin.services.lambda.model.PublishLayerVersionRequest
import aws.sdk.kotlin.services.lambda.model.PublishLayerVersionResponse
import aws.sdk.kotlin.services.lambda.model.PublishVersionRequest
import aws.sdk.kotlin.services.lambda.model.PublishVersionResponse
import aws.sdk.kotlin.services.lambda.model.PutFunctionCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.PutFunctionCodeSigningConfigResponse
import aws.sdk.kotlin.services.lambda.model.PutFunctionConcurrencyRequest
import aws.sdk.kotlin.services.lambda.model.PutFunctionConcurrencyResponse
import aws.sdk.kotlin.services.lambda.model.PutFunctionEventInvokeConfigRequest
import aws.sdk.kotlin.services.lambda.model.PutFunctionEventInvokeConfigResponse
import aws.sdk.kotlin.services.lambda.model.PutProvisionedConcurrencyConfigRequest
import aws.sdk.kotlin.services.lambda.model.PutProvisionedConcurrencyConfigResponse
import aws.sdk.kotlin.services.lambda.model.RemoveLayerVersionPermissionRequest
import aws.sdk.kotlin.services.lambda.model.RemoveLayerVersionPermissionResponse
import aws.sdk.kotlin.services.lambda.model.RemovePermissionRequest
import aws.sdk.kotlin.services.lambda.model.RemovePermissionResponse
import aws.sdk.kotlin.services.lambda.model.TagResourceRequest
import aws.sdk.kotlin.services.lambda.model.TagResourceResponse
import aws.sdk.kotlin.services.lambda.model.UntagResourceRequest
import aws.sdk.kotlin.services.lambda.model.UntagResourceResponse
import aws.sdk.kotlin.services.lambda.model.UpdateAliasRequest
import aws.sdk.kotlin.services.lambda.model.UpdateAliasResponse
import aws.sdk.kotlin.services.lambda.model.UpdateCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.UpdateCodeSigningConfigResponse
import aws.sdk.kotlin.services.lambda.model.UpdateEventSourceMappingRequest
import aws.sdk.kotlin.services.lambda.model.UpdateEventSourceMappingResponse
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionCodeRequest
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionCodeResponse
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionConfigurationRequest
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionConfigurationResponse
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionEventInvokeConfigRequest
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionEventInvokeConfigResponse
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionUrlConfigRequest
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionUrlConfigResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Lambda
 * **Overview**
 *
 * Lambda is a compute service that lets you run code without provisioning or managing servers. Lambda runs your code on a high-availability compute infrastructure and performs all of the administration of the compute resources, including server and operating system maintenance, capacity provisioning and automatic scaling, code monitoring and logging. With Lambda, you can run code for virtually any type of application or backend service. For more information about the Lambda service, see [What is Lambda](https://docs.aws.amazon.com/lambda/latest/dg/welcome.html) in the **Lambda Developer Guide**.
 *
 * The *Lambda API Reference* provides information about each of the API methods, including details about the parameters in each API request and response.
 *
 * You can use Software Development Kits (SDKs), Integrated Development Environment (IDE) Toolkits, and command line tools to access the API. For installation instructions, see [Tools for Amazon Web Services](http://aws.amazon.com/tools/).
 *
 * For a list of Region-specific endpoints that Lambda supports, see [Lambda endpoints and quotas ](https://docs.aws.amazon.com/general/latest/gr/lambda-service.html/) in the *Amazon Web Services General Reference.*.
 *
 * When making the API calls, you will need to authenticate your request by providing a signature. Lambda supports signature version 4. For more information, see [Signature Version 4 signing process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html) in the *Amazon Web Services General Reference.*.
 *
 * **CA certificates**
 *
 * Because Amazon Web Services SDKs use the CA certificates from your computer, changes to the certificates on the Amazon Web Services servers can cause connection failures when you attempt to use an SDK. You can prevent these failures by keeping your computer's CA certificates and operating system up-to-date. If you encounter this issue in a corporate environment and do not manage your own computer, you might need to ask an administrator to assist with the update process. The following list shows minimum operating system and Java versions:
 * + Microsoft Windows versions that have updates from January 2005 or later installed contain at least one of the required CAs in their trust list.
 * + Mac OS X 10.4 with Java for Mac OS X 10.4 Release 5 (February 2007), Mac OS X 10.5 (October 2007), and later versions contain at least one of the required CAs in their trust list.
 * + Red Hat Enterprise Linux 5 (March 2007), 6, and 7 and CentOS 5, 6, and 7 all contain at least one of the required CAs in their default trusted CA list.
 * + Java 1.4.2_12 (May 2006), 5 Update 2 (March 2005), and all later versions, including Java 6 (December 2006), 7, and 8, contain at least one of the required CAs in their default trusted CA list.
 *
 * When accessing the Lambda management console or Lambda API endpoints, whether through browsers or programmatically, you will need to ensure your client machines support any of the following CAs:
 * + Amazon Root CA 1
 * + Starfield Services Root Certificate Authority - G2
 * + Starfield Class 2 Certification Authority
 *
 * Root certificates from the first two authorities are available from [Amazon trust services](https://www.amazontrust.com/repository/), but keeping your computer up-to-date is the more straightforward solution. To learn more about ACM-provided certificates, see [Amazon Web Services Certificate Manager FAQs.](http://aws.amazon.com/certificate-manager/faqs/#certificates)
 */
public interface LambdaClient : SdkClient {

    override val serviceName: String
        get() = "Lambda"
    /**
     * LambdaClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): LambdaClient {
            val config = Config.Builder().apply(block).build()
            return DefaultLambdaClient(config)
        }

        public operator fun invoke(config: Config): LambdaClient = DefaultLambdaClient(config)

        /**
         * Construct a [LambdaClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): LambdaClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultLambdaClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds permissions to the resource-based policy of a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). Use this action to grant layer usage permission to other accounts. You can grant permission to a single account, all accounts in an organization, or all Amazon Web Services accounts.
     *
     * To revoke permission, call RemoveLayerVersionPermission with the statement ID that you specified when you added it.
     */
    public suspend fun addLayerVersionPermission(input: AddLayerVersionPermissionRequest): AddLayerVersionPermissionResponse

    /**
     * Grants an Amazon Web Services service, account, or organization permission to use a function. You can apply the policy at the function level, or specify a qualifier to restrict access to a single version or alias. If you use a qualifier, the invoker must use the full Amazon Resource Name (ARN) of that version or alias to invoke the function. Note: Lambda does not support adding policies to version $LATEST.
     *
     * To grant permission to another account, specify the account ID as the `Principal`. To grant permission to an organization defined in Organizations, specify the organization ID as the `PrincipalOrgID`. For Amazon Web Services services, the principal is a domain-style identifier defined by the service, like `s3.amazonaws.com` or `sns.amazonaws.com`. For Amazon Web Services services, you can also specify the ARN of the associated resource as the `SourceArn`. If you grant permission to a service principal without specifying the source, other accounts could potentially configure resources in their account to invoke your Lambda function.
     *
     * This action adds a statement to a resource-based permissions policy for the function. For more information about function policies, see [Lambda Function Policies](https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html).
     */
    public suspend fun addPermission(input: AddPermissionRequest): AddPermissionResponse

    /**
     * Creates an [alias](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html) for a Lambda function version. Use aliases to provide clients with a function identifier that you can update to invoke a different version.
     *
     * You can also map an alias to split invocation requests between two versions. Use the `RoutingConfig` parameter to specify a second version and the percentage of invocation requests that it receives.
     */
    public suspend fun createAlias(input: CreateAliasRequest): CreateAliasResponse

    /**
     * Creates a code signing configuration. A [code signing configuration](https://docs.aws.amazon.com/lambda/latest/dg/configuration-trustedcode.html) defines a list of allowed signing profiles and defines the code-signing validation policy (action to be taken if deployment validation checks fail).
     */
    public suspend fun createCodeSigningConfig(input: CreateCodeSigningConfigRequest): CreateCodeSigningConfigResponse

    /**
     * Creates a mapping between an event source and an Lambda function. Lambda reads items from the event source and triggers the function.
     *
     * For details about how to configure different event sources, see the following topics.
     * + [ Amazon DynamoDB Streams](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping)
     * + [ Amazon Kinesis](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping)
     * + [ Amazon SQS](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource)
     * + [ Amazon MQ and RabbitMQ](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping)
     * + [ Amazon MSK](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html)
     * + [ Apache Kafka](https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html)
     *
     * The following error handling options are only available for stream sources (DynamoDB and Kinesis):
     * + `BisectBatchOnFunctionError` - If the function returns an error, split the batch in two and retry.
     * + `DestinationConfig` - Send discarded records to an Amazon SQS queue or Amazon SNS topic.
     * + `MaximumRecordAgeInSeconds` - Discard records older than the specified age. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires
     * + `MaximumRetryAttempts` - Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     * + `ParallelizationFactor` - Process multiple batches from each shard concurrently.
     *
     * For information about which configuration parameters apply to each event source, see the following topics.
     * + [ Amazon DynamoDB Streams](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params)
     * + [ Amazon Kinesis](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params)
     * + [ Amazon SQS](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params)
     * + [ Amazon MQ and RabbitMQ](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params)
     * + [ Amazon MSK](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms)
     * + [ Apache Kafka](https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms)
     */
    public suspend fun createEventSourceMapping(input: CreateEventSourceMappingRequest): CreateEventSourceMappingResponse

    /**
     * Creates a Lambda function. To create a function, you need a [deployment package](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html) and an [execution role](https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role). The deployment package is a .zip file archive or container image that contains your function code. The execution role grants the function permission to use Amazon Web Services services, such as Amazon CloudWatch Logs for log streaming and X-Ray for request tracing.
     *
     * You set the package type to `Image` if the deployment package is a [container image](https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html). For a container image, the code property must include the URI of a container image in the Amazon ECR registry. You do not need to specify the handler and runtime properties.
     *
     * You set the package type to `Zip` if the deployment package is a [.zip file archive](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip). For a .zip file archive, the code property specifies the location of the .zip file. You must also specify the handler and runtime properties. The code in the deployment package must be compatible with the target instruction set architecture of the function (`x86-64` or `arm64`). If you do not specify the architecture, the default value is `x86-64`.
     *
     * When you create a function, Lambda provisions an instance of the function and its supporting resources. If your function connects to a VPC, this process can take a minute or so. During this time, you can't invoke or modify the function. The `State`, `StateReason`, and `StateReasonCode` fields in the response from GetFunctionConfiguration indicate when the function is ready to invoke. For more information, see [Function States](https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html).
     *
     * A function has an unpublished version, and can have published versions and aliases. The unpublished version changes when you update your function's code and configuration. A published version is a snapshot of your function code and configuration that can't be changed. An alias is a named resource that maps to a version, and can be changed to map to a different version. Use the `Publish` parameter to create version `1` of your function from its initial configuration.
     *
     * The other parameters let you configure version-specific and function-level settings. You can modify version-specific settings later with UpdateFunctionConfiguration. Function-level settings apply to both the unpublished and published versions of the function, and include tags (TagResource) and per-function concurrency limits (PutFunctionConcurrency).
     *
     * You can use code signing if your deployment package is a .zip file archive. To enable code signing for this function, specify the ARN of a code-signing configuration. When a user attempts to deploy a code package with UpdateFunctionCode, Lambda checks that the code package has a valid signature from a trusted publisher. The code-signing configuration includes set set of signing profiles, which define the trusted publishers for this function.
     *
     * If another account or an Amazon Web Services service invokes your function, use AddPermission to grant permission by creating a resource-based IAM policy. You can grant permissions at the function level, on a version, or on an alias.
     *
     * To invoke your function directly, use Invoke. To invoke your function in response to events in other Amazon Web Services services, create an event source mapping (CreateEventSourceMapping), or configure a function trigger in the other service. For more information, see [Invoking Functions](https://docs.aws.amazon.com/lambda/latest/dg/lambda-invocation.html).
     */
    public suspend fun createFunction(input: CreateFunctionRequest): CreateFunctionResponse

    /**
     * Creates a Lambda function URL with the specified configuration parameters. A function URL is a dedicated HTTP(S) endpoint that you can use to invoke your function.
     */
    public suspend fun createFunctionUrlConfig(input: CreateFunctionUrlConfigRequest): CreateFunctionUrlConfigResponse

    /**
     * Deletes a Lambda function [alias](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
     */
    public suspend fun deleteAlias(input: DeleteAliasRequest): DeleteAliasResponse

    /**
     * Deletes the code signing configuration. You can delete the code signing configuration only if no function is using it.
     */
    public suspend fun deleteCodeSigningConfig(input: DeleteCodeSigningConfigRequest): DeleteCodeSigningConfigResponse

    /**
     * Deletes an [event source mapping](https://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html). You can get the identifier of a mapping from the output of ListEventSourceMappings.
     *
     * When you delete an event source mapping, it enters a `Deleting` state and might not be completely deleted for several seconds.
     */
    public suspend fun deleteEventSourceMapping(input: DeleteEventSourceMappingRequest): DeleteEventSourceMappingResponse

    /**
     * Deletes a Lambda function. To delete a specific function version, use the `Qualifier` parameter. Otherwise, all versions and aliases are deleted.
     *
     * To delete Lambda event source mappings that invoke a function, use DeleteEventSourceMapping. For Amazon Web Services services and resources that invoke your function directly, delete the trigger in the service where you originally configured it.
     */
    public suspend fun deleteFunction(input: DeleteFunctionRequest): DeleteFunctionResponse

    /**
     * Removes the code signing configuration from the function.
     */
    public suspend fun deleteFunctionCodeSigningConfig(input: DeleteFunctionCodeSigningConfigRequest): DeleteFunctionCodeSigningConfigResponse

    /**
     * Removes a concurrent execution limit from a function.
     */
    public suspend fun deleteFunctionConcurrency(input: DeleteFunctionConcurrencyRequest): DeleteFunctionConcurrencyResponse

    /**
     * Deletes the configuration for asynchronous invocation for a function, version, or alias.
     *
     * To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
     */
    public suspend fun deleteFunctionEventInvokeConfig(input: DeleteFunctionEventInvokeConfigRequest): DeleteFunctionEventInvokeConfigResponse

    /**
     * Deletes a Lambda function URL. When you delete a function URL, you can't recover it. Creating a new function URL results in a different URL address.
     */
    public suspend fun deleteFunctionUrlConfig(input: DeleteFunctionUrlConfigRequest): DeleteFunctionUrlConfigResponse

    /**
     * Deletes a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a copy of the version remains in Lambda until no functions refer to it.
     */
    public suspend fun deleteLayerVersion(input: DeleteLayerVersionRequest): DeleteLayerVersionResponse

    /**
     * Deletes the provisioned concurrency configuration for a function.
     */
    public suspend fun deleteProvisionedConcurrencyConfig(input: DeleteProvisionedConcurrencyConfigRequest): DeleteProvisionedConcurrencyConfigResponse

    /**
     * Retrieves details about your account's [limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html) and usage in an Amazon Web Services Region.
     */
    public suspend fun getAccountSettings(input: GetAccountSettingsRequest = GetAccountSettingsRequest {}): GetAccountSettingsResponse

    /**
     * Returns details about a Lambda function [alias](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
     */
    public suspend fun getAlias(input: GetAliasRequest): GetAliasResponse

    /**
     * Returns information about the specified code signing configuration.
     */
    public suspend fun getCodeSigningConfig(input: GetCodeSigningConfigRequest): GetCodeSigningConfigResponse

    /**
     * Returns details about an event source mapping. You can get the identifier of a mapping from the output of ListEventSourceMappings.
     */
    public suspend fun getEventSourceMapping(input: GetEventSourceMappingRequest): GetEventSourceMappingResponse

    /**
     * Returns information about the function or function version, with a link to download the deployment package that's valid for 10 minutes. If you specify a function version, only details that are specific to that version are returned.
     */
    public suspend fun getFunction(input: GetFunctionRequest): GetFunctionResponse

    /**
     * Returns the code signing configuration for the specified function.
     */
    public suspend fun getFunctionCodeSigningConfig(input: GetFunctionCodeSigningConfigRequest): GetFunctionCodeSigningConfigResponse

    /**
     * Returns details about the reserved concurrency configuration for a function. To set a concurrency limit for a function, use PutFunctionConcurrency.
     */
    public suspend fun getFunctionConcurrency(input: GetFunctionConcurrencyRequest): GetFunctionConcurrencyResponse

    /**
     * Returns the version-specific settings of a Lambda function or version. The output includes only options that can vary between versions of a function. To modify these settings, use UpdateFunctionConfiguration.
     *
     * To get all of a function's details, including function-level settings, use GetFunction.
     */
    public suspend fun getFunctionConfiguration(input: GetFunctionConfigurationRequest): GetFunctionConfigurationResponse

    /**
     * Retrieves the configuration for asynchronous invocation for a function, version, or alias.
     *
     * To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
     */
    public suspend fun getFunctionEventInvokeConfig(input: GetFunctionEventInvokeConfigRequest): GetFunctionEventInvokeConfigResponse

    /**
     * Returns details about a Lambda function URL.
     */
    public suspend fun getFunctionUrlConfig(input: GetFunctionUrlConfigRequest): GetFunctionUrlConfigResponse

    /**
     * Returns information about a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html), with a link to download the layer archive that's valid for 10 minutes.
     */
    public suspend fun getLayerVersion(input: GetLayerVersionRequest): GetLayerVersionResponse

    /**
     * Returns information about a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html), with a link to download the layer archive that's valid for 10 minutes.
     */
    public suspend fun getLayerVersionByArn(input: GetLayerVersionByArnRequest): GetLayerVersionByArnResponse

    /**
     * Returns the permission policy for a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). For more information, see AddLayerVersionPermission.
     */
    public suspend fun getLayerVersionPolicy(input: GetLayerVersionPolicyRequest): GetLayerVersionPolicyResponse

    /**
     * Returns the [resource-based IAM policy](https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html) for a function, version, or alias.
     */
    public suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse

    /**
     * Retrieves the provisioned concurrency configuration for a function's alias or version.
     */
    public suspend fun getProvisionedConcurrencyConfig(input: GetProvisionedConcurrencyConfigRequest): GetProvisionedConcurrencyConfigResponse

    /**
     * Invokes a Lambda function. You can invoke a function synchronously (and wait for the response), or asynchronously. To invoke a function asynchronously, set `InvocationType` to `Event`.
     *
     * For [synchronous invocation](https://docs.aws.amazon.com/lambda/latest/dg/invocation-sync.html), details about the function response, including errors, are included in the response body and headers. For either invocation type, you can find more information in the [execution log](https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html) and [trace](https://docs.aws.amazon.com/lambda/latest/dg/lambda-x-ray.html).
     *
     * When an error occurs, your function may be invoked multiple times. Retry behavior varies by error type, client, event source, and invocation type. For example, if you invoke a function asynchronously and it returns an error, Lambda executes the function up to two more times. For more information, see [Retry Behavior](https://docs.aws.amazon.com/lambda/latest/dg/retries-on-errors.html).
     *
     * For [asynchronous invocation](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html), Lambda adds events to a queue before sending them to your function. If your function does not have enough capacity to keep up with the queue, events may be lost. Occasionally, your function may receive the same event multiple times, even if no error occurs. To retain events that were not processed, configure your function with a [dead-letter queue](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq).
     *
     * The status code in the API response doesn't reflect function errors. Error codes are reserved for errors that prevent your function from executing, such as permissions errors, [limit errors](https://docs.aws.amazon.com/lambda/latest/dg/limits.html), or issues with your function's code and configuration. For example, Lambda returns `TooManyRequestsException` if executing the function would cause you to exceed a concurrency limit at either the account level (`ConcurrentInvocationLimitExceeded`) or function level (`ReservedFunctionConcurrentInvocationLimitExceeded`).
     *
     * For functions with a long timeout, your client might be disconnected during synchronous invocation while it waits for a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long connections with timeout or keep-alive settings.
     *
     * This operation requires permission for the [lambda:InvokeFunction](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslambda.html) action.
     */
    public suspend fun invoke(input: InvokeRequest): InvokeResponse

    /**
     * For asynchronous function invocation, use Invoke.
     *
     * Invokes a function asynchronously.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun invokeAsync(input: InvokeAsyncRequest): InvokeAsyncResponse

    /**
     * Returns a list of [aliases](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html) for a Lambda function.
     */
    public suspend fun listAliases(input: ListAliasesRequest): ListAliasesResponse

    /**
     * Returns a list of [code signing configurations](https://docs.aws.amazon.com/lambda/latest/dg/configuring-codesigning.html). A request returns up to 10,000 configurations per call. You can use the `MaxItems` parameter to return fewer configurations per call.
     */
    public suspend fun listCodeSigningConfigs(input: ListCodeSigningConfigsRequest = ListCodeSigningConfigsRequest {}): ListCodeSigningConfigsResponse

    /**
     * Lists event source mappings. Specify an `EventSourceArn` to only show event source mappings for a single event source.
     */
    public suspend fun listEventSourceMappings(input: ListEventSourceMappingsRequest = ListEventSourceMappingsRequest {}): ListEventSourceMappingsResponse

    /**
     * Retrieves a list of configurations for asynchronous invocation for a function.
     *
     * To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
     */
    public suspend fun listFunctionEventInvokeConfigs(input: ListFunctionEventInvokeConfigsRequest): ListFunctionEventInvokeConfigsResponse

    /**
     * Returns a list of Lambda function URLs for the specified function.
     */
    public suspend fun listFunctionUrlConfigs(input: ListFunctionUrlConfigsRequest): ListFunctionUrlConfigsResponse

    /**
     * Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50 functions per call.
     *
     * Set `FunctionVersion` to `ALL` to include all published versions of each function in addition to the unpublished version.
     *
     * The `ListFunctions` action returns a subset of the FunctionConfiguration fields. To get the additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason, LastUpdateStatusReasonCode) for a function or version, use GetFunction.
     */
    public suspend fun listFunctions(input: ListFunctionsRequest = ListFunctionsRequest {}): ListFunctionsResponse

    /**
     * List the functions that use the specified code signing configuration. You can use this method prior to deleting a code signing configuration, to verify that no functions are using it.
     */
    public suspend fun listFunctionsByCodeSigningConfig(input: ListFunctionsByCodeSigningConfigRequest): ListFunctionsByCodeSigningConfigResponse

    /**
     * Lists the versions of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). Versions that have been deleted aren't listed. Specify a [runtime identifier](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) to list only versions that indicate that they're compatible with that runtime. Specify a compatible architecture to include only layer versions that are compatible with that architecture.
     */
    public suspend fun listLayerVersions(input: ListLayerVersionsRequest): ListLayerVersionsResponse

    /**
     * Lists [Lambda layers](https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html) and shows information about the latest version of each. Specify a [runtime identifier](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) to list only layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only layers that are compatible with that [instruction set architecture](https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html).
     */
    public suspend fun listLayers(input: ListLayersRequest = ListLayersRequest {}): ListLayersResponse

    /**
     * Retrieves a list of provisioned concurrency configurations for a function.
     */
    public suspend fun listProvisionedConcurrencyConfigs(input: ListProvisionedConcurrencyConfigsRequest): ListProvisionedConcurrencyConfigsResponse

    /**
     * Returns a function's [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html). You can also view tags with GetFunction.
     */
    public suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Returns a list of [versions](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html), with the version-specific configuration of each. Lambda returns up to 50 versions per call.
     */
    public suspend fun listVersionsByFunction(input: ListVersionsByFunctionRequest): ListVersionsByFunctionResponse

    /**
     * Creates an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html) from a ZIP archive. Each time you call `PublishLayerVersion` with the same layer name, a new version is created.
     *
     * Add layers to your function with CreateFunction or UpdateFunctionConfiguration.
     */
    public suspend fun publishLayerVersion(input: PublishLayerVersionRequest): PublishLayerVersionResponse

    /**
     * Creates a [version](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html) from the current code and configuration of a function. Use versions to create a snapshot of your function code and configuration that doesn't change.
     *
     * Lambda doesn't publish a version if the function's configuration and code haven't changed since the last version. Use UpdateFunctionCode or UpdateFunctionConfiguration to update the function before publishing a version.
     *
     * Clients can invoke versions directly or with an alias. To create an alias, use CreateAlias.
     */
    public suspend fun publishVersion(input: PublishVersionRequest): PublishVersionResponse

    /**
     * Update the code signing configuration for the function. Changes to the code signing configuration take effect the next time a user tries to deploy a code package to the function.
     */
    public suspend fun putFunctionCodeSigningConfig(input: PutFunctionCodeSigningConfigRequest): PutFunctionCodeSigningConfigResponse

    /**
     * Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency level.
     *
     * Concurrency settings apply to the function as a whole, including all published versions and the unpublished version. Reserving concurrency both ensures that your function has capacity to process the specified number of events simultaneously, and prevents it from scaling beyond that level. Use GetFunction to see the current setting for a function.
     *
     * Use GetAccountSettings to see your Regional concurrency limit. You can reserve concurrency for as many functions as you like, as long as you leave at least 100 simultaneous executions unreserved for functions that aren't configured with a per-function limit. For more information, see [Managing Concurrency](https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
     */
    public suspend fun putFunctionConcurrency(input: PutFunctionConcurrencyRequest): PutFunctionConcurrencyResponse

    /**
     * Configures options for [asynchronous invocation](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html) on a function, version, or alias. If a configuration already exists for a function, version, or alias, this operation overwrites it. If you exclude any settings, they are removed. To set one option without affecting existing settings for other options, use UpdateFunctionEventInvokeConfig.
     *
     * By default, Lambda retries an asynchronous invocation twice if the function returns an error. It retains events in a queue for up to six hours. When an event fails all processing attempts or stays in the asynchronous invocation queue for too long, Lambda discards it. To retain discarded events, configure a dead-letter queue with UpdateFunctionConfiguration.
     *
     * To send an invocation record to a queue, topic, function, or event bus, specify a [destination](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations). You can configure separate destinations for successful invocations (on-success) and events that fail all processing attempts (on-failure). You can configure destinations in addition to or instead of a dead-letter queue.
     */
    public suspend fun putFunctionEventInvokeConfig(input: PutFunctionEventInvokeConfigRequest): PutFunctionEventInvokeConfigResponse

    /**
     * Adds a provisioned concurrency configuration to a function's alias or version.
     */
    public suspend fun putProvisionedConcurrencyConfig(input: PutProvisionedConcurrencyConfigRequest): PutProvisionedConcurrencyConfigResponse

    /**
     * Removes a statement from the permissions policy for a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). For more information, see AddLayerVersionPermission.
     */
    public suspend fun removeLayerVersionPermission(input: RemoveLayerVersionPermissionRequest): RemoveLayerVersionPermissionResponse

    /**
     * Revokes function-use permission from an Amazon Web Services service or another account. You can get the ID of the statement from the output of GetPolicy.
     */
    public suspend fun removePermission(input: RemovePermissionRequest): RemovePermissionResponse

    /**
     * Adds [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) to a function.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) from a function.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the configuration of a Lambda function [alias](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
     */
    public suspend fun updateAlias(input: UpdateAliasRequest): UpdateAliasResponse

    /**
     * Update the code signing configuration. Changes to the code signing configuration take effect the next time a user tries to deploy a code package to the function.
     */
    public suspend fun updateCodeSigningConfig(input: UpdateCodeSigningConfigRequest): UpdateCodeSigningConfigResponse

    /**
     * Updates an event source mapping. You can change the function that Lambda invokes, or pause invocation and resume later from the same location.
     *
     * For details about how to configure different event sources, see the following topics.
     * + [ Amazon DynamoDB Streams](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping)
     * + [ Amazon Kinesis](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping)
     * + [ Amazon SQS](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource)
     * + [ Amazon MQ and RabbitMQ](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping)
     * + [ Amazon MSK](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html)
     * + [ Apache Kafka](https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html)
     *
     * The following error handling options are only available for stream sources (DynamoDB and Kinesis):
     * + `BisectBatchOnFunctionError` - If the function returns an error, split the batch in two and retry.
     * + `DestinationConfig` - Send discarded records to an Amazon SQS queue or Amazon SNS topic.
     * + `MaximumRecordAgeInSeconds` - Discard records older than the specified age. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires
     * + `MaximumRetryAttempts` - Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     * + `ParallelizationFactor` - Process multiple batches from each shard concurrently.
     *
     * For information about which configuration parameters apply to each event source, see the following topics.
     * + [ Amazon DynamoDB Streams](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params)
     * + [ Amazon Kinesis](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params)
     * + [ Amazon SQS](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params)
     * + [ Amazon MQ and RabbitMQ](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params)
     * + [ Amazon MSK](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms)
     * + [ Apache Kafka](https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms)
     */
    public suspend fun updateEventSourceMapping(input: UpdateEventSourceMappingRequest): UpdateEventSourceMappingResponse

    /**
     * Updates a Lambda function's code. If code signing is enabled for the function, the code package must be signed by a trusted publisher. For more information, see [Configuring code signing](https://docs.aws.amazon.com/lambda/latest/dg/configuration-trustedcode.html).
     *
     * If the function's package type is `Image`, you must specify the code package in `ImageUri` as the URI of a [container image](https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html) in the Amazon ECR registry.
     *
     * If the function's package type is `Zip`, you must specify the deployment package as a [.zip file archive](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip). Enter the Amazon S3 bucket and key of the code .zip file location. You can also provide the function code inline using the `ZipFile` field.
     *
     * The code in the deployment package must be compatible with the target instruction set architecture of the function (`x86-64` or `arm64`).
     *
     * The function's code is locked when you publish a version. You can't modify the code of a published version, only the unpublished version.
     *
     * For a function defined as a container image, Lambda resolves the image tag to an image digest. In Amazon ECR, if you update the image tag to a new image, Lambda does not automatically update the function.
     */
    public suspend fun updateFunctionCode(input: UpdateFunctionCodeRequest): UpdateFunctionCodeResponse

    /**
     * Modify the version-specific settings of a Lambda function.
     *
     * When you update a function, Lambda provisions an instance of the function and its supporting resources. If your function connects to a VPC, this process can take a minute. During this time, you can't modify the function, but you can still invoke it. The `LastUpdateStatus`, `LastUpdateStatusReason`, and `LastUpdateStatusReasonCode` fields in the response from GetFunctionConfiguration indicate when the update is complete and the function is processing events with the new configuration. For more information, see [Function States](https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html).
     *
     * These settings can vary between versions of a function and are locked when you publish a version. You can't modify the configuration of a published version, only the unpublished version.
     *
     * To configure function concurrency, use PutFunctionConcurrency. To grant invoke permissions to an account or Amazon Web Services service, use AddPermission.
     */
    public suspend fun updateFunctionConfiguration(input: UpdateFunctionConfigurationRequest): UpdateFunctionConfigurationResponse

    /**
     * Updates the configuration for asynchronous invocation for a function, version, or alias.
     *
     * To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
     */
    public suspend fun updateFunctionEventInvokeConfig(input: UpdateFunctionEventInvokeConfigRequest): UpdateFunctionEventInvokeConfigResponse

    /**
     * Updates the configuration for a Lambda function URL.
     */
    public suspend fun updateFunctionUrlConfig(input: UpdateFunctionUrlConfigRequest): UpdateFunctionUrlConfigResponse
}

/**
 * Adds permissions to the resource-based policy of a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). Use this action to grant layer usage permission to other accounts. You can grant permission to a single account, all accounts in an organization, or all Amazon Web Services accounts.
 *
 * To revoke permission, call RemoveLayerVersionPermission with the statement ID that you specified when you added it.
 */
public suspend inline fun LambdaClient.addLayerVersionPermission(crossinline block: AddLayerVersionPermissionRequest.Builder.() -> Unit): AddLayerVersionPermissionResponse = addLayerVersionPermission(AddLayerVersionPermissionRequest.Builder().apply(block).build())

/**
 * Grants an Amazon Web Services service, account, or organization permission to use a function. You can apply the policy at the function level, or specify a qualifier to restrict access to a single version or alias. If you use a qualifier, the invoker must use the full Amazon Resource Name (ARN) of that version or alias to invoke the function. Note: Lambda does not support adding policies to version $LATEST.
 *
 * To grant permission to another account, specify the account ID as the `Principal`. To grant permission to an organization defined in Organizations, specify the organization ID as the `PrincipalOrgID`. For Amazon Web Services services, the principal is a domain-style identifier defined by the service, like `s3.amazonaws.com` or `sns.amazonaws.com`. For Amazon Web Services services, you can also specify the ARN of the associated resource as the `SourceArn`. If you grant permission to a service principal without specifying the source, other accounts could potentially configure resources in their account to invoke your Lambda function.
 *
 * This action adds a statement to a resource-based permissions policy for the function. For more information about function policies, see [Lambda Function Policies](https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html).
 */
public suspend inline fun LambdaClient.addPermission(crossinline block: AddPermissionRequest.Builder.() -> Unit): AddPermissionResponse = addPermission(AddPermissionRequest.Builder().apply(block).build())

/**
 * Creates an [alias](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html) for a Lambda function version. Use aliases to provide clients with a function identifier that you can update to invoke a different version.
 *
 * You can also map an alias to split invocation requests between two versions. Use the `RoutingConfig` parameter to specify a second version and the percentage of invocation requests that it receives.
 */
public suspend inline fun LambdaClient.createAlias(crossinline block: CreateAliasRequest.Builder.() -> Unit): CreateAliasResponse = createAlias(CreateAliasRequest.Builder().apply(block).build())

/**
 * Creates a code signing configuration. A [code signing configuration](https://docs.aws.amazon.com/lambda/latest/dg/configuration-trustedcode.html) defines a list of allowed signing profiles and defines the code-signing validation policy (action to be taken if deployment validation checks fail).
 */
public suspend inline fun LambdaClient.createCodeSigningConfig(crossinline block: CreateCodeSigningConfigRequest.Builder.() -> Unit): CreateCodeSigningConfigResponse = createCodeSigningConfig(CreateCodeSigningConfigRequest.Builder().apply(block).build())

/**
 * Creates a mapping between an event source and an Lambda function. Lambda reads items from the event source and triggers the function.
 *
 * For details about how to configure different event sources, see the following topics.
 * + [ Amazon DynamoDB Streams](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping)
 * + [ Amazon Kinesis](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping)
 * + [ Amazon SQS](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource)
 * + [ Amazon MQ and RabbitMQ](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping)
 * + [ Amazon MSK](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html)
 * + [ Apache Kafka](https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html)
 *
 * The following error handling options are only available for stream sources (DynamoDB and Kinesis):
 * + `BisectBatchOnFunctionError` - If the function returns an error, split the batch in two and retry.
 * + `DestinationConfig` - Send discarded records to an Amazon SQS queue or Amazon SNS topic.
 * + `MaximumRecordAgeInSeconds` - Discard records older than the specified age. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires
 * + `MaximumRetryAttempts` - Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
 * + `ParallelizationFactor` - Process multiple batches from each shard concurrently.
 *
 * For information about which configuration parameters apply to each event source, see the following topics.
 * + [ Amazon DynamoDB Streams](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params)
 * + [ Amazon Kinesis](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params)
 * + [ Amazon SQS](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params)
 * + [ Amazon MQ and RabbitMQ](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params)
 * + [ Amazon MSK](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms)
 * + [ Apache Kafka](https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms)
 */
public suspend inline fun LambdaClient.createEventSourceMapping(crossinline block: CreateEventSourceMappingRequest.Builder.() -> Unit): CreateEventSourceMappingResponse = createEventSourceMapping(CreateEventSourceMappingRequest.Builder().apply(block).build())

/**
 * Creates a Lambda function. To create a function, you need a [deployment package](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html) and an [execution role](https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role). The deployment package is a .zip file archive or container image that contains your function code. The execution role grants the function permission to use Amazon Web Services services, such as Amazon CloudWatch Logs for log streaming and X-Ray for request tracing.
 *
 * You set the package type to `Image` if the deployment package is a [container image](https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html). For a container image, the code property must include the URI of a container image in the Amazon ECR registry. You do not need to specify the handler and runtime properties.
 *
 * You set the package type to `Zip` if the deployment package is a [.zip file archive](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip). For a .zip file archive, the code property specifies the location of the .zip file. You must also specify the handler and runtime properties. The code in the deployment package must be compatible with the target instruction set architecture of the function (`x86-64` or `arm64`). If you do not specify the architecture, the default value is `x86-64`.
 *
 * When you create a function, Lambda provisions an instance of the function and its supporting resources. If your function connects to a VPC, this process can take a minute or so. During this time, you can't invoke or modify the function. The `State`, `StateReason`, and `StateReasonCode` fields in the response from GetFunctionConfiguration indicate when the function is ready to invoke. For more information, see [Function States](https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html).
 *
 * A function has an unpublished version, and can have published versions and aliases. The unpublished version changes when you update your function's code and configuration. A published version is a snapshot of your function code and configuration that can't be changed. An alias is a named resource that maps to a version, and can be changed to map to a different version. Use the `Publish` parameter to create version `1` of your function from its initial configuration.
 *
 * The other parameters let you configure version-specific and function-level settings. You can modify version-specific settings later with UpdateFunctionConfiguration. Function-level settings apply to both the unpublished and published versions of the function, and include tags (TagResource) and per-function concurrency limits (PutFunctionConcurrency).
 *
 * You can use code signing if your deployment package is a .zip file archive. To enable code signing for this function, specify the ARN of a code-signing configuration. When a user attempts to deploy a code package with UpdateFunctionCode, Lambda checks that the code package has a valid signature from a trusted publisher. The code-signing configuration includes set set of signing profiles, which define the trusted publishers for this function.
 *
 * If another account or an Amazon Web Services service invokes your function, use AddPermission to grant permission by creating a resource-based IAM policy. You can grant permissions at the function level, on a version, or on an alias.
 *
 * To invoke your function directly, use Invoke. To invoke your function in response to events in other Amazon Web Services services, create an event source mapping (CreateEventSourceMapping), or configure a function trigger in the other service. For more information, see [Invoking Functions](https://docs.aws.amazon.com/lambda/latest/dg/lambda-invocation.html).
 */
public suspend inline fun LambdaClient.createFunction(crossinline block: CreateFunctionRequest.Builder.() -> Unit): CreateFunctionResponse = createFunction(CreateFunctionRequest.Builder().apply(block).build())

/**
 * Creates a Lambda function URL with the specified configuration parameters. A function URL is a dedicated HTTP(S) endpoint that you can use to invoke your function.
 */
public suspend inline fun LambdaClient.createFunctionUrlConfig(crossinline block: CreateFunctionUrlConfigRequest.Builder.() -> Unit): CreateFunctionUrlConfigResponse = createFunctionUrlConfig(CreateFunctionUrlConfigRequest.Builder().apply(block).build())

/**
 * Deletes a Lambda function [alias](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
 */
public suspend inline fun LambdaClient.deleteAlias(crossinline block: DeleteAliasRequest.Builder.() -> Unit): DeleteAliasResponse = deleteAlias(DeleteAliasRequest.Builder().apply(block).build())

/**
 * Deletes the code signing configuration. You can delete the code signing configuration only if no function is using it.
 */
public suspend inline fun LambdaClient.deleteCodeSigningConfig(crossinline block: DeleteCodeSigningConfigRequest.Builder.() -> Unit): DeleteCodeSigningConfigResponse = deleteCodeSigningConfig(DeleteCodeSigningConfigRequest.Builder().apply(block).build())

/**
 * Deletes an [event source mapping](https://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html). You can get the identifier of a mapping from the output of ListEventSourceMappings.
 *
 * When you delete an event source mapping, it enters a `Deleting` state and might not be completely deleted for several seconds.
 */
public suspend inline fun LambdaClient.deleteEventSourceMapping(crossinline block: DeleteEventSourceMappingRequest.Builder.() -> Unit): DeleteEventSourceMappingResponse = deleteEventSourceMapping(DeleteEventSourceMappingRequest.Builder().apply(block).build())

/**
 * Deletes a Lambda function. To delete a specific function version, use the `Qualifier` parameter. Otherwise, all versions and aliases are deleted.
 *
 * To delete Lambda event source mappings that invoke a function, use DeleteEventSourceMapping. For Amazon Web Services services and resources that invoke your function directly, delete the trigger in the service where you originally configured it.
 */
public suspend inline fun LambdaClient.deleteFunction(crossinline block: DeleteFunctionRequest.Builder.() -> Unit): DeleteFunctionResponse = deleteFunction(DeleteFunctionRequest.Builder().apply(block).build())

/**
 * Removes the code signing configuration from the function.
 */
public suspend inline fun LambdaClient.deleteFunctionCodeSigningConfig(crossinline block: DeleteFunctionCodeSigningConfigRequest.Builder.() -> Unit): DeleteFunctionCodeSigningConfigResponse = deleteFunctionCodeSigningConfig(DeleteFunctionCodeSigningConfigRequest.Builder().apply(block).build())

/**
 * Removes a concurrent execution limit from a function.
 */
public suspend inline fun LambdaClient.deleteFunctionConcurrency(crossinline block: DeleteFunctionConcurrencyRequest.Builder.() -> Unit): DeleteFunctionConcurrencyResponse = deleteFunctionConcurrency(DeleteFunctionConcurrencyRequest.Builder().apply(block).build())

/**
 * Deletes the configuration for asynchronous invocation for a function, version, or alias.
 *
 * To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
 */
public suspend inline fun LambdaClient.deleteFunctionEventInvokeConfig(crossinline block: DeleteFunctionEventInvokeConfigRequest.Builder.() -> Unit): DeleteFunctionEventInvokeConfigResponse = deleteFunctionEventInvokeConfig(DeleteFunctionEventInvokeConfigRequest.Builder().apply(block).build())

/**
 * Deletes a Lambda function URL. When you delete a function URL, you can't recover it. Creating a new function URL results in a different URL address.
 */
public suspend inline fun LambdaClient.deleteFunctionUrlConfig(crossinline block: DeleteFunctionUrlConfigRequest.Builder.() -> Unit): DeleteFunctionUrlConfigResponse = deleteFunctionUrlConfig(DeleteFunctionUrlConfigRequest.Builder().apply(block).build())

/**
 * Deletes a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a copy of the version remains in Lambda until no functions refer to it.
 */
public suspend inline fun LambdaClient.deleteLayerVersion(crossinline block: DeleteLayerVersionRequest.Builder.() -> Unit): DeleteLayerVersionResponse = deleteLayerVersion(DeleteLayerVersionRequest.Builder().apply(block).build())

/**
 * Deletes the provisioned concurrency configuration for a function.
 */
public suspend inline fun LambdaClient.deleteProvisionedConcurrencyConfig(crossinline block: DeleteProvisionedConcurrencyConfigRequest.Builder.() -> Unit): DeleteProvisionedConcurrencyConfigResponse = deleteProvisionedConcurrencyConfig(DeleteProvisionedConcurrencyConfigRequest.Builder().apply(block).build())

/**
 * Retrieves details about your account's [limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html) and usage in an Amazon Web Services Region.
 */
public suspend inline fun LambdaClient.getAccountSettings(crossinline block: GetAccountSettingsRequest.Builder.() -> Unit): GetAccountSettingsResponse = getAccountSettings(GetAccountSettingsRequest.Builder().apply(block).build())

/**
 * Returns details about a Lambda function [alias](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
 */
public suspend inline fun LambdaClient.getAlias(crossinline block: GetAliasRequest.Builder.() -> Unit): GetAliasResponse = getAlias(GetAliasRequest.Builder().apply(block).build())

/**
 * Returns information about the specified code signing configuration.
 */
public suspend inline fun LambdaClient.getCodeSigningConfig(crossinline block: GetCodeSigningConfigRequest.Builder.() -> Unit): GetCodeSigningConfigResponse = getCodeSigningConfig(GetCodeSigningConfigRequest.Builder().apply(block).build())

/**
 * Returns details about an event source mapping. You can get the identifier of a mapping from the output of ListEventSourceMappings.
 */
public suspend inline fun LambdaClient.getEventSourceMapping(crossinline block: GetEventSourceMappingRequest.Builder.() -> Unit): GetEventSourceMappingResponse = getEventSourceMapping(GetEventSourceMappingRequest.Builder().apply(block).build())

/**
 * Returns information about the function or function version, with a link to download the deployment package that's valid for 10 minutes. If you specify a function version, only details that are specific to that version are returned.
 */
public suspend inline fun LambdaClient.getFunction(crossinline block: GetFunctionRequest.Builder.() -> Unit): GetFunctionResponse = getFunction(GetFunctionRequest.Builder().apply(block).build())

/**
 * Returns the code signing configuration for the specified function.
 */
public suspend inline fun LambdaClient.getFunctionCodeSigningConfig(crossinline block: GetFunctionCodeSigningConfigRequest.Builder.() -> Unit): GetFunctionCodeSigningConfigResponse = getFunctionCodeSigningConfig(GetFunctionCodeSigningConfigRequest.Builder().apply(block).build())

/**
 * Returns details about the reserved concurrency configuration for a function. To set a concurrency limit for a function, use PutFunctionConcurrency.
 */
public suspend inline fun LambdaClient.getFunctionConcurrency(crossinline block: GetFunctionConcurrencyRequest.Builder.() -> Unit): GetFunctionConcurrencyResponse = getFunctionConcurrency(GetFunctionConcurrencyRequest.Builder().apply(block).build())

/**
 * Returns the version-specific settings of a Lambda function or version. The output includes only options that can vary between versions of a function. To modify these settings, use UpdateFunctionConfiguration.
 *
 * To get all of a function's details, including function-level settings, use GetFunction.
 */
public suspend inline fun LambdaClient.getFunctionConfiguration(crossinline block: GetFunctionConfigurationRequest.Builder.() -> Unit): GetFunctionConfigurationResponse = getFunctionConfiguration(GetFunctionConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves the configuration for asynchronous invocation for a function, version, or alias.
 *
 * To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
 */
public suspend inline fun LambdaClient.getFunctionEventInvokeConfig(crossinline block: GetFunctionEventInvokeConfigRequest.Builder.() -> Unit): GetFunctionEventInvokeConfigResponse = getFunctionEventInvokeConfig(GetFunctionEventInvokeConfigRequest.Builder().apply(block).build())

/**
 * Returns details about a Lambda function URL.
 */
public suspend inline fun LambdaClient.getFunctionUrlConfig(crossinline block: GetFunctionUrlConfigRequest.Builder.() -> Unit): GetFunctionUrlConfigResponse = getFunctionUrlConfig(GetFunctionUrlConfigRequest.Builder().apply(block).build())

/**
 * Returns information about a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html), with a link to download the layer archive that's valid for 10 minutes.
 */
public suspend inline fun LambdaClient.getLayerVersion(crossinline block: GetLayerVersionRequest.Builder.() -> Unit): GetLayerVersionResponse = getLayerVersion(GetLayerVersionRequest.Builder().apply(block).build())

/**
 * Returns information about a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html), with a link to download the layer archive that's valid for 10 minutes.
 */
public suspend inline fun LambdaClient.getLayerVersionByArn(crossinline block: GetLayerVersionByArnRequest.Builder.() -> Unit): GetLayerVersionByArnResponse = getLayerVersionByArn(GetLayerVersionByArnRequest.Builder().apply(block).build())

/**
 * Returns the permission policy for a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). For more information, see AddLayerVersionPermission.
 */
public suspend inline fun LambdaClient.getLayerVersionPolicy(crossinline block: GetLayerVersionPolicyRequest.Builder.() -> Unit): GetLayerVersionPolicyResponse = getLayerVersionPolicy(GetLayerVersionPolicyRequest.Builder().apply(block).build())

/**
 * Returns the [resource-based IAM policy](https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html) for a function, version, or alias.
 */
public suspend inline fun LambdaClient.getPolicy(crossinline block: GetPolicyRequest.Builder.() -> Unit): GetPolicyResponse = getPolicy(GetPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves the provisioned concurrency configuration for a function's alias or version.
 */
public suspend inline fun LambdaClient.getProvisionedConcurrencyConfig(crossinline block: GetProvisionedConcurrencyConfigRequest.Builder.() -> Unit): GetProvisionedConcurrencyConfigResponse = getProvisionedConcurrencyConfig(GetProvisionedConcurrencyConfigRequest.Builder().apply(block).build())

/**
 * Invokes a Lambda function. You can invoke a function synchronously (and wait for the response), or asynchronously. To invoke a function asynchronously, set `InvocationType` to `Event`.
 *
 * For [synchronous invocation](https://docs.aws.amazon.com/lambda/latest/dg/invocation-sync.html), details about the function response, including errors, are included in the response body and headers. For either invocation type, you can find more information in the [execution log](https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html) and [trace](https://docs.aws.amazon.com/lambda/latest/dg/lambda-x-ray.html).
 *
 * When an error occurs, your function may be invoked multiple times. Retry behavior varies by error type, client, event source, and invocation type. For example, if you invoke a function asynchronously and it returns an error, Lambda executes the function up to two more times. For more information, see [Retry Behavior](https://docs.aws.amazon.com/lambda/latest/dg/retries-on-errors.html).
 *
 * For [asynchronous invocation](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html), Lambda adds events to a queue before sending them to your function. If your function does not have enough capacity to keep up with the queue, events may be lost. Occasionally, your function may receive the same event multiple times, even if no error occurs. To retain events that were not processed, configure your function with a [dead-letter queue](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq).
 *
 * The status code in the API response doesn't reflect function errors. Error codes are reserved for errors that prevent your function from executing, such as permissions errors, [limit errors](https://docs.aws.amazon.com/lambda/latest/dg/limits.html), or issues with your function's code and configuration. For example, Lambda returns `TooManyRequestsException` if executing the function would cause you to exceed a concurrency limit at either the account level (`ConcurrentInvocationLimitExceeded`) or function level (`ReservedFunctionConcurrentInvocationLimitExceeded`).
 *
 * For functions with a long timeout, your client might be disconnected during synchronous invocation while it waits for a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long connections with timeout or keep-alive settings.
 *
 * This operation requires permission for the [lambda:InvokeFunction](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslambda.html) action.
 */
public suspend inline fun LambdaClient.invoke(crossinline block: InvokeRequest.Builder.() -> Unit): InvokeResponse = invoke(InvokeRequest.Builder().apply(block).build())

/**
 * For asynchronous function invocation, use Invoke.
 *
 * Invokes a function asynchronously.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun LambdaClient.invokeAsync(crossinline block: InvokeAsyncRequest.Builder.() -> Unit): InvokeAsyncResponse = invokeAsync(InvokeAsyncRequest.Builder().apply(block).build())

/**
 * Returns a list of [aliases](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html) for a Lambda function.
 */
public suspend inline fun LambdaClient.listAliases(crossinline block: ListAliasesRequest.Builder.() -> Unit): ListAliasesResponse = listAliases(ListAliasesRequest.Builder().apply(block).build())

/**
 * Returns a list of [code signing configurations](https://docs.aws.amazon.com/lambda/latest/dg/configuring-codesigning.html). A request returns up to 10,000 configurations per call. You can use the `MaxItems` parameter to return fewer configurations per call.
 */
public suspend inline fun LambdaClient.listCodeSigningConfigs(crossinline block: ListCodeSigningConfigsRequest.Builder.() -> Unit): ListCodeSigningConfigsResponse = listCodeSigningConfigs(ListCodeSigningConfigsRequest.Builder().apply(block).build())

/**
 * Lists event source mappings. Specify an `EventSourceArn` to only show event source mappings for a single event source.
 */
public suspend inline fun LambdaClient.listEventSourceMappings(crossinline block: ListEventSourceMappingsRequest.Builder.() -> Unit): ListEventSourceMappingsResponse = listEventSourceMappings(ListEventSourceMappingsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of configurations for asynchronous invocation for a function.
 *
 * To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
 */
public suspend inline fun LambdaClient.listFunctionEventInvokeConfigs(crossinline block: ListFunctionEventInvokeConfigsRequest.Builder.() -> Unit): ListFunctionEventInvokeConfigsResponse = listFunctionEventInvokeConfigs(ListFunctionEventInvokeConfigsRequest.Builder().apply(block).build())

/**
 * Returns a list of Lambda function URLs for the specified function.
 */
public suspend inline fun LambdaClient.listFunctionUrlConfigs(crossinline block: ListFunctionUrlConfigsRequest.Builder.() -> Unit): ListFunctionUrlConfigsResponse = listFunctionUrlConfigs(ListFunctionUrlConfigsRequest.Builder().apply(block).build())

/**
 * Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50 functions per call.
 *
 * Set `FunctionVersion` to `ALL` to include all published versions of each function in addition to the unpublished version.
 *
 * The `ListFunctions` action returns a subset of the FunctionConfiguration fields. To get the additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason, LastUpdateStatusReasonCode) for a function or version, use GetFunction.
 */
public suspend inline fun LambdaClient.listFunctions(crossinline block: ListFunctionsRequest.Builder.() -> Unit): ListFunctionsResponse = listFunctions(ListFunctionsRequest.Builder().apply(block).build())

/**
 * List the functions that use the specified code signing configuration. You can use this method prior to deleting a code signing configuration, to verify that no functions are using it.
 */
public suspend inline fun LambdaClient.listFunctionsByCodeSigningConfig(crossinline block: ListFunctionsByCodeSigningConfigRequest.Builder.() -> Unit): ListFunctionsByCodeSigningConfigResponse = listFunctionsByCodeSigningConfig(ListFunctionsByCodeSigningConfigRequest.Builder().apply(block).build())

/**
 * Lists the versions of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). Versions that have been deleted aren't listed. Specify a [runtime identifier](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) to list only versions that indicate that they're compatible with that runtime. Specify a compatible architecture to include only layer versions that are compatible with that architecture.
 */
public suspend inline fun LambdaClient.listLayerVersions(crossinline block: ListLayerVersionsRequest.Builder.() -> Unit): ListLayerVersionsResponse = listLayerVersions(ListLayerVersionsRequest.Builder().apply(block).build())

/**
 * Lists [Lambda layers](https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html) and shows information about the latest version of each. Specify a [runtime identifier](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) to list only layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only layers that are compatible with that [instruction set architecture](https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html).
 */
public suspend inline fun LambdaClient.listLayers(crossinline block: ListLayersRequest.Builder.() -> Unit): ListLayersResponse = listLayers(ListLayersRequest.Builder().apply(block).build())

/**
 * Retrieves a list of provisioned concurrency configurations for a function.
 */
public suspend inline fun LambdaClient.listProvisionedConcurrencyConfigs(crossinline block: ListProvisionedConcurrencyConfigsRequest.Builder.() -> Unit): ListProvisionedConcurrencyConfigsResponse = listProvisionedConcurrencyConfigs(ListProvisionedConcurrencyConfigsRequest.Builder().apply(block).build())

/**
 * Returns a function's [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html). You can also view tags with GetFunction.
 */
public suspend inline fun LambdaClient.listTags(crossinline block: ListTagsRequest.Builder.() -> Unit): ListTagsResponse = listTags(ListTagsRequest.Builder().apply(block).build())

/**
 * Returns a list of [versions](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html), with the version-specific configuration of each. Lambda returns up to 50 versions per call.
 */
public suspend inline fun LambdaClient.listVersionsByFunction(crossinline block: ListVersionsByFunctionRequest.Builder.() -> Unit): ListVersionsByFunctionResponse = listVersionsByFunction(ListVersionsByFunctionRequest.Builder().apply(block).build())

/**
 * Creates an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html) from a ZIP archive. Each time you call `PublishLayerVersion` with the same layer name, a new version is created.
 *
 * Add layers to your function with CreateFunction or UpdateFunctionConfiguration.
 */
public suspend inline fun LambdaClient.publishLayerVersion(crossinline block: PublishLayerVersionRequest.Builder.() -> Unit): PublishLayerVersionResponse = publishLayerVersion(PublishLayerVersionRequest.Builder().apply(block).build())

/**
 * Creates a [version](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html) from the current code and configuration of a function. Use versions to create a snapshot of your function code and configuration that doesn't change.
 *
 * Lambda doesn't publish a version if the function's configuration and code haven't changed since the last version. Use UpdateFunctionCode or UpdateFunctionConfiguration to update the function before publishing a version.
 *
 * Clients can invoke versions directly or with an alias. To create an alias, use CreateAlias.
 */
public suspend inline fun LambdaClient.publishVersion(crossinline block: PublishVersionRequest.Builder.() -> Unit): PublishVersionResponse = publishVersion(PublishVersionRequest.Builder().apply(block).build())

/**
 * Update the code signing configuration for the function. Changes to the code signing configuration take effect the next time a user tries to deploy a code package to the function.
 */
public suspend inline fun LambdaClient.putFunctionCodeSigningConfig(crossinline block: PutFunctionCodeSigningConfigRequest.Builder.() -> Unit): PutFunctionCodeSigningConfigResponse = putFunctionCodeSigningConfig(PutFunctionCodeSigningConfigRequest.Builder().apply(block).build())

/**
 * Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency level.
 *
 * Concurrency settings apply to the function as a whole, including all published versions and the unpublished version. Reserving concurrency both ensures that your function has capacity to process the specified number of events simultaneously, and prevents it from scaling beyond that level. Use GetFunction to see the current setting for a function.
 *
 * Use GetAccountSettings to see your Regional concurrency limit. You can reserve concurrency for as many functions as you like, as long as you leave at least 100 simultaneous executions unreserved for functions that aren't configured with a per-function limit. For more information, see [Managing Concurrency](https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
 */
public suspend inline fun LambdaClient.putFunctionConcurrency(crossinline block: PutFunctionConcurrencyRequest.Builder.() -> Unit): PutFunctionConcurrencyResponse = putFunctionConcurrency(PutFunctionConcurrencyRequest.Builder().apply(block).build())

/**
 * Configures options for [asynchronous invocation](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html) on a function, version, or alias. If a configuration already exists for a function, version, or alias, this operation overwrites it. If you exclude any settings, they are removed. To set one option without affecting existing settings for other options, use UpdateFunctionEventInvokeConfig.
 *
 * By default, Lambda retries an asynchronous invocation twice if the function returns an error. It retains events in a queue for up to six hours. When an event fails all processing attempts or stays in the asynchronous invocation queue for too long, Lambda discards it. To retain discarded events, configure a dead-letter queue with UpdateFunctionConfiguration.
 *
 * To send an invocation record to a queue, topic, function, or event bus, specify a [destination](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations). You can configure separate destinations for successful invocations (on-success) and events that fail all processing attempts (on-failure). You can configure destinations in addition to or instead of a dead-letter queue.
 */
public suspend inline fun LambdaClient.putFunctionEventInvokeConfig(crossinline block: PutFunctionEventInvokeConfigRequest.Builder.() -> Unit): PutFunctionEventInvokeConfigResponse = putFunctionEventInvokeConfig(PutFunctionEventInvokeConfigRequest.Builder().apply(block).build())

/**
 * Adds a provisioned concurrency configuration to a function's alias or version.
 */
public suspend inline fun LambdaClient.putProvisionedConcurrencyConfig(crossinline block: PutProvisionedConcurrencyConfigRequest.Builder.() -> Unit): PutProvisionedConcurrencyConfigResponse = putProvisionedConcurrencyConfig(PutProvisionedConcurrencyConfigRequest.Builder().apply(block).build())

/**
 * Removes a statement from the permissions policy for a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). For more information, see AddLayerVersionPermission.
 */
public suspend inline fun LambdaClient.removeLayerVersionPermission(crossinline block: RemoveLayerVersionPermissionRequest.Builder.() -> Unit): RemoveLayerVersionPermissionResponse = removeLayerVersionPermission(RemoveLayerVersionPermissionRequest.Builder().apply(block).build())

/**
 * Revokes function-use permission from an Amazon Web Services service or another account. You can get the ID of the statement from the output of GetPolicy.
 */
public suspend inline fun LambdaClient.removePermission(crossinline block: RemovePermissionRequest.Builder.() -> Unit): RemovePermissionResponse = removePermission(RemovePermissionRequest.Builder().apply(block).build())

/**
 * Adds [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) to a function.
 */
public suspend inline fun LambdaClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) from a function.
 */
public suspend inline fun LambdaClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the configuration of a Lambda function [alias](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
 */
public suspend inline fun LambdaClient.updateAlias(crossinline block: UpdateAliasRequest.Builder.() -> Unit): UpdateAliasResponse = updateAlias(UpdateAliasRequest.Builder().apply(block).build())

/**
 * Update the code signing configuration. Changes to the code signing configuration take effect the next time a user tries to deploy a code package to the function.
 */
public suspend inline fun LambdaClient.updateCodeSigningConfig(crossinline block: UpdateCodeSigningConfigRequest.Builder.() -> Unit): UpdateCodeSigningConfigResponse = updateCodeSigningConfig(UpdateCodeSigningConfigRequest.Builder().apply(block).build())

/**
 * Updates an event source mapping. You can change the function that Lambda invokes, or pause invocation and resume later from the same location.
 *
 * For details about how to configure different event sources, see the following topics.
 * + [ Amazon DynamoDB Streams](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping)
 * + [ Amazon Kinesis](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping)
 * + [ Amazon SQS](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource)
 * + [ Amazon MQ and RabbitMQ](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping)
 * + [ Amazon MSK](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html)
 * + [ Apache Kafka](https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html)
 *
 * The following error handling options are only available for stream sources (DynamoDB and Kinesis):
 * + `BisectBatchOnFunctionError` - If the function returns an error, split the batch in two and retry.
 * + `DestinationConfig` - Send discarded records to an Amazon SQS queue or Amazon SNS topic.
 * + `MaximumRecordAgeInSeconds` - Discard records older than the specified age. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires
 * + `MaximumRetryAttempts` - Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
 * + `ParallelizationFactor` - Process multiple batches from each shard concurrently.
 *
 * For information about which configuration parameters apply to each event source, see the following topics.
 * + [ Amazon DynamoDB Streams](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params)
 * + [ Amazon Kinesis](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params)
 * + [ Amazon SQS](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params)
 * + [ Amazon MQ and RabbitMQ](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params)
 * + [ Amazon MSK](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms)
 * + [ Apache Kafka](https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms)
 */
public suspend inline fun LambdaClient.updateEventSourceMapping(crossinline block: UpdateEventSourceMappingRequest.Builder.() -> Unit): UpdateEventSourceMappingResponse = updateEventSourceMapping(UpdateEventSourceMappingRequest.Builder().apply(block).build())

/**
 * Updates a Lambda function's code. If code signing is enabled for the function, the code package must be signed by a trusted publisher. For more information, see [Configuring code signing](https://docs.aws.amazon.com/lambda/latest/dg/configuration-trustedcode.html).
 *
 * If the function's package type is `Image`, you must specify the code package in `ImageUri` as the URI of a [container image](https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html) in the Amazon ECR registry.
 *
 * If the function's package type is `Zip`, you must specify the deployment package as a [.zip file archive](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip). Enter the Amazon S3 bucket and key of the code .zip file location. You can also provide the function code inline using the `ZipFile` field.
 *
 * The code in the deployment package must be compatible with the target instruction set architecture of the function (`x86-64` or `arm64`).
 *
 * The function's code is locked when you publish a version. You can't modify the code of a published version, only the unpublished version.
 *
 * For a function defined as a container image, Lambda resolves the image tag to an image digest. In Amazon ECR, if you update the image tag to a new image, Lambda does not automatically update the function.
 */
public suspend inline fun LambdaClient.updateFunctionCode(crossinline block: UpdateFunctionCodeRequest.Builder.() -> Unit): UpdateFunctionCodeResponse = updateFunctionCode(UpdateFunctionCodeRequest.Builder().apply(block).build())

/**
 * Modify the version-specific settings of a Lambda function.
 *
 * When you update a function, Lambda provisions an instance of the function and its supporting resources. If your function connects to a VPC, this process can take a minute. During this time, you can't modify the function, but you can still invoke it. The `LastUpdateStatus`, `LastUpdateStatusReason`, and `LastUpdateStatusReasonCode` fields in the response from GetFunctionConfiguration indicate when the update is complete and the function is processing events with the new configuration. For more information, see [Function States](https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html).
 *
 * These settings can vary between versions of a function and are locked when you publish a version. You can't modify the configuration of a published version, only the unpublished version.
 *
 * To configure function concurrency, use PutFunctionConcurrency. To grant invoke permissions to an account or Amazon Web Services service, use AddPermission.
 */
public suspend inline fun LambdaClient.updateFunctionConfiguration(crossinline block: UpdateFunctionConfigurationRequest.Builder.() -> Unit): UpdateFunctionConfigurationResponse = updateFunctionConfiguration(UpdateFunctionConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the configuration for asynchronous invocation for a function, version, or alias.
 *
 * To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
 */
public suspend inline fun LambdaClient.updateFunctionEventInvokeConfig(crossinline block: UpdateFunctionEventInvokeConfigRequest.Builder.() -> Unit): UpdateFunctionEventInvokeConfigResponse = updateFunctionEventInvokeConfig(UpdateFunctionEventInvokeConfigRequest.Builder().apply(block).build())

/**
 * Updates the configuration for a Lambda function URL.
 */
public suspend inline fun LambdaClient.updateFunctionUrlConfig(crossinline block: UpdateFunctionUrlConfigRequest.Builder.() -> Unit): UpdateFunctionUrlConfigResponse = updateFunctionUrlConfig(UpdateFunctionUrlConfigRequest.Builder().apply(block).build())
