// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



/**
 * Details about a [Code signing configuration](https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html).
 */
public class CodeSigningConfig private constructor(builder: Builder) {
    /**
     * List of allowed publishers.
     */
    public val allowedPublishers: aws.sdk.kotlin.services.lambda.model.AllowedPublishers? = builder.allowedPublishers
    /**
     * The Amazon Resource Name (ARN) of the Code signing configuration.
     */
    public val codeSigningConfigArn: kotlin.String? = builder.codeSigningConfigArn
    /**
     * Unique identifer for the Code signing configuration.
     */
    public val codeSigningConfigId: kotlin.String? = builder.codeSigningConfigId
    /**
     * The code signing policy controls the validation failure action for signature mismatch or expiry.
     */
    public val codeSigningPolicies: aws.sdk.kotlin.services.lambda.model.CodeSigningPolicies? = builder.codeSigningPolicies
    /**
     * Code signing configuration description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The date and time that the Code signing configuration was last modified, in ISO-8601 format (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public val lastModified: kotlin.String? = builder.lastModified

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.CodeSigningConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CodeSigningConfig(")
        append("allowedPublishers=$allowedPublishers,")
        append("codeSigningConfigArn=$codeSigningConfigArn,")
        append("codeSigningConfigId=$codeSigningConfigId,")
        append("codeSigningPolicies=$codeSigningPolicies,")
        append("description=$description,")
        append("lastModified=$lastModified)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedPublishers?.hashCode() ?: 0
        result = 31 * result + (codeSigningConfigArn?.hashCode() ?: 0)
        result = 31 * result + (codeSigningConfigId?.hashCode() ?: 0)
        result = 31 * result + (codeSigningPolicies?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CodeSigningConfig

        if (allowedPublishers != other.allowedPublishers) return false
        if (codeSigningConfigArn != other.codeSigningConfigArn) return false
        if (codeSigningConfigId != other.codeSigningConfigId) return false
        if (codeSigningPolicies != other.codeSigningPolicies) return false
        if (description != other.description) return false
        if (lastModified != other.lastModified) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.CodeSigningConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * List of allowed publishers.
         */
        public var allowedPublishers: aws.sdk.kotlin.services.lambda.model.AllowedPublishers? = null
        /**
         * The Amazon Resource Name (ARN) of the Code signing configuration.
         */
        public var codeSigningConfigArn: kotlin.String? = null
        /**
         * Unique identifer for the Code signing configuration.
         */
        public var codeSigningConfigId: kotlin.String? = null
        /**
         * The code signing policy controls the validation failure action for signature mismatch or expiry.
         */
        public var codeSigningPolicies: aws.sdk.kotlin.services.lambda.model.CodeSigningPolicies? = null
        /**
         * Code signing configuration description.
         */
        public var description: kotlin.String? = null
        /**
         * The date and time that the Code signing configuration was last modified, in ISO-8601 format (YYYY-MM-DDThh:mm:ss.sTZD).
         */
        public var lastModified: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.CodeSigningConfig) : this() {
            this.allowedPublishers = x.allowedPublishers
            this.codeSigningConfigArn = x.codeSigningConfigArn
            this.codeSigningConfigId = x.codeSigningConfigId
            this.codeSigningPolicies = x.codeSigningPolicies
            this.description = x.description
            this.lastModified = x.lastModified
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.CodeSigningConfig = CodeSigningConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.AllowedPublishers] inside the given [block]
         */
        public fun allowedPublishers(block: aws.sdk.kotlin.services.lambda.model.AllowedPublishers.Builder.() -> kotlin.Unit) {
            this.allowedPublishers = aws.sdk.kotlin.services.lambda.model.AllowedPublishers.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.CodeSigningPolicies] inside the given [block]
         */
        public fun codeSigningPolicies(block: aws.sdk.kotlin.services.lambda.model.CodeSigningPolicies.Builder.() -> kotlin.Unit) {
            this.codeSigningPolicies = aws.sdk.kotlin.services.lambda.model.CodeSigningPolicies.invoke(block)
        }
    }
}
