// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



public class CreateFunctionRequest private constructor(builder: Builder) {
    /**
     * The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is `x86_64`.
     */
    public val architectures: List<Architecture>? = builder.architectures
    /**
     * The code for the function.
     */
    public val code: aws.sdk.kotlin.services.lambda.model.FunctionCode? = builder.code
    /**
     * To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
     */
    public val codeSigningConfigArn: kotlin.String? = builder.codeSigningConfigArn
    /**
     * A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see [Dead Letter Queues](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq).
     */
    public val deadLetterConfig: aws.sdk.kotlin.services.lambda.model.DeadLetterConfig? = builder.deadLetterConfig
    /**
     * A description of the function.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Environment variables that are accessible from function code during execution.
     */
    public val environment: aws.sdk.kotlin.services.lambda.model.Environment? = builder.environment
    /**
     * The size of the function’s /tmp directory in MB. The default value is 512, but can be any whole number between 512 and 10240 MB.
     */
    public val ephemeralStorage: aws.sdk.kotlin.services.lambda.model.EphemeralStorage? = builder.ephemeralStorage
    /**
     * Connection settings for an Amazon EFS file system.
     */
    public val fileSystemConfigs: List<FileSystemConfig>? = builder.fileSystemConfigs
    /**
     * The name of the Lambda function.
     *
     * **Name formats**
     * + **Function name** - `my-function`.
     * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
     * + **Partial ARN** - `123456789012:function:my-function`.
     *
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    public val functionName: kotlin.String? = builder.functionName
    /**
     * The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see [Programming Model](https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html).
     */
    public val handler: kotlin.String? = builder.handler
    /**
     * Container image [configuration values](https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings) that override the values in the container image Dockerfile.
     */
    public val imageConfig: aws.sdk.kotlin.services.lambda.model.ImageConfig? = builder.imageConfig
    /**
     * The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * A list of [function layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html) to add to the function's execution environment. Specify each layer by its ARN, including the version.
     */
    public val layers: List<String>? = builder.layers
    /**
     * The amount of [memory available to the function](https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html) at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.
     */
    public val memorySize: kotlin.Int? = builder.memorySize
    /**
     * The type of deployment package. Set to `Image` for container image and set `Zip` for ZIP archive.
     */
    public val packageType: aws.sdk.kotlin.services.lambda.model.PackageType? = builder.packageType
    /**
     * Set to true to publish the first version of the function during creation.
     */
    public val publish: kotlin.Boolean = builder.publish
    /**
     * The Amazon Resource Name (ARN) of the function's execution role.
     */
    public val role: kotlin.String? = builder.role
    /**
     * The identifier of the function's [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html). Runtime is required if the deployment package is a .zip file archive.
     */
    public val runtime: aws.sdk.kotlin.services.lambda.model.Runtime? = builder.runtime
    /**
     * A list of [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) to apply to the function.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see [Lambda execution environment](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html).
     */
    public val timeout: kotlin.Int? = builder.timeout
    /**
     * Set `Mode` to `Active` to sample and trace a subset of incoming requests with [X-Ray](https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html).
     */
    public val tracingConfig: aws.sdk.kotlin.services.lambda.model.TracingConfig? = builder.tracingConfig
    /**
     * For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see [VPC Settings](https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.lambda.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.CreateFunctionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFunctionRequest(")
        append("architectures=$architectures,")
        append("code=$code,")
        append("codeSigningConfigArn=$codeSigningConfigArn,")
        append("deadLetterConfig=$deadLetterConfig,")
        append("description=$description,")
        append("environment=$environment,")
        append("ephemeralStorage=$ephemeralStorage,")
        append("fileSystemConfigs=$fileSystemConfigs,")
        append("functionName=$functionName,")
        append("handler=$handler,")
        append("imageConfig=$imageConfig,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("layers=$layers,")
        append("memorySize=$memorySize,")
        append("packageType=$packageType,")
        append("publish=$publish,")
        append("role=$role,")
        append("runtime=$runtime,")
        append("tags=$tags,")
        append("timeout=$timeout,")
        append("tracingConfig=$tracingConfig,")
        append("vpcConfig=$vpcConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = architectures?.hashCode() ?: 0
        result = 31 * result + (code?.hashCode() ?: 0)
        result = 31 * result + (codeSigningConfigArn?.hashCode() ?: 0)
        result = 31 * result + (deadLetterConfig?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (ephemeralStorage?.hashCode() ?: 0)
        result = 31 * result + (fileSystemConfigs?.hashCode() ?: 0)
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (handler?.hashCode() ?: 0)
        result = 31 * result + (imageConfig?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (layers?.hashCode() ?: 0)
        result = 31 * result + (memorySize ?: 0)
        result = 31 * result + (packageType?.hashCode() ?: 0)
        result = 31 * result + (publish.hashCode())
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (runtime?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeout ?: 0)
        result = 31 * result + (tracingConfig?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFunctionRequest

        if (architectures != other.architectures) return false
        if (code != other.code) return false
        if (codeSigningConfigArn != other.codeSigningConfigArn) return false
        if (deadLetterConfig != other.deadLetterConfig) return false
        if (description != other.description) return false
        if (environment != other.environment) return false
        if (ephemeralStorage != other.ephemeralStorage) return false
        if (fileSystemConfigs != other.fileSystemConfigs) return false
        if (functionName != other.functionName) return false
        if (handler != other.handler) return false
        if (imageConfig != other.imageConfig) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (layers != other.layers) return false
        if (memorySize != other.memorySize) return false
        if (packageType != other.packageType) return false
        if (publish != other.publish) return false
        if (role != other.role) return false
        if (runtime != other.runtime) return false
        if (tags != other.tags) return false
        if (timeout != other.timeout) return false
        if (tracingConfig != other.tracingConfig) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.CreateFunctionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is `x86_64`.
         */
        public var architectures: List<Architecture>? = null
        /**
         * The code for the function.
         */
        public var code: aws.sdk.kotlin.services.lambda.model.FunctionCode? = null
        /**
         * To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
         */
        public var codeSigningConfigArn: kotlin.String? = null
        /**
         * A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see [Dead Letter Queues](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq).
         */
        public var deadLetterConfig: aws.sdk.kotlin.services.lambda.model.DeadLetterConfig? = null
        /**
         * A description of the function.
         */
        public var description: kotlin.String? = null
        /**
         * Environment variables that are accessible from function code during execution.
         */
        public var environment: aws.sdk.kotlin.services.lambda.model.Environment? = null
        /**
         * The size of the function’s /tmp directory in MB. The default value is 512, but can be any whole number between 512 and 10240 MB.
         */
        public var ephemeralStorage: aws.sdk.kotlin.services.lambda.model.EphemeralStorage? = null
        /**
         * Connection settings for an Amazon EFS file system.
         */
        public var fileSystemConfigs: List<FileSystemConfig>? = null
        /**
         * The name of the Lambda function.
         *
         * **Name formats**
         * + **Function name** - `my-function`.
         * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
         * + **Partial ARN** - `123456789012:function:my-function`.
         *
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         */
        public var functionName: kotlin.String? = null
        /**
         * The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see [Programming Model](https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html).
         */
        public var handler: kotlin.String? = null
        /**
         * Container image [configuration values](https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings) that override the values in the container image Dockerfile.
         */
        public var imageConfig: aws.sdk.kotlin.services.lambda.model.ImageConfig? = null
        /**
         * The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * A list of [function layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html) to add to the function's execution environment. Specify each layer by its ARN, including the version.
         */
        public var layers: List<String>? = null
        /**
         * The amount of [memory available to the function](https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html) at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.
         */
        public var memorySize: kotlin.Int? = null
        /**
         * The type of deployment package. Set to `Image` for container image and set `Zip` for ZIP archive.
         */
        public var packageType: aws.sdk.kotlin.services.lambda.model.PackageType? = null
        /**
         * Set to true to publish the first version of the function during creation.
         */
        public var publish: kotlin.Boolean = false
        /**
         * The Amazon Resource Name (ARN) of the function's execution role.
         */
        public var role: kotlin.String? = null
        /**
         * The identifier of the function's [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html). Runtime is required if the deployment package is a .zip file archive.
         */
        public var runtime: aws.sdk.kotlin.services.lambda.model.Runtime? = null
        /**
         * A list of [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) to apply to the function.
         */
        public var tags: Map<String, String>? = null
        /**
         * The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see [Lambda execution environment](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html).
         */
        public var timeout: kotlin.Int? = null
        /**
         * Set `Mode` to `Active` to sample and trace a subset of incoming requests with [X-Ray](https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html).
         */
        public var tracingConfig: aws.sdk.kotlin.services.lambda.model.TracingConfig? = null
        /**
         * For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see [VPC Settings](https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.lambda.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.CreateFunctionRequest) : this() {
            this.architectures = x.architectures
            this.code = x.code
            this.codeSigningConfigArn = x.codeSigningConfigArn
            this.deadLetterConfig = x.deadLetterConfig
            this.description = x.description
            this.environment = x.environment
            this.ephemeralStorage = x.ephemeralStorage
            this.fileSystemConfigs = x.fileSystemConfigs
            this.functionName = x.functionName
            this.handler = x.handler
            this.imageConfig = x.imageConfig
            this.kmsKeyArn = x.kmsKeyArn
            this.layers = x.layers
            this.memorySize = x.memorySize
            this.packageType = x.packageType
            this.publish = x.publish
            this.role = x.role
            this.runtime = x.runtime
            this.tags = x.tags
            this.timeout = x.timeout
            this.tracingConfig = x.tracingConfig
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.CreateFunctionRequest = CreateFunctionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.FunctionCode] inside the given [block]
         */
        public fun code(block: aws.sdk.kotlin.services.lambda.model.FunctionCode.Builder.() -> kotlin.Unit) {
            this.code = aws.sdk.kotlin.services.lambda.model.FunctionCode.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.DeadLetterConfig] inside the given [block]
         */
        public fun deadLetterConfig(block: aws.sdk.kotlin.services.lambda.model.DeadLetterConfig.Builder.() -> kotlin.Unit) {
            this.deadLetterConfig = aws.sdk.kotlin.services.lambda.model.DeadLetterConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.Environment] inside the given [block]
         */
        public fun environment(block: aws.sdk.kotlin.services.lambda.model.Environment.Builder.() -> kotlin.Unit) {
            this.environment = aws.sdk.kotlin.services.lambda.model.Environment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.EphemeralStorage] inside the given [block]
         */
        public fun ephemeralStorage(block: aws.sdk.kotlin.services.lambda.model.EphemeralStorage.Builder.() -> kotlin.Unit) {
            this.ephemeralStorage = aws.sdk.kotlin.services.lambda.model.EphemeralStorage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.ImageConfig] inside the given [block]
         */
        public fun imageConfig(block: aws.sdk.kotlin.services.lambda.model.ImageConfig.Builder.() -> kotlin.Unit) {
            this.imageConfig = aws.sdk.kotlin.services.lambda.model.ImageConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.TracingConfig] inside the given [block]
         */
        public fun tracingConfig(block: aws.sdk.kotlin.services.lambda.model.TracingConfig.Builder.() -> kotlin.Unit) {
            this.tracingConfig = aws.sdk.kotlin.services.lambda.model.TracingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.lambda.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.lambda.model.VpcConfig.invoke(block)
        }
    }
}
