// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



public class ListEventSourceMappingsRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the event source.
     * + **Amazon Kinesis** - The ARN of the data stream or a stream consumer.
     * + **Amazon DynamoDB Streams** - The ARN of the stream.
     * + **Amazon Simple Queue Service** - The ARN of the queue.
     * + **Amazon Managed Streaming for Apache Kafka** - The ARN of the cluster.
     */
    public val eventSourceArn: kotlin.String? = builder.eventSourceArn
    /**
     * The name of the Lambda function.
     *
     * **Name formats**
     * + **Function name** - `MyFunction`.
     * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
     * + **Version or Alias ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD`.
     * + **Partial ARN** - `123456789012:function:MyFunction`.
     *
     * The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.
     */
    public val functionName: kotlin.String? = builder.functionName
    /**
     * A pagination token returned by a previous call.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of event source mappings to return. Note that ListEventSourceMappings returns a maximum of 100 items in each response, even if you set the number higher.
     */
    public val maxItems: kotlin.Int? = builder.maxItems

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.ListEventSourceMappingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListEventSourceMappingsRequest(")
        append("eventSourceArn=$eventSourceArn,")
        append("functionName=$functionName,")
        append("marker=$marker,")
        append("maxItems=$maxItems)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventSourceArn?.hashCode() ?: 0
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListEventSourceMappingsRequest

        if (eventSourceArn != other.eventSourceArn) return false
        if (functionName != other.functionName) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.ListEventSourceMappingsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the event source.
         * + **Amazon Kinesis** - The ARN of the data stream or a stream consumer.
         * + **Amazon DynamoDB Streams** - The ARN of the stream.
         * + **Amazon Simple Queue Service** - The ARN of the queue.
         * + **Amazon Managed Streaming for Apache Kafka** - The ARN of the cluster.
         */
        public var eventSourceArn: kotlin.String? = null
        /**
         * The name of the Lambda function.
         *
         * **Name formats**
         * + **Function name** - `MyFunction`.
         * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
         * + **Version or Alias ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD`.
         * + **Partial ARN** - `123456789012:function:MyFunction`.
         *
         * The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.
         */
        public var functionName: kotlin.String? = null
        /**
         * A pagination token returned by a previous call.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of event source mappings to return. Note that ListEventSourceMappings returns a maximum of 100 items in each response, even if you set the number higher.
         */
        public var maxItems: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.ListEventSourceMappingsRequest) : this() {
            this.eventSourceArn = x.eventSourceArn
            this.functionName = x.functionName
            this.marker = x.marker
            this.maxItems = x.maxItems
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.ListEventSourceMappingsRequest = ListEventSourceMappingsRequest(this)
    }
}
