// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lambda.model.CodeSigningConfig
import aws.sdk.kotlin.services.lambda.model.CreateCodeSigningConfigResponse
import aws.sdk.kotlin.services.lambda.model.LambdaException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCodeSigningConfigOperationDeserializer: HttpDeserialize<CreateCodeSigningConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateCodeSigningConfigResponse {
        if (!response.status.isSuccess()) {
            throwCreateCodeSigningConfigError(context, response)
        }
        val builder = CreateCodeSigningConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateCodeSigningConfigOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateCodeSigningConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LambdaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LambdaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateCodeSigningConfigOperationBody(builder: CreateCodeSigningConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CODESIGNINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CodeSigningConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CODESIGNINGCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CODESIGNINGCONFIG_DESCRIPTOR.index -> builder.codeSigningConfig = deserializeCodeSigningConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
