// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



/**
 * The code for the Lambda function. You can specify either an object in Amazon S3, upload a .zip file archive deployment package directly, or specify the URI of a container image.
 */
public class FunctionCode private constructor(builder: Builder) {
    /**
     * URI of a [container image](https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html) in the Amazon ECR registry.
     */
    public val imageUri: kotlin.String? = builder.imageUri
    /**
     * An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account.
     */
    public val s3Bucket: kotlin.String? = builder.s3Bucket
    /**
     * The Amazon S3 key of the deployment package.
     */
    public val s3Key: kotlin.String? = builder.s3Key
    /**
     * For versioned objects, the version of the deployment package object to use.
     */
    public val s3ObjectVersion: kotlin.String? = builder.s3ObjectVersion
    /**
     * The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for you.
     */
    public val zipFile: kotlin.ByteArray? = builder.zipFile

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.FunctionCode = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FunctionCode(")
        append("imageUri=$imageUri,")
        append("s3Bucket=$s3Bucket,")
        append("s3Key=$s3Key,")
        append("s3ObjectVersion=$s3ObjectVersion,")
        append("zipFile=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = imageUri?.hashCode() ?: 0
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        result = 31 * result + (s3Key?.hashCode() ?: 0)
        result = 31 * result + (s3ObjectVersion?.hashCode() ?: 0)
        result = 31 * result + (zipFile?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FunctionCode

        if (imageUri != other.imageUri) return false
        if (s3Bucket != other.s3Bucket) return false
        if (s3Key != other.s3Key) return false
        if (s3ObjectVersion != other.s3ObjectVersion) return false
        if (zipFile != null) {
            if (other.zipFile == null) return false
            if (!zipFile.contentEquals(other.zipFile)) return false
        } else if (other.zipFile != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.FunctionCode = Builder(this).apply(block).build()

    public class Builder {
        /**
         * URI of a [container image](https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html) in the Amazon ECR registry.
         */
        public var imageUri: kotlin.String? = null
        /**
         * An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * The Amazon S3 key of the deployment package.
         */
        public var s3Key: kotlin.String? = null
        /**
         * For versioned objects, the version of the deployment package object to use.
         */
        public var s3ObjectVersion: kotlin.String? = null
        /**
         * The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for you.
         */
        public var zipFile: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.FunctionCode) : this() {
            this.imageUri = x.imageUri
            this.s3Bucket = x.s3Bucket
            this.s3Key = x.s3Key
            this.s3ObjectVersion = x.s3ObjectVersion
            this.zipFile = x.zipFile
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.FunctionCode = FunctionCode(this)
    }
}
