// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



public class InvokeRequest private constructor(builder: Builder) {
    /**
     * Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the context object.
     */
    public val clientContext: kotlin.String? = builder.clientContext
    /**
     * The name of the Lambda function, version, or alias.
     *
     * **Name formats**
     * + **Function name** - `my-function` (name-only), `my-function:v1` (with alias).
     * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
     * + **Partial ARN** - `123456789012:function:my-function`.
     *
     * You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    public val functionName: kotlin.String? = requireNotNull(builder.functionName) { "A non-null value must be provided for functionName" }
    /**
     * Choose from the following options.
     * + `RequestResponse` (default) - Invoke the function synchronously. Keep the connection open until the function returns a response or times out. The API response includes the function response and additional data.
     * + `Event` - Invoke the function asynchronously. Send events that fail multiple times to the function's dead-letter queue (if it's configured). The API response only includes a status code.
     * + `DryRun` - Validate parameter values and verify that the user or role has permission to invoke the function.
     */
    public val invocationType: aws.sdk.kotlin.services.lambda.model.InvocationType? = builder.invocationType
    /**
     * Set to `Tail` to include the execution log in the response. Applies to synchronously invoked functions only.
     */
    public val logType: aws.sdk.kotlin.services.lambda.model.LogType? = builder.logType
    /**
     * The JSON that you want to provide to your Lambda function as input.
     *
     * You can enter the JSON directly. For example, `--payload '{ "key": "value" }'`. You can also specify a file path. For example, `--payload file://payload.json`.
     */
    public val payload: kotlin.ByteArray? = builder.payload
    /**
     * Specify a version or alias to invoke a published version of the function.
     */
    public val qualifier: kotlin.String? = builder.qualifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.InvokeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvokeRequest(")
        append("clientContext=$clientContext,")
        append("functionName=$functionName,")
        append("invocationType=$invocationType,")
        append("logType=$logType,")
        append("payload=*** Sensitive Data Redacted ***,")
        append("qualifier=$qualifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientContext?.hashCode() ?: 0
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (invocationType?.hashCode() ?: 0)
        result = 31 * result + (logType?.hashCode() ?: 0)
        result = 31 * result + (payload?.contentHashCode() ?: 0)
        result = 31 * result + (qualifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvokeRequest

        if (clientContext != other.clientContext) return false
        if (functionName != other.functionName) return false
        if (invocationType != other.invocationType) return false
        if (logType != other.logType) return false
        if (payload != null) {
            if (other.payload == null) return false
            if (!payload.contentEquals(other.payload)) return false
        } else if (other.payload != null) return false
        if (qualifier != other.qualifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.InvokeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the context object.
         */
        public var clientContext: kotlin.String? = null
        /**
         * The name of the Lambda function, version, or alias.
         *
         * **Name formats**
         * + **Function name** - `my-function` (name-only), `my-function:v1` (with alias).
         * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
         * + **Partial ARN** - `123456789012:function:my-function`.
         *
         * You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         */
        public var functionName: kotlin.String? = null
        /**
         * Choose from the following options.
         * + `RequestResponse` (default) - Invoke the function synchronously. Keep the connection open until the function returns a response or times out. The API response includes the function response and additional data.
         * + `Event` - Invoke the function asynchronously. Send events that fail multiple times to the function's dead-letter queue (if it's configured). The API response only includes a status code.
         * + `DryRun` - Validate parameter values and verify that the user or role has permission to invoke the function.
         */
        public var invocationType: aws.sdk.kotlin.services.lambda.model.InvocationType? = null
        /**
         * Set to `Tail` to include the execution log in the response. Applies to synchronously invoked functions only.
         */
        public var logType: aws.sdk.kotlin.services.lambda.model.LogType? = null
        /**
         * The JSON that you want to provide to your Lambda function as input.
         *
         * You can enter the JSON directly. For example, `--payload '{ "key": "value" }'`. You can also specify a file path. For example, `--payload file://payload.json`.
         */
        public var payload: kotlin.ByteArray? = null
        /**
         * Specify a version or alias to invoke a published version of the function.
         */
        public var qualifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.InvokeRequest) : this() {
            this.clientContext = x.clientContext
            this.functionName = x.functionName
            this.invocationType = x.invocationType
            this.logType = x.logType
            this.payload = x.payload
            this.qualifier = x.qualifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.InvokeRequest = InvokeRequest(this)
    }
}
