// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



public class UpdateEventSourceMappingRequest private constructor(builder: Builder) {
    /**
     * The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).
     * + **Amazon Kinesis** - Default 100. Max 10,000.
     * + **Amazon DynamoDB Streams** - Default 100. Max 10,000.
     * + **Amazon Simple Queue Service** - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.
     * + **Amazon Managed Streaming for Apache Kafka** - Default 100. Max 10,000.
     * + **Self-managed Apache Kafka** - Default 100. Max 10,000.
     * + **Amazon MQ (ActiveMQ and RabbitMQ)** - Default 100. Max 10,000.
     */
    public val batchSize: kotlin.Int? = builder.batchSize
    /**
     * (Streams only) If the function returns an error, split the batch in two and retry.
     */
    public val bisectBatchOnFunctionError: kotlin.Boolean? = builder.bisectBatchOnFunctionError
    /**
     * (Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
     */
    public val destinationConfig: aws.sdk.kotlin.services.lambda.model.DestinationConfig? = builder.destinationConfig
    /**
     * When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
     *
     * Default: True
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * (Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see [Lambda event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html).
     */
    public val filterCriteria: aws.sdk.kotlin.services.lambda.model.FilterCriteria? = builder.filterCriteria
    /**
     * The name of the Lambda function.
     *
     * **Name formats**
     * + **Function name** - `MyFunction`.
     * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
     * + **Version or Alias ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD`.
     * + **Partial ARN** - `123456789012:function:MyFunction`.
     *
     * The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.
     */
    public val functionName: kotlin.String? = builder.functionName
    /**
     * (Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.
     */
    public val functionResponseTypes: List<FunctionResponseType>? = builder.functionResponseTypes
    /**
     * (Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.
     *
     * Default: 0
     *
     * Related setting: When you set `BatchSize` to a value greater than 10, you must set `MaximumBatchingWindowInSeconds` to at least 1.
     */
    public val maximumBatchingWindowInSeconds: kotlin.Int? = builder.maximumBatchingWindowInSeconds
    /**
     * (Streams only) Discard records older than the specified age. The default value is infinite (-1).
     */
    public val maximumRecordAgeInSeconds: kotlin.Int? = builder.maximumRecordAgeInSeconds
    /**
     * (Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     */
    public val maximumRetryAttempts: kotlin.Int? = builder.maximumRetryAttempts
    /**
     * (Streams only) The number of batches to process from each shard concurrently.
     */
    public val parallelizationFactor: kotlin.Int? = builder.parallelizationFactor
    /**
     * An array of authentication protocols or VPC components required to secure your event source.
     */
    public val sourceAccessConfigurations: List<SourceAccessConfiguration>? = builder.sourceAccessConfigurations
    /**
     * (Streams only) The duration in seconds of a processing window. The range is between 1 second and 900 seconds.
     */
    public val tumblingWindowInSeconds: kotlin.Int? = builder.tumblingWindowInSeconds
    /**
     * The identifier of the event source mapping.
     */
    public val uuid: kotlin.String? = requireNotNull(builder.uuid) { "A non-null value must be provided for uuid" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.UpdateEventSourceMappingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateEventSourceMappingRequest(")
        append("batchSize=$batchSize,")
        append("bisectBatchOnFunctionError=$bisectBatchOnFunctionError,")
        append("destinationConfig=$destinationConfig,")
        append("enabled=$enabled,")
        append("filterCriteria=$filterCriteria,")
        append("functionName=$functionName,")
        append("functionResponseTypes=$functionResponseTypes,")
        append("maximumBatchingWindowInSeconds=$maximumBatchingWindowInSeconds,")
        append("maximumRecordAgeInSeconds=$maximumRecordAgeInSeconds,")
        append("maximumRetryAttempts=$maximumRetryAttempts,")
        append("parallelizationFactor=$parallelizationFactor,")
        append("sourceAccessConfigurations=$sourceAccessConfigurations,")
        append("tumblingWindowInSeconds=$tumblingWindowInSeconds,")
        append("uuid=$uuid)")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchSize ?: 0
        result = 31 * result + (bisectBatchOnFunctionError?.hashCode() ?: 0)
        result = 31 * result + (destinationConfig?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (filterCriteria?.hashCode() ?: 0)
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (functionResponseTypes?.hashCode() ?: 0)
        result = 31 * result + (maximumBatchingWindowInSeconds ?: 0)
        result = 31 * result + (maximumRecordAgeInSeconds ?: 0)
        result = 31 * result + (maximumRetryAttempts ?: 0)
        result = 31 * result + (parallelizationFactor ?: 0)
        result = 31 * result + (sourceAccessConfigurations?.hashCode() ?: 0)
        result = 31 * result + (tumblingWindowInSeconds ?: 0)
        result = 31 * result + (uuid?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateEventSourceMappingRequest

        if (batchSize != other.batchSize) return false
        if (bisectBatchOnFunctionError != other.bisectBatchOnFunctionError) return false
        if (destinationConfig != other.destinationConfig) return false
        if (enabled != other.enabled) return false
        if (filterCriteria != other.filterCriteria) return false
        if (functionName != other.functionName) return false
        if (functionResponseTypes != other.functionResponseTypes) return false
        if (maximumBatchingWindowInSeconds != other.maximumBatchingWindowInSeconds) return false
        if (maximumRecordAgeInSeconds != other.maximumRecordAgeInSeconds) return false
        if (maximumRetryAttempts != other.maximumRetryAttempts) return false
        if (parallelizationFactor != other.parallelizationFactor) return false
        if (sourceAccessConfigurations != other.sourceAccessConfigurations) return false
        if (tumblingWindowInSeconds != other.tumblingWindowInSeconds) return false
        if (uuid != other.uuid) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.UpdateEventSourceMappingRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).
         * + **Amazon Kinesis** - Default 100. Max 10,000.
         * + **Amazon DynamoDB Streams** - Default 100. Max 10,000.
         * + **Amazon Simple Queue Service** - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.
         * + **Amazon Managed Streaming for Apache Kafka** - Default 100. Max 10,000.
         * + **Self-managed Apache Kafka** - Default 100. Max 10,000.
         * + **Amazon MQ (ActiveMQ and RabbitMQ)** - Default 100. Max 10,000.
         */
        public var batchSize: kotlin.Int? = null
        /**
         * (Streams only) If the function returns an error, split the batch in two and retry.
         */
        public var bisectBatchOnFunctionError: kotlin.Boolean? = null
        /**
         * (Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         */
        public var destinationConfig: aws.sdk.kotlin.services.lambda.model.DestinationConfig? = null
        /**
         * When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
         *
         * Default: True
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * (Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see [Lambda event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html).
         */
        public var filterCriteria: aws.sdk.kotlin.services.lambda.model.FilterCriteria? = null
        /**
         * The name of the Lambda function.
         *
         * **Name formats**
         * + **Function name** - `MyFunction`.
         * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
         * + **Version or Alias ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD`.
         * + **Partial ARN** - `123456789012:function:MyFunction`.
         *
         * The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.
         */
        public var functionName: kotlin.String? = null
        /**
         * (Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.
         */
        public var functionResponseTypes: List<FunctionResponseType>? = null
        /**
         * (Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.
         *
         * Default: 0
         *
         * Related setting: When you set `BatchSize` to a value greater than 10, you must set `MaximumBatchingWindowInSeconds` to at least 1.
         */
        public var maximumBatchingWindowInSeconds: kotlin.Int? = null
        /**
         * (Streams only) Discard records older than the specified age. The default value is infinite (-1).
         */
        public var maximumRecordAgeInSeconds: kotlin.Int? = null
        /**
         * (Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
         */
        public var maximumRetryAttempts: kotlin.Int? = null
        /**
         * (Streams only) The number of batches to process from each shard concurrently.
         */
        public var parallelizationFactor: kotlin.Int? = null
        /**
         * An array of authentication protocols or VPC components required to secure your event source.
         */
        public var sourceAccessConfigurations: List<SourceAccessConfiguration>? = null
        /**
         * (Streams only) The duration in seconds of a processing window. The range is between 1 second and 900 seconds.
         */
        public var tumblingWindowInSeconds: kotlin.Int? = null
        /**
         * The identifier of the event source mapping.
         */
        public var uuid: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.UpdateEventSourceMappingRequest) : this() {
            this.batchSize = x.batchSize
            this.bisectBatchOnFunctionError = x.bisectBatchOnFunctionError
            this.destinationConfig = x.destinationConfig
            this.enabled = x.enabled
            this.filterCriteria = x.filterCriteria
            this.functionName = x.functionName
            this.functionResponseTypes = x.functionResponseTypes
            this.maximumBatchingWindowInSeconds = x.maximumBatchingWindowInSeconds
            this.maximumRecordAgeInSeconds = x.maximumRecordAgeInSeconds
            this.maximumRetryAttempts = x.maximumRetryAttempts
            this.parallelizationFactor = x.parallelizationFactor
            this.sourceAccessConfigurations = x.sourceAccessConfigurations
            this.tumblingWindowInSeconds = x.tumblingWindowInSeconds
            this.uuid = x.uuid
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.UpdateEventSourceMappingRequest = UpdateEventSourceMappingRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.DestinationConfig] inside the given [block]
         */
        public fun destinationConfig(block: aws.sdk.kotlin.services.lambda.model.DestinationConfig.Builder.() -> kotlin.Unit) {
            this.destinationConfig = aws.sdk.kotlin.services.lambda.model.DestinationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.FilterCriteria] inside the given [block]
         */
        public fun filterCriteria(block: aws.sdk.kotlin.services.lambda.model.FilterCriteria.Builder.() -> kotlin.Unit) {
            this.filterCriteria = aws.sdk.kotlin.services.lambda.model.FilterCriteria.invoke(block)
        }
    }
}
