// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A mapping between an Amazon Web Services resource and a Lambda function. For details, see CreateEventSourceMapping.
 */
public class UpdateEventSourceMappingResponse private constructor(builder: Builder) {
    /**
     * Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
     */
    public val amazonManagedKafkaEventSourceConfig: aws.sdk.kotlin.services.lambda.model.AmazonManagedKafkaEventSourceConfig? = builder.amazonManagedKafkaEventSourceConfig
    /**
     * The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).
     *
     * Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.
     *
     * Related setting: When you set `BatchSize` to a value greater than 10, you must set `MaximumBatchingWindowInSeconds` to at least 1.
     */
    public val batchSize: kotlin.Int? = builder.batchSize
    /**
     * (Streams only) If the function returns an error, split the batch in two and retry. The default value is false.
     */
    public val bisectBatchOnFunctionError: kotlin.Boolean? = builder.bisectBatchOnFunctionError
    /**
     * (Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
     */
    public val destinationConfig: aws.sdk.kotlin.services.lambda.model.DestinationConfig? = builder.destinationConfig
    /**
     * The Amazon Resource Name (ARN) of the event source.
     */
    public val eventSourceArn: kotlin.String? = builder.eventSourceArn
    /**
     * (Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see [Lambda event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html).
     */
    public val filterCriteria: aws.sdk.kotlin.services.lambda.model.FilterCriteria? = builder.filterCriteria
    /**
     * The ARN of the Lambda function.
     */
    public val functionArn: kotlin.String? = builder.functionArn
    /**
     * (Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.
     */
    public val functionResponseTypes: List<FunctionResponseType>? = builder.functionResponseTypes
    /**
     * The date that the event source mapping was last updated or that its state changed.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModified
    /**
     * The result of the last Lambda invocation of your function.
     */
    public val lastProcessingResult: kotlin.String? = builder.lastProcessingResult
    /**
     * (Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.
     *
     * Default: 0
     *
     * Related setting: When you set `BatchSize` to a value greater than 10, you must set `MaximumBatchingWindowInSeconds` to at least 1.
     */
    public val maximumBatchingWindowInSeconds: kotlin.Int? = builder.maximumBatchingWindowInSeconds
    /**
     * (Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.
     */
    public val maximumRecordAgeInSeconds: kotlin.Int? = builder.maximumRecordAgeInSeconds
    /**
     * (Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.
     */
    public val maximumRetryAttempts: kotlin.Int? = builder.maximumRetryAttempts
    /**
     * (Streams only) The number of batches to process concurrently from each shard. The default value is 1.
     */
    public val parallelizationFactor: kotlin.Int? = builder.parallelizationFactor
    /**
     * (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
     */
    public val queues: List<String>? = builder.queues
    /**
     * The self-managed Apache Kafka cluster for your event source.
     */
    public val selfManagedEventSource: aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource? = builder.selfManagedEventSource
    /**
     * Specific configuration settings for a self-managed Apache Kafka event source.
     */
    public val selfManagedKafkaEventSourceConfig: aws.sdk.kotlin.services.lambda.model.SelfManagedKafkaEventSourceConfig? = builder.selfManagedKafkaEventSourceConfig
    /**
     * An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.
     */
    public val sourceAccessConfigurations: List<SourceAccessConfiguration>? = builder.sourceAccessConfigurations
    /**
     * The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. `AT_TIMESTAMP` is supported only for Amazon Kinesis streams.
     */
    public val startingPosition: aws.sdk.kotlin.services.lambda.model.EventSourcePosition? = builder.startingPosition
    /**
     * With `StartingPosition` set to `AT_TIMESTAMP`, the time from which to start reading.
     */
    public val startingPositionTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.startingPositionTimestamp
    /**
     * The state of the event source mapping. It can be one of the following: `Creating`, `Enabling`, `Enabled`, `Disabling`, `Disabled`, `Updating`, or `Deleting`.
     */
    public val state: kotlin.String? = builder.state
    /**
     * Indicates whether a user or Lambda made the last change to the event source mapping.
     */
    public val stateTransitionReason: kotlin.String? = builder.stateTransitionReason
    /**
     * The name of the Kafka topic.
     */
    public val topics: List<String>? = builder.topics
    /**
     * (Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.
     */
    public val tumblingWindowInSeconds: kotlin.Int? = builder.tumblingWindowInSeconds
    /**
     * The identifier of the event source mapping.
     */
    public val uuid: kotlin.String? = builder.uuid

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.UpdateEventSourceMappingResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateEventSourceMappingResponse(")
        append("amazonManagedKafkaEventSourceConfig=$amazonManagedKafkaEventSourceConfig,")
        append("batchSize=$batchSize,")
        append("bisectBatchOnFunctionError=$bisectBatchOnFunctionError,")
        append("destinationConfig=$destinationConfig,")
        append("eventSourceArn=$eventSourceArn,")
        append("filterCriteria=$filterCriteria,")
        append("functionArn=$functionArn,")
        append("functionResponseTypes=$functionResponseTypes,")
        append("lastModified=$lastModified,")
        append("lastProcessingResult=$lastProcessingResult,")
        append("maximumBatchingWindowInSeconds=$maximumBatchingWindowInSeconds,")
        append("maximumRecordAgeInSeconds=$maximumRecordAgeInSeconds,")
        append("maximumRetryAttempts=$maximumRetryAttempts,")
        append("parallelizationFactor=$parallelizationFactor,")
        append("queues=$queues,")
        append("selfManagedEventSource=$selfManagedEventSource,")
        append("selfManagedKafkaEventSourceConfig=$selfManagedKafkaEventSourceConfig,")
        append("sourceAccessConfigurations=$sourceAccessConfigurations,")
        append("startingPosition=$startingPosition,")
        append("startingPositionTimestamp=$startingPositionTimestamp,")
        append("state=$state,")
        append("stateTransitionReason=$stateTransitionReason,")
        append("topics=$topics,")
        append("tumblingWindowInSeconds=$tumblingWindowInSeconds,")
        append("uuid=$uuid)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amazonManagedKafkaEventSourceConfig?.hashCode() ?: 0
        result = 31 * result + (batchSize ?: 0)
        result = 31 * result + (bisectBatchOnFunctionError?.hashCode() ?: 0)
        result = 31 * result + (destinationConfig?.hashCode() ?: 0)
        result = 31 * result + (eventSourceArn?.hashCode() ?: 0)
        result = 31 * result + (filterCriteria?.hashCode() ?: 0)
        result = 31 * result + (functionArn?.hashCode() ?: 0)
        result = 31 * result + (functionResponseTypes?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (lastProcessingResult?.hashCode() ?: 0)
        result = 31 * result + (maximumBatchingWindowInSeconds ?: 0)
        result = 31 * result + (maximumRecordAgeInSeconds ?: 0)
        result = 31 * result + (maximumRetryAttempts ?: 0)
        result = 31 * result + (parallelizationFactor ?: 0)
        result = 31 * result + (queues?.hashCode() ?: 0)
        result = 31 * result + (selfManagedEventSource?.hashCode() ?: 0)
        result = 31 * result + (selfManagedKafkaEventSourceConfig?.hashCode() ?: 0)
        result = 31 * result + (sourceAccessConfigurations?.hashCode() ?: 0)
        result = 31 * result + (startingPosition?.hashCode() ?: 0)
        result = 31 * result + (startingPositionTimestamp?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateTransitionReason?.hashCode() ?: 0)
        result = 31 * result + (topics?.hashCode() ?: 0)
        result = 31 * result + (tumblingWindowInSeconds ?: 0)
        result = 31 * result + (uuid?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateEventSourceMappingResponse

        if (amazonManagedKafkaEventSourceConfig != other.amazonManagedKafkaEventSourceConfig) return false
        if (batchSize != other.batchSize) return false
        if (bisectBatchOnFunctionError != other.bisectBatchOnFunctionError) return false
        if (destinationConfig != other.destinationConfig) return false
        if (eventSourceArn != other.eventSourceArn) return false
        if (filterCriteria != other.filterCriteria) return false
        if (functionArn != other.functionArn) return false
        if (functionResponseTypes != other.functionResponseTypes) return false
        if (lastModified != other.lastModified) return false
        if (lastProcessingResult != other.lastProcessingResult) return false
        if (maximumBatchingWindowInSeconds != other.maximumBatchingWindowInSeconds) return false
        if (maximumRecordAgeInSeconds != other.maximumRecordAgeInSeconds) return false
        if (maximumRetryAttempts != other.maximumRetryAttempts) return false
        if (parallelizationFactor != other.parallelizationFactor) return false
        if (queues != other.queues) return false
        if (selfManagedEventSource != other.selfManagedEventSource) return false
        if (selfManagedKafkaEventSourceConfig != other.selfManagedKafkaEventSourceConfig) return false
        if (sourceAccessConfigurations != other.sourceAccessConfigurations) return false
        if (startingPosition != other.startingPosition) return false
        if (startingPositionTimestamp != other.startingPositionTimestamp) return false
        if (state != other.state) return false
        if (stateTransitionReason != other.stateTransitionReason) return false
        if (topics != other.topics) return false
        if (tumblingWindowInSeconds != other.tumblingWindowInSeconds) return false
        if (uuid != other.uuid) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.UpdateEventSourceMappingResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
         */
        public var amazonManagedKafkaEventSourceConfig: aws.sdk.kotlin.services.lambda.model.AmazonManagedKafkaEventSourceConfig? = null
        /**
         * The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).
         *
         * Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.
         *
         * Related setting: When you set `BatchSize` to a value greater than 10, you must set `MaximumBatchingWindowInSeconds` to at least 1.
         */
        public var batchSize: kotlin.Int? = null
        /**
         * (Streams only) If the function returns an error, split the batch in two and retry. The default value is false.
         */
        public var bisectBatchOnFunctionError: kotlin.Boolean? = null
        /**
         * (Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         */
        public var destinationConfig: aws.sdk.kotlin.services.lambda.model.DestinationConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the event source.
         */
        public var eventSourceArn: kotlin.String? = null
        /**
         * (Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see [Lambda event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html).
         */
        public var filterCriteria: aws.sdk.kotlin.services.lambda.model.FilterCriteria? = null
        /**
         * The ARN of the Lambda function.
         */
        public var functionArn: kotlin.String? = null
        /**
         * (Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.
         */
        public var functionResponseTypes: List<FunctionResponseType>? = null
        /**
         * The date that the event source mapping was last updated or that its state changed.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The result of the last Lambda invocation of your function.
         */
        public var lastProcessingResult: kotlin.String? = null
        /**
         * (Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.
         *
         * Default: 0
         *
         * Related setting: When you set `BatchSize` to a value greater than 10, you must set `MaximumBatchingWindowInSeconds` to at least 1.
         */
        public var maximumBatchingWindowInSeconds: kotlin.Int? = null
        /**
         * (Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.
         */
        public var maximumRecordAgeInSeconds: kotlin.Int? = null
        /**
         * (Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.
         */
        public var maximumRetryAttempts: kotlin.Int? = null
        /**
         * (Streams only) The number of batches to process concurrently from each shard. The default value is 1.
         */
        public var parallelizationFactor: kotlin.Int? = null
        /**
         * (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
         */
        public var queues: List<String>? = null
        /**
         * The self-managed Apache Kafka cluster for your event source.
         */
        public var selfManagedEventSource: aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource? = null
        /**
         * Specific configuration settings for a self-managed Apache Kafka event source.
         */
        public var selfManagedKafkaEventSourceConfig: aws.sdk.kotlin.services.lambda.model.SelfManagedKafkaEventSourceConfig? = null
        /**
         * An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.
         */
        public var sourceAccessConfigurations: List<SourceAccessConfiguration>? = null
        /**
         * The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. `AT_TIMESTAMP` is supported only for Amazon Kinesis streams.
         */
        public var startingPosition: aws.sdk.kotlin.services.lambda.model.EventSourcePosition? = null
        /**
         * With `StartingPosition` set to `AT_TIMESTAMP`, the time from which to start reading.
         */
        public var startingPositionTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the event source mapping. It can be one of the following: `Creating`, `Enabling`, `Enabled`, `Disabling`, `Disabled`, `Updating`, or `Deleting`.
         */
        public var state: kotlin.String? = null
        /**
         * Indicates whether a user or Lambda made the last change to the event source mapping.
         */
        public var stateTransitionReason: kotlin.String? = null
        /**
         * The name of the Kafka topic.
         */
        public var topics: List<String>? = null
        /**
         * (Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.
         */
        public var tumblingWindowInSeconds: kotlin.Int? = null
        /**
         * The identifier of the event source mapping.
         */
        public var uuid: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.UpdateEventSourceMappingResponse) : this() {
            this.amazonManagedKafkaEventSourceConfig = x.amazonManagedKafkaEventSourceConfig
            this.batchSize = x.batchSize
            this.bisectBatchOnFunctionError = x.bisectBatchOnFunctionError
            this.destinationConfig = x.destinationConfig
            this.eventSourceArn = x.eventSourceArn
            this.filterCriteria = x.filterCriteria
            this.functionArn = x.functionArn
            this.functionResponseTypes = x.functionResponseTypes
            this.lastModified = x.lastModified
            this.lastProcessingResult = x.lastProcessingResult
            this.maximumBatchingWindowInSeconds = x.maximumBatchingWindowInSeconds
            this.maximumRecordAgeInSeconds = x.maximumRecordAgeInSeconds
            this.maximumRetryAttempts = x.maximumRetryAttempts
            this.parallelizationFactor = x.parallelizationFactor
            this.queues = x.queues
            this.selfManagedEventSource = x.selfManagedEventSource
            this.selfManagedKafkaEventSourceConfig = x.selfManagedKafkaEventSourceConfig
            this.sourceAccessConfigurations = x.sourceAccessConfigurations
            this.startingPosition = x.startingPosition
            this.startingPositionTimestamp = x.startingPositionTimestamp
            this.state = x.state
            this.stateTransitionReason = x.stateTransitionReason
            this.topics = x.topics
            this.tumblingWindowInSeconds = x.tumblingWindowInSeconds
            this.uuid = x.uuid
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.UpdateEventSourceMappingResponse = UpdateEventSourceMappingResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.AmazonManagedKafkaEventSourceConfig] inside the given [block]
         */
        public fun amazonManagedKafkaEventSourceConfig(block: aws.sdk.kotlin.services.lambda.model.AmazonManagedKafkaEventSourceConfig.Builder.() -> kotlin.Unit) {
            this.amazonManagedKafkaEventSourceConfig = aws.sdk.kotlin.services.lambda.model.AmazonManagedKafkaEventSourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.DestinationConfig] inside the given [block]
         */
        public fun destinationConfig(block: aws.sdk.kotlin.services.lambda.model.DestinationConfig.Builder.() -> kotlin.Unit) {
            this.destinationConfig = aws.sdk.kotlin.services.lambda.model.DestinationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.FilterCriteria] inside the given [block]
         */
        public fun filterCriteria(block: aws.sdk.kotlin.services.lambda.model.FilterCriteria.Builder.() -> kotlin.Unit) {
            this.filterCriteria = aws.sdk.kotlin.services.lambda.model.FilterCriteria.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource] inside the given [block]
         */
        public fun selfManagedEventSource(block: aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource.Builder.() -> kotlin.Unit) {
            this.selfManagedEventSource = aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.SelfManagedKafkaEventSourceConfig] inside the given [block]
         */
        public fun selfManagedKafkaEventSourceConfig(block: aws.sdk.kotlin.services.lambda.model.SelfManagedKafkaEventSourceConfig.Builder.() -> kotlin.Unit) {
            this.selfManagedKafkaEventSourceConfig = aws.sdk.kotlin.services.lambda.model.SelfManagedKafkaEventSourceConfig.invoke(block)
        }
    }
}
