// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



public class UpdateFunctionCodeRequest private constructor(builder: Builder) {
    /**
     * The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is `x86_64`.
     */
    public val architectures: List<Architecture>? = builder.architectures
    /**
     * Set to true to validate the request parameters and access permissions without modifying the function code.
     */
    public val dryRun: kotlin.Boolean = builder.dryRun
    /**
     * The name of the Lambda function.
     *
     * **Name formats**
     * + **Function name** - `my-function`.
     * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
     * + **Partial ARN** - `123456789012:function:my-function`.
     *
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    public val functionName: kotlin.String? = requireNotNull(builder.functionName) { "A non-null value must be provided for functionName" }
    /**
     * URI of a container image in the Amazon ECR registry. Do not use for a function defined with a .zip file archive.
     */
    public val imageUri: kotlin.String? = builder.imageUri
    /**
     * Set to true to publish a new version of the function after updating the code. This has the same effect as calling PublishVersion separately.
     */
    public val publish: kotlin.Boolean = builder.publish
    /**
     * Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account. Use only with a function defined with a .zip file archive deployment package.
     */
    public val s3Bucket: kotlin.String? = builder.s3Bucket
    /**
     * The Amazon S3 key of the deployment package. Use only with a function defined with a .zip file archive deployment package.
     */
    public val s3Key: kotlin.String? = builder.s3Key
    /**
     * For versioned objects, the version of the deployment package object to use.
     */
    public val s3ObjectVersion: kotlin.String? = builder.s3ObjectVersion
    /**
     * The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for you. Use only with a function defined with a .zip file archive deployment package.
     */
    public val zipFile: kotlin.ByteArray? = builder.zipFile

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.UpdateFunctionCodeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFunctionCodeRequest(")
        append("architectures=$architectures,")
        append("dryRun=$dryRun,")
        append("functionName=$functionName,")
        append("imageUri=$imageUri,")
        append("publish=$publish,")
        append("revisionId=$revisionId,")
        append("s3Bucket=$s3Bucket,")
        append("s3Key=$s3Key,")
        append("s3ObjectVersion=$s3ObjectVersion,")
        append("zipFile=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = architectures?.hashCode() ?: 0
        result = 31 * result + (dryRun.hashCode())
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (imageUri?.hashCode() ?: 0)
        result = 31 * result + (publish.hashCode())
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        result = 31 * result + (s3Key?.hashCode() ?: 0)
        result = 31 * result + (s3ObjectVersion?.hashCode() ?: 0)
        result = 31 * result + (zipFile?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFunctionCodeRequest

        if (architectures != other.architectures) return false
        if (dryRun != other.dryRun) return false
        if (functionName != other.functionName) return false
        if (imageUri != other.imageUri) return false
        if (publish != other.publish) return false
        if (revisionId != other.revisionId) return false
        if (s3Bucket != other.s3Bucket) return false
        if (s3Key != other.s3Key) return false
        if (s3ObjectVersion != other.s3ObjectVersion) return false
        if (zipFile != null) {
            if (other.zipFile == null) return false
            if (!zipFile.contentEquals(other.zipFile)) return false
        } else if (other.zipFile != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.UpdateFunctionCodeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is `x86_64`.
         */
        public var architectures: List<Architecture>? = null
        /**
         * Set to true to validate the request parameters and access permissions without modifying the function code.
         */
        public var dryRun: kotlin.Boolean = false
        /**
         * The name of the Lambda function.
         *
         * **Name formats**
         * + **Function name** - `my-function`.
         * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
         * + **Partial ARN** - `123456789012:function:my-function`.
         *
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         */
        public var functionName: kotlin.String? = null
        /**
         * URI of a container image in the Amazon ECR registry. Do not use for a function defined with a .zip file archive.
         */
        public var imageUri: kotlin.String? = null
        /**
         * Set to true to publish a new version of the function after updating the code. This has the same effect as calling PublishVersion separately.
         */
        public var publish: kotlin.Boolean = false
        /**
         * Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.
         */
        public var revisionId: kotlin.String? = null
        /**
         * An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account. Use only with a function defined with a .zip file archive deployment package.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * The Amazon S3 key of the deployment package. Use only with a function defined with a .zip file archive deployment package.
         */
        public var s3Key: kotlin.String? = null
        /**
         * For versioned objects, the version of the deployment package object to use.
         */
        public var s3ObjectVersion: kotlin.String? = null
        /**
         * The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for you. Use only with a function defined with a .zip file archive deployment package.
         */
        public var zipFile: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.UpdateFunctionCodeRequest) : this() {
            this.architectures = x.architectures
            this.dryRun = x.dryRun
            this.functionName = x.functionName
            this.imageUri = x.imageUri
            this.publish = x.publish
            this.revisionId = x.revisionId
            this.s3Bucket = x.s3Bucket
            this.s3Key = x.s3Key
            this.s3ObjectVersion = x.s3ObjectVersion
            this.zipFile = x.zipFile
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.UpdateFunctionCodeRequest = UpdateFunctionCodeRequest(this)
    }
}
