// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lambda.model.AmazonManagedKafkaEventSourceConfig
import aws.sdk.kotlin.services.lambda.model.CreateEventSourceMappingResponse
import aws.sdk.kotlin.services.lambda.model.DestinationConfig
import aws.sdk.kotlin.services.lambda.model.EventSourcePosition
import aws.sdk.kotlin.services.lambda.model.FilterCriteria
import aws.sdk.kotlin.services.lambda.model.FunctionResponseType
import aws.sdk.kotlin.services.lambda.model.LambdaException
import aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource
import aws.sdk.kotlin.services.lambda.model.SelfManagedKafkaEventSourceConfig
import aws.sdk.kotlin.services.lambda.model.SourceAccessConfiguration
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateEventSourceMappingOperationDeserializer: HttpDeserialize<CreateEventSourceMappingResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateEventSourceMappingResponse {
        if (!response.status.isSuccess()) {
            throwCreateEventSourceMappingError(context, response)
        }
        val builder = CreateEventSourceMappingResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateEventSourceMappingOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateEventSourceMappingError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LambdaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LambdaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateEventSourceMappingOperationBody(builder: CreateEventSourceMappingResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AMAZONMANAGEDKAFKAEVENTSOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AmazonManagedKafkaEventSourceConfig"))
    val BATCHSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("BatchSize"))
    val BISECTBATCHONFUNCTIONERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("BisectBatchOnFunctionError"))
    val DESTINATIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DestinationConfig"))
    val EVENTSOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EventSourceArn"))
    val FILTERCRITERIA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FilterCriteria"))
    val FUNCTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FunctionArn"))
    val FUNCTIONRESPONSETYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FunctionResponseTypes"))
    val LASTMODIFIED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModified"))
    val LASTPROCESSINGRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastProcessingResult"))
    val MAXIMUMBATCHINGWINDOWINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaximumBatchingWindowInSeconds"))
    val MAXIMUMRECORDAGEINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaximumRecordAgeInSeconds"))
    val MAXIMUMRETRYATTEMPTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaximumRetryAttempts"))
    val PARALLELIZATIONFACTOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ParallelizationFactor"))
    val QUEUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Queues"))
    val SELFMANAGEDEVENTSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SelfManagedEventSource"))
    val SELFMANAGEDKAFKAEVENTSOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SelfManagedKafkaEventSourceConfig"))
    val SOURCEACCESSCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SourceAccessConfigurations"))
    val STARTINGPOSITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StartingPosition"))
    val STARTINGPOSITIONTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartingPositionTimestamp"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val STATETRANSITIONREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StateTransitionReason"))
    val TOPICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Topics"))
    val TUMBLINGWINDOWINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("TumblingWindowInSeconds"))
    val UUID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UUID"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AMAZONMANAGEDKAFKAEVENTSOURCECONFIG_DESCRIPTOR)
        field(BATCHSIZE_DESCRIPTOR)
        field(BISECTBATCHONFUNCTIONERROR_DESCRIPTOR)
        field(DESTINATIONCONFIG_DESCRIPTOR)
        field(EVENTSOURCEARN_DESCRIPTOR)
        field(FILTERCRITERIA_DESCRIPTOR)
        field(FUNCTIONARN_DESCRIPTOR)
        field(FUNCTIONRESPONSETYPES_DESCRIPTOR)
        field(LASTMODIFIED_DESCRIPTOR)
        field(LASTPROCESSINGRESULT_DESCRIPTOR)
        field(MAXIMUMBATCHINGWINDOWINSECONDS_DESCRIPTOR)
        field(MAXIMUMRECORDAGEINSECONDS_DESCRIPTOR)
        field(MAXIMUMRETRYATTEMPTS_DESCRIPTOR)
        field(PARALLELIZATIONFACTOR_DESCRIPTOR)
        field(QUEUES_DESCRIPTOR)
        field(SELFMANAGEDEVENTSOURCE_DESCRIPTOR)
        field(SELFMANAGEDKAFKAEVENTSOURCECONFIG_DESCRIPTOR)
        field(SOURCEACCESSCONFIGURATIONS_DESCRIPTOR)
        field(STARTINGPOSITION_DESCRIPTOR)
        field(STARTINGPOSITIONTIMESTAMP_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(STATETRANSITIONREASON_DESCRIPTOR)
        field(TOPICS_DESCRIPTOR)
        field(TUMBLINGWINDOWINSECONDS_DESCRIPTOR)
        field(UUID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AMAZONMANAGEDKAFKAEVENTSOURCECONFIG_DESCRIPTOR.index -> builder.amazonManagedKafkaEventSourceConfig = deserializeAmazonManagedKafkaEventSourceConfigDocument(deserializer)
                BATCHSIZE_DESCRIPTOR.index -> builder.batchSize = deserializeInt()
                BISECTBATCHONFUNCTIONERROR_DESCRIPTOR.index -> builder.bisectBatchOnFunctionError = deserializeBoolean()
                DESTINATIONCONFIG_DESCRIPTOR.index -> builder.destinationConfig = deserializeDestinationConfigDocument(deserializer)
                EVENTSOURCEARN_DESCRIPTOR.index -> builder.eventSourceArn = deserializeString()
                FILTERCRITERIA_DESCRIPTOR.index -> builder.filterCriteria = deserializeFilterCriteriaDocument(deserializer)
                FUNCTIONARN_DESCRIPTOR.index -> builder.functionArn = deserializeString()
                FUNCTIONRESPONSETYPES_DESCRIPTOR.index -> builder.functionResponseTypes =
                    deserializer.deserializeList(FUNCTIONRESPONSETYPES_DESCRIPTOR) {
                        val col0 = mutableListOf<FunctionResponseType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { FunctionResponseType.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LASTMODIFIED_DESCRIPTOR.index -> builder.lastModified = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTPROCESSINGRESULT_DESCRIPTOR.index -> builder.lastProcessingResult = deserializeString()
                MAXIMUMBATCHINGWINDOWINSECONDS_DESCRIPTOR.index -> builder.maximumBatchingWindowInSeconds = deserializeInt()
                MAXIMUMRECORDAGEINSECONDS_DESCRIPTOR.index -> builder.maximumRecordAgeInSeconds = deserializeInt()
                MAXIMUMRETRYATTEMPTS_DESCRIPTOR.index -> builder.maximumRetryAttempts = deserializeInt()
                PARALLELIZATIONFACTOR_DESCRIPTOR.index -> builder.parallelizationFactor = deserializeInt()
                QUEUES_DESCRIPTOR.index -> builder.queues =
                    deserializer.deserializeList(QUEUES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SELFMANAGEDEVENTSOURCE_DESCRIPTOR.index -> builder.selfManagedEventSource = deserializeSelfManagedEventSourceDocument(deserializer)
                SELFMANAGEDKAFKAEVENTSOURCECONFIG_DESCRIPTOR.index -> builder.selfManagedKafkaEventSourceConfig = deserializeSelfManagedKafkaEventSourceConfigDocument(deserializer)
                SOURCEACCESSCONFIGURATIONS_DESCRIPTOR.index -> builder.sourceAccessConfigurations =
                    deserializer.deserializeList(SOURCEACCESSCONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<SourceAccessConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSourceAccessConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STARTINGPOSITION_DESCRIPTOR.index -> builder.startingPosition = deserializeString().let { EventSourcePosition.fromValue(it) }
                STARTINGPOSITIONTIMESTAMP_DESCRIPTOR.index -> builder.startingPositionTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATE_DESCRIPTOR.index -> builder.state = deserializeString()
                STATETRANSITIONREASON_DESCRIPTOR.index -> builder.stateTransitionReason = deserializeString()
                TOPICS_DESCRIPTOR.index -> builder.topics =
                    deserializer.deserializeList(TOPICS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TUMBLINGWINDOWINSECONDS_DESCRIPTOR.index -> builder.tumblingWindowInSeconds = deserializeInt()
                UUID_DESCRIPTOR.index -> builder.uuid = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
