// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



/**
 * Limits that are related to concurrency and storage. All file and storage sizes are in bytes.
 */
public class AccountLimit private constructor(builder: Builder) {
    /**
     * The maximum size of a function's deployment package and layers when they're extracted.
     */
    public val codeSizeUnzipped: kotlin.Long = builder.codeSizeUnzipped
    /**
     * The maximum size of a deployment package when it's uploaded directly to Lambda. Use Amazon S3 for larger files.
     */
    public val codeSizeZipped: kotlin.Long = builder.codeSizeZipped
    /**
     * The maximum number of simultaneous function executions.
     */
    public val concurrentExecutions: kotlin.Int = builder.concurrentExecutions
    /**
     * The amount of storage space that you can use for all deployment packages and layer archives.
     */
    public val totalCodeSize: kotlin.Long = builder.totalCodeSize
    /**
     * The maximum number of simultaneous function executions, minus the capacity that's reserved for individual functions with PutFunctionConcurrency.
     */
    public val unreservedConcurrentExecutions: kotlin.Int? = builder.unreservedConcurrentExecutions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.AccountLimit = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountLimit(")
        append("codeSizeUnzipped=$codeSizeUnzipped,")
        append("codeSizeZipped=$codeSizeZipped,")
        append("concurrentExecutions=$concurrentExecutions,")
        append("totalCodeSize=$totalCodeSize,")
        append("unreservedConcurrentExecutions=$unreservedConcurrentExecutions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeSizeUnzipped.hashCode()
        result = 31 * result + (codeSizeZipped.hashCode())
        result = 31 * result + (concurrentExecutions)
        result = 31 * result + (totalCodeSize.hashCode())
        result = 31 * result + (unreservedConcurrentExecutions ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountLimit

        if (codeSizeUnzipped != other.codeSizeUnzipped) return false
        if (codeSizeZipped != other.codeSizeZipped) return false
        if (concurrentExecutions != other.concurrentExecutions) return false
        if (totalCodeSize != other.totalCodeSize) return false
        if (unreservedConcurrentExecutions != other.unreservedConcurrentExecutions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.AccountLimit = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum size of a function's deployment package and layers when they're extracted.
         */
        public var codeSizeUnzipped: kotlin.Long = 0L
        /**
         * The maximum size of a deployment package when it's uploaded directly to Lambda. Use Amazon S3 for larger files.
         */
        public var codeSizeZipped: kotlin.Long = 0L
        /**
         * The maximum number of simultaneous function executions.
         */
        public var concurrentExecutions: kotlin.Int = 0
        /**
         * The amount of storage space that you can use for all deployment packages and layer archives.
         */
        public var totalCodeSize: kotlin.Long = 0L
        /**
         * The maximum number of simultaneous function executions, minus the capacity that's reserved for individual functions with PutFunctionConcurrency.
         */
        public var unreservedConcurrentExecutions: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.AccountLimit) : this() {
            this.codeSizeUnzipped = x.codeSizeUnzipped
            this.codeSizeZipped = x.codeSizeZipped
            this.concurrentExecutions = x.concurrentExecutions
            this.totalCodeSize = x.totalCodeSize
            this.unreservedConcurrentExecutions = x.unreservedConcurrentExecutions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.AccountLimit = AccountLimit(this)
    }
}
