// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateEventSourceMappingRequest private constructor(builder: Builder) {
    /**
     * Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
     */
    public val amazonManagedKafkaEventSourceConfig: aws.sdk.kotlin.services.lambda.model.AmazonManagedKafkaEventSourceConfig? = builder.amazonManagedKafkaEventSourceConfig
    /**
     * The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).
     * + **Amazon Kinesis** - Default 100. Max 10,000.
     * + **Amazon DynamoDB Streams** - Default 100. Max 10,000.
     * + **Amazon Simple Queue Service** - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.
     * + **Amazon Managed Streaming for Apache Kafka** - Default 100. Max 10,000.
     * + **Self-managed Apache Kafka** - Default 100. Max 10,000.
     * + **Amazon MQ (ActiveMQ and RabbitMQ)** - Default 100. Max 10,000.
     */
    public val batchSize: kotlin.Int? = builder.batchSize
    /**
     * (Streams only) If the function returns an error, split the batch in two and retry.
     */
    public val bisectBatchOnFunctionError: kotlin.Boolean? = builder.bisectBatchOnFunctionError
    /**
     * (Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
     */
    public val destinationConfig: aws.sdk.kotlin.services.lambda.model.DestinationConfig? = builder.destinationConfig
    /**
     * When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
     *
     * Default: True
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The Amazon Resource Name (ARN) of the event source.
     * + **Amazon Kinesis** - The ARN of the data stream or a stream consumer.
     * + **Amazon DynamoDB Streams** - The ARN of the stream.
     * + **Amazon Simple Queue Service** - The ARN of the queue.
     * + **Amazon Managed Streaming for Apache Kafka** - The ARN of the cluster.
     * + **Amazon MQ** - The ARN of the broker.
     */
    public val eventSourceArn: kotlin.String? = builder.eventSourceArn
    /**
     * An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see [Lambda event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html).
     */
    public val filterCriteria: aws.sdk.kotlin.services.lambda.model.FilterCriteria? = builder.filterCriteria
    /**
     * The name of the Lambda function.
     *
     * **Name formats**
     * + **Function name** - `MyFunction`.
     * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
     * + **Version or Alias ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD`.
     * + **Partial ARN** - `123456789012:function:MyFunction`.
     *
     * The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.
     */
    public val functionName: kotlin.String? = builder.functionName
    /**
     * (Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.
     */
    public val functionResponseTypes: List<FunctionResponseType>? = builder.functionResponseTypes
    /**
     * The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function. You can configure `MaximumBatchingWindowInSeconds` to any value from 0 seconds to 300 seconds in increments of seconds.
     *
     * For streams and Amazon SQS event sources, the default batching window is 0 seconds. For Amazon MSK, Self-managed Apache Kafka, and Amazon MQ event sources, the default batching window is 500 ms. Note that because you can only change `MaximumBatchingWindowInSeconds` in increments of seconds, you cannot revert back to the 500 ms default batching window after you have changed it. To restore the default batching window, you must create a new event source mapping.
     *
     * Related setting: For streams and Amazon SQS event sources, when you set `BatchSize` to a value greater than 10, you must set `MaximumBatchingWindowInSeconds` to at least 1.
     */
    public val maximumBatchingWindowInSeconds: kotlin.Int? = builder.maximumBatchingWindowInSeconds
    /**
     * (Streams only) Discard records older than the specified age. The default value is infinite (-1).
     */
    public val maximumRecordAgeInSeconds: kotlin.Int? = builder.maximumRecordAgeInSeconds
    /**
     * (Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     */
    public val maximumRetryAttempts: kotlin.Int? = builder.maximumRetryAttempts
    /**
     * (Streams only) The number of batches to process from each shard concurrently.
     */
    public val parallelizationFactor: kotlin.Int? = builder.parallelizationFactor
    /**
     * (MQ) The name of the Amazon MQ broker destination queue to consume.
     */
    public val queues: List<String>? = builder.queues
    /**
     * The self-managed Apache Kafka cluster to receive records from.
     */
    public val selfManagedEventSource: aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource? = builder.selfManagedEventSource
    /**
     * Specific configuration settings for a self-managed Apache Kafka event source.
     */
    public val selfManagedKafkaEventSourceConfig: aws.sdk.kotlin.services.lambda.model.SelfManagedKafkaEventSourceConfig? = builder.selfManagedKafkaEventSourceConfig
    /**
     * An array of authentication protocols or VPC components required to secure your event source.
     */
    public val sourceAccessConfigurations: List<SourceAccessConfiguration>? = builder.sourceAccessConfigurations
    /**
     * The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK Streams sources. `AT_TIMESTAMP` is supported only for Amazon Kinesis streams.
     */
    public val startingPosition: aws.sdk.kotlin.services.lambda.model.EventSourcePosition? = builder.startingPosition
    /**
     * With `StartingPosition` set to `AT_TIMESTAMP`, the time from which to start reading.
     */
    public val startingPositionTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.startingPositionTimestamp
    /**
     * The name of the Kafka topic.
     */
    public val topics: List<String>? = builder.topics
    /**
     * (Streams only) The duration in seconds of a processing window. The range is between 1 second and 900 seconds.
     */
    public val tumblingWindowInSeconds: kotlin.Int? = builder.tumblingWindowInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.CreateEventSourceMappingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEventSourceMappingRequest(")
        append("amazonManagedKafkaEventSourceConfig=$amazonManagedKafkaEventSourceConfig,")
        append("batchSize=$batchSize,")
        append("bisectBatchOnFunctionError=$bisectBatchOnFunctionError,")
        append("destinationConfig=$destinationConfig,")
        append("enabled=$enabled,")
        append("eventSourceArn=$eventSourceArn,")
        append("filterCriteria=$filterCriteria,")
        append("functionName=$functionName,")
        append("functionResponseTypes=$functionResponseTypes,")
        append("maximumBatchingWindowInSeconds=$maximumBatchingWindowInSeconds,")
        append("maximumRecordAgeInSeconds=$maximumRecordAgeInSeconds,")
        append("maximumRetryAttempts=$maximumRetryAttempts,")
        append("parallelizationFactor=$parallelizationFactor,")
        append("queues=$queues,")
        append("selfManagedEventSource=$selfManagedEventSource,")
        append("selfManagedKafkaEventSourceConfig=$selfManagedKafkaEventSourceConfig,")
        append("sourceAccessConfigurations=$sourceAccessConfigurations,")
        append("startingPosition=$startingPosition,")
        append("startingPositionTimestamp=$startingPositionTimestamp,")
        append("topics=$topics,")
        append("tumblingWindowInSeconds=$tumblingWindowInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = amazonManagedKafkaEventSourceConfig?.hashCode() ?: 0
        result = 31 * result + (batchSize ?: 0)
        result = 31 * result + (bisectBatchOnFunctionError?.hashCode() ?: 0)
        result = 31 * result + (destinationConfig?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (eventSourceArn?.hashCode() ?: 0)
        result = 31 * result + (filterCriteria?.hashCode() ?: 0)
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (functionResponseTypes?.hashCode() ?: 0)
        result = 31 * result + (maximumBatchingWindowInSeconds ?: 0)
        result = 31 * result + (maximumRecordAgeInSeconds ?: 0)
        result = 31 * result + (maximumRetryAttempts ?: 0)
        result = 31 * result + (parallelizationFactor ?: 0)
        result = 31 * result + (queues?.hashCode() ?: 0)
        result = 31 * result + (selfManagedEventSource?.hashCode() ?: 0)
        result = 31 * result + (selfManagedKafkaEventSourceConfig?.hashCode() ?: 0)
        result = 31 * result + (sourceAccessConfigurations?.hashCode() ?: 0)
        result = 31 * result + (startingPosition?.hashCode() ?: 0)
        result = 31 * result + (startingPositionTimestamp?.hashCode() ?: 0)
        result = 31 * result + (topics?.hashCode() ?: 0)
        result = 31 * result + (tumblingWindowInSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEventSourceMappingRequest

        if (amazonManagedKafkaEventSourceConfig != other.amazonManagedKafkaEventSourceConfig) return false
        if (batchSize != other.batchSize) return false
        if (bisectBatchOnFunctionError != other.bisectBatchOnFunctionError) return false
        if (destinationConfig != other.destinationConfig) return false
        if (enabled != other.enabled) return false
        if (eventSourceArn != other.eventSourceArn) return false
        if (filterCriteria != other.filterCriteria) return false
        if (functionName != other.functionName) return false
        if (functionResponseTypes != other.functionResponseTypes) return false
        if (maximumBatchingWindowInSeconds != other.maximumBatchingWindowInSeconds) return false
        if (maximumRecordAgeInSeconds != other.maximumRecordAgeInSeconds) return false
        if (maximumRetryAttempts != other.maximumRetryAttempts) return false
        if (parallelizationFactor != other.parallelizationFactor) return false
        if (queues != other.queues) return false
        if (selfManagedEventSource != other.selfManagedEventSource) return false
        if (selfManagedKafkaEventSourceConfig != other.selfManagedKafkaEventSourceConfig) return false
        if (sourceAccessConfigurations != other.sourceAccessConfigurations) return false
        if (startingPosition != other.startingPosition) return false
        if (startingPositionTimestamp != other.startingPositionTimestamp) return false
        if (topics != other.topics) return false
        if (tumblingWindowInSeconds != other.tumblingWindowInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.CreateEventSourceMappingRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
         */
        public var amazonManagedKafkaEventSourceConfig: aws.sdk.kotlin.services.lambda.model.AmazonManagedKafkaEventSourceConfig? = null
        /**
         * The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).
         * + **Amazon Kinesis** - Default 100. Max 10,000.
         * + **Amazon DynamoDB Streams** - Default 100. Max 10,000.
         * + **Amazon Simple Queue Service** - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.
         * + **Amazon Managed Streaming for Apache Kafka** - Default 100. Max 10,000.
         * + **Self-managed Apache Kafka** - Default 100. Max 10,000.
         * + **Amazon MQ (ActiveMQ and RabbitMQ)** - Default 100. Max 10,000.
         */
        public var batchSize: kotlin.Int? = null
        /**
         * (Streams only) If the function returns an error, split the batch in two and retry.
         */
        public var bisectBatchOnFunctionError: kotlin.Boolean? = null
        /**
         * (Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         */
        public var destinationConfig: aws.sdk.kotlin.services.lambda.model.DestinationConfig? = null
        /**
         * When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
         *
         * Default: True
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the event source.
         * + **Amazon Kinesis** - The ARN of the data stream or a stream consumer.
         * + **Amazon DynamoDB Streams** - The ARN of the stream.
         * + **Amazon Simple Queue Service** - The ARN of the queue.
         * + **Amazon Managed Streaming for Apache Kafka** - The ARN of the cluster.
         * + **Amazon MQ** - The ARN of the broker.
         */
        public var eventSourceArn: kotlin.String? = null
        /**
         * An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see [Lambda event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html).
         */
        public var filterCriteria: aws.sdk.kotlin.services.lambda.model.FilterCriteria? = null
        /**
         * The name of the Lambda function.
         *
         * **Name formats**
         * + **Function name** - `MyFunction`.
         * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
         * + **Version or Alias ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD`.
         * + **Partial ARN** - `123456789012:function:MyFunction`.
         *
         * The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.
         */
        public var functionName: kotlin.String? = null
        /**
         * (Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.
         */
        public var functionResponseTypes: List<FunctionResponseType>? = null
        /**
         * The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function. You can configure `MaximumBatchingWindowInSeconds` to any value from 0 seconds to 300 seconds in increments of seconds.
         *
         * For streams and Amazon SQS event sources, the default batching window is 0 seconds. For Amazon MSK, Self-managed Apache Kafka, and Amazon MQ event sources, the default batching window is 500 ms. Note that because you can only change `MaximumBatchingWindowInSeconds` in increments of seconds, you cannot revert back to the 500 ms default batching window after you have changed it. To restore the default batching window, you must create a new event source mapping.
         *
         * Related setting: For streams and Amazon SQS event sources, when you set `BatchSize` to a value greater than 10, you must set `MaximumBatchingWindowInSeconds` to at least 1.
         */
        public var maximumBatchingWindowInSeconds: kotlin.Int? = null
        /**
         * (Streams only) Discard records older than the specified age. The default value is infinite (-1).
         */
        public var maximumRecordAgeInSeconds: kotlin.Int? = null
        /**
         * (Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
         */
        public var maximumRetryAttempts: kotlin.Int? = null
        /**
         * (Streams only) The number of batches to process from each shard concurrently.
         */
        public var parallelizationFactor: kotlin.Int? = null
        /**
         * (MQ) The name of the Amazon MQ broker destination queue to consume.
         */
        public var queues: List<String>? = null
        /**
         * The self-managed Apache Kafka cluster to receive records from.
         */
        public var selfManagedEventSource: aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource? = null
        /**
         * Specific configuration settings for a self-managed Apache Kafka event source.
         */
        public var selfManagedKafkaEventSourceConfig: aws.sdk.kotlin.services.lambda.model.SelfManagedKafkaEventSourceConfig? = null
        /**
         * An array of authentication protocols or VPC components required to secure your event source.
         */
        public var sourceAccessConfigurations: List<SourceAccessConfiguration>? = null
        /**
         * The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK Streams sources. `AT_TIMESTAMP` is supported only for Amazon Kinesis streams.
         */
        public var startingPosition: aws.sdk.kotlin.services.lambda.model.EventSourcePosition? = null
        /**
         * With `StartingPosition` set to `AT_TIMESTAMP`, the time from which to start reading.
         */
        public var startingPositionTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Kafka topic.
         */
        public var topics: List<String>? = null
        /**
         * (Streams only) The duration in seconds of a processing window. The range is between 1 second and 900 seconds.
         */
        public var tumblingWindowInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.CreateEventSourceMappingRequest) : this() {
            this.amazonManagedKafkaEventSourceConfig = x.amazonManagedKafkaEventSourceConfig
            this.batchSize = x.batchSize
            this.bisectBatchOnFunctionError = x.bisectBatchOnFunctionError
            this.destinationConfig = x.destinationConfig
            this.enabled = x.enabled
            this.eventSourceArn = x.eventSourceArn
            this.filterCriteria = x.filterCriteria
            this.functionName = x.functionName
            this.functionResponseTypes = x.functionResponseTypes
            this.maximumBatchingWindowInSeconds = x.maximumBatchingWindowInSeconds
            this.maximumRecordAgeInSeconds = x.maximumRecordAgeInSeconds
            this.maximumRetryAttempts = x.maximumRetryAttempts
            this.parallelizationFactor = x.parallelizationFactor
            this.queues = x.queues
            this.selfManagedEventSource = x.selfManagedEventSource
            this.selfManagedKafkaEventSourceConfig = x.selfManagedKafkaEventSourceConfig
            this.sourceAccessConfigurations = x.sourceAccessConfigurations
            this.startingPosition = x.startingPosition
            this.startingPositionTimestamp = x.startingPositionTimestamp
            this.topics = x.topics
            this.tumblingWindowInSeconds = x.tumblingWindowInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.CreateEventSourceMappingRequest = CreateEventSourceMappingRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.AmazonManagedKafkaEventSourceConfig] inside the given [block]
         */
        public fun amazonManagedKafkaEventSourceConfig(block: aws.sdk.kotlin.services.lambda.model.AmazonManagedKafkaEventSourceConfig.Builder.() -> kotlin.Unit) {
            this.amazonManagedKafkaEventSourceConfig = aws.sdk.kotlin.services.lambda.model.AmazonManagedKafkaEventSourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.DestinationConfig] inside the given [block]
         */
        public fun destinationConfig(block: aws.sdk.kotlin.services.lambda.model.DestinationConfig.Builder.() -> kotlin.Unit) {
            this.destinationConfig = aws.sdk.kotlin.services.lambda.model.DestinationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.FilterCriteria] inside the given [block]
         */
        public fun filterCriteria(block: aws.sdk.kotlin.services.lambda.model.FilterCriteria.Builder.() -> kotlin.Unit) {
            this.filterCriteria = aws.sdk.kotlin.services.lambda.model.FilterCriteria.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource] inside the given [block]
         */
        public fun selfManagedEventSource(block: aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource.Builder.() -> kotlin.Unit) {
            this.selfManagedEventSource = aws.sdk.kotlin.services.lambda.model.SelfManagedEventSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.SelfManagedKafkaEventSourceConfig] inside the given [block]
         */
        public fun selfManagedKafkaEventSourceConfig(block: aws.sdk.kotlin.services.lambda.model.SelfManagedKafkaEventSourceConfig.Builder.() -> kotlin.Unit) {
            this.selfManagedKafkaEventSourceConfig = aws.sdk.kotlin.services.lambda.model.SelfManagedKafkaEventSourceConfig.invoke(block)
        }
    }
}
