// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lambda.model.Architecture
import aws.sdk.kotlin.services.lambda.model.GetLayerVersionByArnResponse
import aws.sdk.kotlin.services.lambda.model.LambdaException
import aws.sdk.kotlin.services.lambda.model.LayerVersionContentOutput
import aws.sdk.kotlin.services.lambda.model.Runtime
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetLayerVersionByArnOperationDeserializer: HttpDeserialize<GetLayerVersionByArnResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetLayerVersionByArnResponse {
        if (!response.status.isSuccess()) {
            throwGetLayerVersionByArnError(context, response)
        }
        val builder = GetLayerVersionByArnResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetLayerVersionByArnOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetLayerVersionByArnError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LambdaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LambdaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetLayerVersionByArnOperationBody(builder: GetLayerVersionByArnResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPATIBLEARCHITECTURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CompatibleArchitectures"))
    val COMPATIBLERUNTIMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CompatibleRuntimes"))
    val CONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Content"))
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatedDate"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val LAYERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LayerArn"))
    val LAYERVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LayerVersionArn"))
    val LICENSEINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LicenseInfo"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("Version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPATIBLEARCHITECTURES_DESCRIPTOR)
        field(COMPATIBLERUNTIMES_DESCRIPTOR)
        field(CONTENT_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LAYERARN_DESCRIPTOR)
        field(LAYERVERSIONARN_DESCRIPTOR)
        field(LICENSEINFO_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPATIBLEARCHITECTURES_DESCRIPTOR.index -> builder.compatibleArchitectures =
                    deserializer.deserializeList(COMPATIBLEARCHITECTURES_DESCRIPTOR) {
                        val col0 = mutableListOf<Architecture>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { Architecture.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                COMPATIBLERUNTIMES_DESCRIPTOR.index -> builder.compatibleRuntimes =
                    deserializer.deserializeList(COMPATIBLERUNTIMES_DESCRIPTOR) {
                        val col0 = mutableListOf<Runtime>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { Runtime.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CONTENT_DESCRIPTOR.index -> builder.content = deserializeLayerVersionContentOutputDocument(deserializer)
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                LAYERARN_DESCRIPTOR.index -> builder.layerArn = deserializeString()
                LAYERVERSIONARN_DESCRIPTOR.index -> builder.layerVersionArn = deserializeString()
                LICENSEINFO_DESCRIPTOR.index -> builder.licenseInfo = deserializeString()
                VERSION_DESCRIPTOR.index -> builder.version = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
