// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lambda.model.LambdaException
import aws.sdk.kotlin.services.lambda.model.ProvisionedConcurrencyStatusEnum
import aws.sdk.kotlin.services.lambda.model.PutProvisionedConcurrencyConfigResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutProvisionedConcurrencyConfigOperationDeserializer: HttpDeserialize<PutProvisionedConcurrencyConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutProvisionedConcurrencyConfigResponse {
        if (!response.status.isSuccess()) {
            throwPutProvisionedConcurrencyConfigError(context, response)
        }
        val builder = PutProvisionedConcurrencyConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutProvisionedConcurrencyConfigOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutProvisionedConcurrencyConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LambdaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LambdaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutProvisionedConcurrencyConfigOperationBody(builder: PutProvisionedConcurrencyConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALLOCATEDPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("AllocatedProvisionedConcurrentExecutions"))
    val AVAILABLEPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("AvailableProvisionedConcurrentExecutions"))
    val LASTMODIFIED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastModified"))
    val REQUESTEDPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("RequestedProvisionedConcurrentExecutions"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusReason"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOCATEDPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR)
        field(AVAILABLEPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR)
        field(LASTMODIFIED_DESCRIPTOR)
        field(REQUESTEDPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALLOCATEDPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR.index -> builder.allocatedProvisionedConcurrentExecutions = deserializeInt()
                AVAILABLEPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR.index -> builder.availableProvisionedConcurrentExecutions = deserializeInt()
                LASTMODIFIED_DESCRIPTOR.index -> builder.lastModified = deserializeString()
                REQUESTEDPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR.index -> builder.requestedProvisionedConcurrentExecutions = deserializeInt()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ProvisionedConcurrencyStatusEnum.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
