// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimev2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.lexruntimev2.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.lexruntimev2.model.*
import aws.sdk.kotlin.services.lexruntimev2.model.DeleteSessionRequest
import aws.sdk.kotlin.services.lexruntimev2.model.DeleteSessionResponse
import aws.sdk.kotlin.services.lexruntimev2.model.GetSessionRequest
import aws.sdk.kotlin.services.lexruntimev2.model.GetSessionResponse
import aws.sdk.kotlin.services.lexruntimev2.model.RecognizeTextRequest
import aws.sdk.kotlin.services.lexruntimev2.model.RecognizeTextResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 *
 */
public interface LexRuntimeV2Client : SdkClient {

    override val serviceName: String
        get() = "Lex Runtime V2"
    /**
     * LexRuntimeV2Client's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): LexRuntimeV2Client {
            val config = Config.Builder().apply(block).build()
            return DefaultLexRuntimeV2Client(config)
        }

        public operator fun invoke(config: Config): LexRuntimeV2Client = DefaultLexRuntimeV2Client(config)

        /**
         * Construct a [LexRuntimeV2Client] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): LexRuntimeV2Client {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultLexRuntimeV2Client(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Removes session information for a specified bot, alias, and user ID.
     *
     * You can use this operation to restart a conversation with a bot. When you remove a session, the entire history of the session is removed so that you can start again.
     *
     * You don't need to delete a session. Sessions have a time limit and will expire. Set the session time limit when you create the bot. The default is 5 minutes, but you can specify anything between 1 minute and 24 hours.
     *
     * If you specify a bot or alias ID that doesn't exist, you receive a `BadRequestException.`
     *
     * If the locale doesn't exist in the bot, or if the locale hasn't been enables for the alias, you receive a `BadRequestException`.
     */
    public suspend fun deleteSession(input: DeleteSessionRequest): DeleteSessionResponse

    /**
     * Returns session information for a specified bot, alias, and user.
     *
     * For example, you can use this operation to retrieve session information for a user that has left a long-running session in use.
     *
     * If the bot, alias, or session identifier doesn't exist, Amazon Lex V2 returns a `BadRequestException`. If the locale doesn't exist or is not enabled for the alias, you receive a `BadRequestException`.
     */
    public suspend fun getSession(input: GetSessionRequest): GetSessionResponse

    /**
     * Creates a new session or modifies an existing session with an Amazon Lex V2 bot. Use this operation to enable your application to set the state of the bot.
     */
    public suspend fun <T> putSession(input: PutSessionRequest, block: suspend (PutSessionResponse) -> T): T

    /**
     * Sends user input to Amazon Lex V2. Client applications use this API to send requests to Amazon Lex V2 at runtime. Amazon Lex V2 then interprets the user input using the machine learning model that it build for the bot.
     *
     * In response, Amazon Lex V2 returns the next message to convey to the user and an optional response card to display.
     *
     * If the optional post-fulfillment response is specified, the messages are returned as follows. For more information, see [PostFulfillmentStatusSpecification](https://docs.aws.amazon.com/lexv2/latest/dg/API_PostFulfillmentStatusSpecification.html).
     * + **Success message** - Returned if the Lambda function completes successfully and the intent state is fulfilled or ready fulfillment if the message is present.
     * + **Failed message** - The failed message is returned if the Lambda function throws an exception or if the Lambda function returns a failed intent state without a message.
     * + **Timeout message** - If you don't configure a timeout message and a timeout, and the Lambda function doesn't return within 30 seconds, the timeout message is returned. If you configure a timeout, the timeout message is returned when the period times out.
     *
     * For more information, see [Completion message](https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete.html).
     */
    public suspend fun recognizeText(input: RecognizeTextRequest): RecognizeTextResponse

    /**
     * Sends user input to Amazon Lex V2. You can send text or speech. Clients use this API to send text and audio requests to Amazon Lex V2 at runtime. Amazon Lex V2 interprets the user input using the machine learning model built for the bot.
     *
     * The following request fields must be compressed with gzip and then base64 encoded before you send them to Amazon Lex V2.
     * + requestAttributes
     * + sessionState
     *
     * The following response fields are compressed using gzip and then base64 encoded by Amazon Lex V2. Before you can use these fields, you must decode and decompress them.
     * + inputTranscript
     * + interpretations
     * + messages
     * + requestAttributes
     * + sessionState
     *
     * The example contains a Java application that compresses and encodes a Java object to send to Amazon Lex V2, and a second that decodes and decompresses a response from Amazon Lex V2.
     *
     * If the optional post-fulfillment response is specified, the messages are returned as follows. For more information, see [PostFulfillmentStatusSpecification](https://docs.aws.amazon.com/lexv2/latest/dg/API_PostFulfillmentStatusSpecification.html).
     * + **Success message** - Returned if the Lambda function completes successfully and the intent state is fulfilled or ready fulfillment if the message is present.
     * + **Failed message** - The failed message is returned if the Lambda function throws an exception or if the Lambda function returns a failed intent state without a message.
     * + **Timeout message** - If you don't configure a timeout message and a timeout, and the Lambda function doesn't return within 30 seconds, the timeout message is returned. If you configure a timeout, the timeout message is returned when the period times out.
     *
     * For more information, see [Completion message](https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete.html).
     */
    public suspend fun <T> recognizeUtterance(input: RecognizeUtteranceRequest, block: suspend (RecognizeUtteranceResponse) -> T): T
}

/**
 * Removes session information for a specified bot, alias, and user ID.
 *
 * You can use this operation to restart a conversation with a bot. When you remove a session, the entire history of the session is removed so that you can start again.
 *
 * You don't need to delete a session. Sessions have a time limit and will expire. Set the session time limit when you create the bot. The default is 5 minutes, but you can specify anything between 1 minute and 24 hours.
 *
 * If you specify a bot or alias ID that doesn't exist, you receive a `BadRequestException.`
 *
 * If the locale doesn't exist in the bot, or if the locale hasn't been enables for the alias, you receive a `BadRequestException`.
 */
public suspend inline fun LexRuntimeV2Client.deleteSession(crossinline block: DeleteSessionRequest.Builder.() -> Unit): DeleteSessionResponse = deleteSession(DeleteSessionRequest.Builder().apply(block).build())

/**
 * Returns session information for a specified bot, alias, and user.
 *
 * For example, you can use this operation to retrieve session information for a user that has left a long-running session in use.
 *
 * If the bot, alias, or session identifier doesn't exist, Amazon Lex V2 returns a `BadRequestException`. If the locale doesn't exist or is not enabled for the alias, you receive a `BadRequestException`.
 */
public suspend inline fun LexRuntimeV2Client.getSession(crossinline block: GetSessionRequest.Builder.() -> Unit): GetSessionResponse = getSession(GetSessionRequest.Builder().apply(block).build())

/**
 * Sends user input to Amazon Lex V2. Client applications use this API to send requests to Amazon Lex V2 at runtime. Amazon Lex V2 then interprets the user input using the machine learning model that it build for the bot.
 *
 * In response, Amazon Lex V2 returns the next message to convey to the user and an optional response card to display.
 *
 * If the optional post-fulfillment response is specified, the messages are returned as follows. For more information, see [PostFulfillmentStatusSpecification](https://docs.aws.amazon.com/lexv2/latest/dg/API_PostFulfillmentStatusSpecification.html).
 * + **Success message** - Returned if the Lambda function completes successfully and the intent state is fulfilled or ready fulfillment if the message is present.
 * + **Failed message** - The failed message is returned if the Lambda function throws an exception or if the Lambda function returns a failed intent state without a message.
 * + **Timeout message** - If you don't configure a timeout message and a timeout, and the Lambda function doesn't return within 30 seconds, the timeout message is returned. If you configure a timeout, the timeout message is returned when the period times out.
 *
 * For more information, see [Completion message](https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete.html).
 */
public suspend inline fun LexRuntimeV2Client.recognizeText(crossinline block: RecognizeTextRequest.Builder.() -> Unit): RecognizeTextResponse = recognizeText(RecognizeTextRequest.Builder().apply(block).build())
