// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimev2.model



/**
 * Contains information about the contexts that a user is using in a session. You can configure Amazon Lex V2 to set a context when an intent is fulfilled, or you can set a context using the , , or operations.
 *
 * Use a context to indicate to Amazon Lex V2 intents that should be used as follow-up intents. For example, if the active context is `order-fulfilled`, only intents that have `order-fulfilled` configured as a trigger are considered for follow up.
 */
public class ActiveContext private constructor(builder: Builder) {
    /**
     * A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by including the context in the request.
     *
     * If you don't specify a list of contexts, Amazon Lex V2 will use the current list of contexts for the session. If you specify an empty list, all contexts for the session are cleared.
     */
    public val contextAttributes: Map<String, String>? = builder.contextAttributes
    /**
     * The name of the context.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates the number of turns or seconds that the context is active. Once the time to live expires, the context is no longer returned in a response.
     */
    public val timeToLive: aws.sdk.kotlin.services.lexruntimev2.model.ActiveContextTimeToLive? = builder.timeToLive

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimev2.model.ActiveContext = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActiveContext(")
        append("contextAttributes=$contextAttributes,")
        append("name=$name,")
        append("timeToLive=$timeToLive)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contextAttributes?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (timeToLive?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActiveContext

        if (contextAttributes != other.contextAttributes) return false
        if (name != other.name) return false
        if (timeToLive != other.timeToLive) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimev2.model.ActiveContext = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by including the context in the request.
         *
         * If you don't specify a list of contexts, Amazon Lex V2 will use the current list of contexts for the session. If you specify an empty list, all contexts for the session are cleared.
         */
        public var contextAttributes: Map<String, String>? = null
        /**
         * The name of the context.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates the number of turns or seconds that the context is active. Once the time to live expires, the context is no longer returned in a response.
         */
        public var timeToLive: aws.sdk.kotlin.services.lexruntimev2.model.ActiveContextTimeToLive? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimev2.model.ActiveContext) : this() {
            this.contextAttributes = x.contextAttributes
            this.name = x.name
            this.timeToLive = x.timeToLive
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimev2.model.ActiveContext = ActiveContext(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimev2.model.ActiveContextTimeToLive] inside the given [block]
         */
        public fun timeToLive(block: aws.sdk.kotlin.services.lexruntimev2.model.ActiveContextTimeToLive.Builder.() -> kotlin.Unit) {
            this.timeToLive = aws.sdk.kotlin.services.lexruntimev2.model.ActiveContextTimeToLive.invoke(block)
        }
    }
}
