// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimev2.model



/**
 * The next action that Amazon Lex V2 should take.
 */
public class DialogAction private constructor(builder: Builder) {
    /**
     * Configures the slot to use spell-by-letter or spell-by-word style. When you use a style on a slot, users can spell out their input to make it clear to your bot.
     * + Spell by letter - "b" "o" "b"
     * + Spell by word - "b as in boy" "o as in oscar" "b as in boy"
     *
     * For more information, see [ Using spelling to enter slot values ](https://docs.aws.amazon.com/lexv2/latest/dg/using-spelling.html).
     */
    public val slotElicitationStyle: aws.sdk.kotlin.services.lexruntimev2.model.StyleType? = builder.slotElicitationStyle
    /**
     * The name of the slot that should be elicited from the user.
     */
    public val slotToElicit: kotlin.String? = builder.slotToElicit
    /**
     * The next action that the bot should take in its interaction with the user. The possible values are:
     * + `Close` - Indicates that there will not be a response from the user. For example, the statement "Your order has been placed" does not require a response.
     * + `ConfirmIntent` - The next action is asking the user if the intent is complete and ready to be fulfilled. This is a yes/no question such as "Place the order?"
     * + `Delegate` - The next action is determined by Amazon Lex V2.
     * + `ElicitSlot` - The next action is to elicit a slot value from the user.
     */
    public val type: aws.sdk.kotlin.services.lexruntimev2.model.DialogActionType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimev2.model.DialogAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DialogAction(")
        append("slotElicitationStyle=$slotElicitationStyle,")
        append("slotToElicit=$slotToElicit,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = slotElicitationStyle?.hashCode() ?: 0
        result = 31 * result + (slotToElicit?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DialogAction

        if (slotElicitationStyle != other.slotElicitationStyle) return false
        if (slotToElicit != other.slotToElicit) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimev2.model.DialogAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Configures the slot to use spell-by-letter or spell-by-word style. When you use a style on a slot, users can spell out their input to make it clear to your bot.
         * + Spell by letter - "b" "o" "b"
         * + Spell by word - "b as in boy" "o as in oscar" "b as in boy"
         *
         * For more information, see [ Using spelling to enter slot values ](https://docs.aws.amazon.com/lexv2/latest/dg/using-spelling.html).
         */
        public var slotElicitationStyle: aws.sdk.kotlin.services.lexruntimev2.model.StyleType? = null
        /**
         * The name of the slot that should be elicited from the user.
         */
        public var slotToElicit: kotlin.String? = null
        /**
         * The next action that the bot should take in its interaction with the user. The possible values are:
         * + `Close` - Indicates that there will not be a response from the user. For example, the statement "Your order has been placed" does not require a response.
         * + `ConfirmIntent` - The next action is asking the user if the intent is complete and ready to be fulfilled. This is a yes/no question such as "Place the order?"
         * + `Delegate` - The next action is determined by Amazon Lex V2.
         * + `ElicitSlot` - The next action is to elicit a slot value from the user.
         */
        public var type: aws.sdk.kotlin.services.lexruntimev2.model.DialogActionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimev2.model.DialogAction) : this() {
            this.slotElicitationStyle = x.slotElicitationStyle
            this.slotToElicit = x.slotToElicit
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimev2.model.DialogAction = DialogAction(this)
    }
}
