// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimev2.model



/**
 * An intent that Amazon Lex V2 determined might satisfy the user's utterance. The intents are ordered by the confidence score.
 */
public class Interpretation private constructor(builder: Builder) {
    /**
     * A list of intents that might satisfy the user's utterance. The intents are ordered by the confidence score.
     */
    public val intent: aws.sdk.kotlin.services.lexruntimev2.model.Intent? = builder.intent
    /**
     * Determines the threshold where Amazon Lex V2 will insert the `AMAZON.FallbackIntent`, `AMAZON.KendraSearchIntent`, or both when returning alternative intents in a response. `AMAZON.FallbackIntent` and `AMAZON.KendraSearchIntent` are only inserted if they are configured for the bot.
     */
    public val nluConfidence: aws.sdk.kotlin.services.lexruntimev2.model.ConfidenceScore? = builder.nluConfidence
    /**
     * The sentiment expressed in an utterance.
     *
     * When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field contains the result of the analysis.
     */
    public val sentimentResponse: aws.sdk.kotlin.services.lexruntimev2.model.SentimentResponse? = builder.sentimentResponse

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimev2.model.Interpretation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Interpretation(")
        append("intent=$intent,")
        append("nluConfidence=$nluConfidence,")
        append("sentimentResponse=$sentimentResponse)")
    }

    override fun hashCode(): kotlin.Int {
        var result = intent?.hashCode() ?: 0
        result = 31 * result + (nluConfidence?.hashCode() ?: 0)
        result = 31 * result + (sentimentResponse?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Interpretation

        if (intent != other.intent) return false
        if (nluConfidence != other.nluConfidence) return false
        if (sentimentResponse != other.sentimentResponse) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimev2.model.Interpretation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of intents that might satisfy the user's utterance. The intents are ordered by the confidence score.
         */
        public var intent: aws.sdk.kotlin.services.lexruntimev2.model.Intent? = null
        /**
         * Determines the threshold where Amazon Lex V2 will insert the `AMAZON.FallbackIntent`, `AMAZON.KendraSearchIntent`, or both when returning alternative intents in a response. `AMAZON.FallbackIntent` and `AMAZON.KendraSearchIntent` are only inserted if they are configured for the bot.
         */
        public var nluConfidence: aws.sdk.kotlin.services.lexruntimev2.model.ConfidenceScore? = null
        /**
         * The sentiment expressed in an utterance.
         *
         * When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field contains the result of the analysis.
         */
        public var sentimentResponse: aws.sdk.kotlin.services.lexruntimev2.model.SentimentResponse? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimev2.model.Interpretation) : this() {
            this.intent = x.intent
            this.nluConfidence = x.nluConfidence
            this.sentimentResponse = x.sentimentResponse
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimev2.model.Interpretation = Interpretation(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimev2.model.Intent] inside the given [block]
         */
        public fun intent(block: aws.sdk.kotlin.services.lexruntimev2.model.Intent.Builder.() -> kotlin.Unit) {
            this.intent = aws.sdk.kotlin.services.lexruntimev2.model.Intent.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimev2.model.ConfidenceScore] inside the given [block]
         */
        public fun nluConfidence(block: aws.sdk.kotlin.services.lexruntimev2.model.ConfidenceScore.Builder.() -> kotlin.Unit) {
            this.nluConfidence = aws.sdk.kotlin.services.lexruntimev2.model.ConfidenceScore.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimev2.model.SentimentResponse] inside the given [block]
         */
        public fun sentimentResponse(block: aws.sdk.kotlin.services.lexruntimev2.model.SentimentResponse.Builder.() -> kotlin.Unit) {
            this.sentimentResponse = aws.sdk.kotlin.services.lexruntimev2.model.SentimentResponse.invoke(block)
        }
    }
}
