// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimev2.model



public class PutSessionRequest private constructor(builder: Builder) {
    /**
     * The alias identifier of the bot that receives the session data.
     */
    public val botAliasId: kotlin.String? = requireNotNull(builder.botAliasId) { "A non-null value must be provided for botAliasId" }
    /**
     * The identifier of the bot that receives the session data.
     */
    public val botId: kotlin.String? = requireNotNull(builder.botId) { "A non-null value must be provided for botId" }
    /**
     * The locale where the session is in use.
     */
    public val localeId: kotlin.String? = requireNotNull(builder.localeId) { "A non-null value must be provided for localeId" }
    /**
     * A list of messages to send to the user. Messages are sent in the order that they are defined in the list.
     */
    public val messages: List<Message>? = builder.messages
    /**
     * Request-specific information passed between Amazon Lex V2 and the client application.
     *
     * The namespace `x-amz-lex:` is reserved for special attributes. Don't create any request attributes with the prefix `x-amz-lex:`.
     */
    public val requestAttributes: Map<String, String>? = builder.requestAttributes
    /**
     * The message that Amazon Lex V2 returns in the response can be either text or speech depending on the value of this parameter.
     * + If the value is `text/plain; charset=utf-8`, Amazon Lex V2 returns text in the response.
     */
    public val responseContentType: kotlin.String? = builder.responseContentType
    /**
     * The identifier of the session that receives the session data.
     */
    public val sessionId: kotlin.String? = requireNotNull(builder.sessionId) { "A non-null value must be provided for sessionId" }
    /**
     * Sets the state of the session with the user. You can use this to set the current intent, attributes, context, and dialog action. Use the dialog action to determine the next step that Amazon Lex V2 should use in the conversation with the user.
     */
    public val sessionState: aws.sdk.kotlin.services.lexruntimev2.model.SessionState? = builder.sessionState

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimev2.model.PutSessionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutSessionRequest(")
        append("botAliasId=$botAliasId,")
        append("botId=$botId,")
        append("localeId=$localeId,")
        append("messages=$messages,")
        append("requestAttributes=$requestAttributes,")
        append("responseContentType=$responseContentType,")
        append("sessionId=$sessionId,")
        append("sessionState=$sessionState)")
    }

    override fun hashCode(): kotlin.Int {
        var result = botAliasId?.hashCode() ?: 0
        result = 31 * result + (botId?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (messages?.hashCode() ?: 0)
        result = 31 * result + (requestAttributes?.hashCode() ?: 0)
        result = 31 * result + (responseContentType?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        result = 31 * result + (sessionState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutSessionRequest

        if (botAliasId != other.botAliasId) return false
        if (botId != other.botId) return false
        if (localeId != other.localeId) return false
        if (messages != other.messages) return false
        if (requestAttributes != other.requestAttributes) return false
        if (responseContentType != other.responseContentType) return false
        if (sessionId != other.sessionId) return false
        if (sessionState != other.sessionState) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimev2.model.PutSessionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The alias identifier of the bot that receives the session data.
         */
        public var botAliasId: kotlin.String? = null
        /**
         * The identifier of the bot that receives the session data.
         */
        public var botId: kotlin.String? = null
        /**
         * The locale where the session is in use.
         */
        public var localeId: kotlin.String? = null
        /**
         * A list of messages to send to the user. Messages are sent in the order that they are defined in the list.
         */
        public var messages: List<Message>? = null
        /**
         * Request-specific information passed between Amazon Lex V2 and the client application.
         *
         * The namespace `x-amz-lex:` is reserved for special attributes. Don't create any request attributes with the prefix `x-amz-lex:`.
         */
        public var requestAttributes: Map<String, String>? = null
        /**
         * The message that Amazon Lex V2 returns in the response can be either text or speech depending on the value of this parameter.
         * + If the value is `text/plain; charset=utf-8`, Amazon Lex V2 returns text in the response.
         */
        public var responseContentType: kotlin.String? = null
        /**
         * The identifier of the session that receives the session data.
         */
        public var sessionId: kotlin.String? = null
        /**
         * Sets the state of the session with the user. You can use this to set the current intent, attributes, context, and dialog action. Use the dialog action to determine the next step that Amazon Lex V2 should use in the conversation with the user.
         */
        public var sessionState: aws.sdk.kotlin.services.lexruntimev2.model.SessionState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimev2.model.PutSessionRequest) : this() {
            this.botAliasId = x.botAliasId
            this.botId = x.botId
            this.localeId = x.localeId
            this.messages = x.messages
            this.requestAttributes = x.requestAttributes
            this.responseContentType = x.responseContentType
            this.sessionId = x.sessionId
            this.sessionState = x.sessionState
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimev2.model.PutSessionRequest = PutSessionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimev2.model.SessionState] inside the given [block]
         */
        public fun sessionState(block: aws.sdk.kotlin.services.lexruntimev2.model.SessionState.Builder.() -> kotlin.Unit) {
            this.sessionState = aws.sdk.kotlin.services.lexruntimev2.model.SessionState.invoke(block)
        }
    }
}
