// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimev2.model



public class RecognizeTextRequest private constructor(builder: Builder) {
    /**
     * The alias identifier in use for the bot that processes the request.
     */
    public val botAliasId: kotlin.String? = requireNotNull(builder.botAliasId) { "A non-null value must be provided for botAliasId" }
    /**
     * The identifier of the bot that processes the request.
     */
    public val botId: kotlin.String? = requireNotNull(builder.botId) { "A non-null value must be provided for botId" }
    /**
     * The locale where the session is in use.
     */
    public val localeId: kotlin.String? = requireNotNull(builder.localeId) { "A non-null value must be provided for localeId" }
    /**
     * Request-specific information passed between the client application and Amazon Lex V2
     *
     * The namespace `x-amz-lex:` is reserved for special attributes. Don't create any request attributes with the prefix `x-amz-lex:`.
     */
    public val requestAttributes: Map<String, String>? = builder.requestAttributes
    /**
     * The identifier of the user session that is having the conversation.
     */
    public val sessionId: kotlin.String? = requireNotNull(builder.sessionId) { "A non-null value must be provided for sessionId" }
    /**
     * The current state of the dialog between the user and the bot.
     */
    public val sessionState: aws.sdk.kotlin.services.lexruntimev2.model.SessionState? = builder.sessionState
    /**
     * The text that the user entered. Amazon Lex V2 interprets this text.
     */
    public val text: kotlin.String? = builder.text

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimev2.model.RecognizeTextRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecognizeTextRequest(")
        append("botAliasId=$botAliasId,")
        append("botId=$botId,")
        append("localeId=$localeId,")
        append("requestAttributes=$requestAttributes,")
        append("sessionId=$sessionId,")
        append("sessionState=$sessionState,")
        append("text=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = botAliasId?.hashCode() ?: 0
        result = 31 * result + (botId?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (requestAttributes?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        result = 31 * result + (sessionState?.hashCode() ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecognizeTextRequest

        if (botAliasId != other.botAliasId) return false
        if (botId != other.botId) return false
        if (localeId != other.localeId) return false
        if (requestAttributes != other.requestAttributes) return false
        if (sessionId != other.sessionId) return false
        if (sessionState != other.sessionState) return false
        if (text != other.text) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimev2.model.RecognizeTextRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The alias identifier in use for the bot that processes the request.
         */
        public var botAliasId: kotlin.String? = null
        /**
         * The identifier of the bot that processes the request.
         */
        public var botId: kotlin.String? = null
        /**
         * The locale where the session is in use.
         */
        public var localeId: kotlin.String? = null
        /**
         * Request-specific information passed between the client application and Amazon Lex V2
         *
         * The namespace `x-amz-lex:` is reserved for special attributes. Don't create any request attributes with the prefix `x-amz-lex:`.
         */
        public var requestAttributes: Map<String, String>? = null
        /**
         * The identifier of the user session that is having the conversation.
         */
        public var sessionId: kotlin.String? = null
        /**
         * The current state of the dialog between the user and the bot.
         */
        public var sessionState: aws.sdk.kotlin.services.lexruntimev2.model.SessionState? = null
        /**
         * The text that the user entered. Amazon Lex V2 interprets this text.
         */
        public var text: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimev2.model.RecognizeTextRequest) : this() {
            this.botAliasId = x.botAliasId
            this.botId = x.botId
            this.localeId = x.localeId
            this.requestAttributes = x.requestAttributes
            this.sessionId = x.sessionId
            this.sessionState = x.sessionState
            this.text = x.text
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimev2.model.RecognizeTextRequest = RecognizeTextRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimev2.model.SessionState] inside the given [block]
         */
        public fun sessionState(block: aws.sdk.kotlin.services.lexruntimev2.model.SessionState.Builder.() -> kotlin.Unit) {
            this.sessionState = aws.sdk.kotlin.services.lexruntimev2.model.SessionState.invoke(block)
        }
    }
}
