// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimev2.model



public class RecognizeTextResponse private constructor(builder: Builder) {
    /**
     * A list of intents that Amazon Lex V2 determined might satisfy the user's utterance.
     *
     * Each interpretation includes the intent, a score that indicates now confident Amazon Lex V2 is that the interpretation is the correct one, and an optional sentiment response that indicates the sentiment expressed in the utterance.
     */
    public val interpretations: List<Interpretation>? = builder.interpretations
    /**
     * A list of messages last sent to the user. The messages are ordered based on the order that you returned the messages from your Lambda function or the order that the messages are defined in the bot.
     */
    public val messages: List<Message>? = builder.messages
    /**
     * The attributes sent in the request.
     */
    public val requestAttributes: Map<String, String>? = builder.requestAttributes
    /**
     * The identifier of the session in use.
     */
    public val sessionId: kotlin.String? = builder.sessionId
    /**
     * Represents the current state of the dialog between the user and the bot.
     *
     * Use this to determine the progress of the conversation and what the next action may be.
     */
    public val sessionState: aws.sdk.kotlin.services.lexruntimev2.model.SessionState? = builder.sessionState

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimev2.model.RecognizeTextResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecognizeTextResponse(")
        append("interpretations=$interpretations,")
        append("messages=$messages,")
        append("requestAttributes=$requestAttributes,")
        append("sessionId=$sessionId,")
        append("sessionState=$sessionState)")
    }

    override fun hashCode(): kotlin.Int {
        var result = interpretations?.hashCode() ?: 0
        result = 31 * result + (messages?.hashCode() ?: 0)
        result = 31 * result + (requestAttributes?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        result = 31 * result + (sessionState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecognizeTextResponse

        if (interpretations != other.interpretations) return false
        if (messages != other.messages) return false
        if (requestAttributes != other.requestAttributes) return false
        if (sessionId != other.sessionId) return false
        if (sessionState != other.sessionState) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimev2.model.RecognizeTextResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of intents that Amazon Lex V2 determined might satisfy the user's utterance.
         *
         * Each interpretation includes the intent, a score that indicates now confident Amazon Lex V2 is that the interpretation is the correct one, and an optional sentiment response that indicates the sentiment expressed in the utterance.
         */
        public var interpretations: List<Interpretation>? = null
        /**
         * A list of messages last sent to the user. The messages are ordered based on the order that you returned the messages from your Lambda function or the order that the messages are defined in the bot.
         */
        public var messages: List<Message>? = null
        /**
         * The attributes sent in the request.
         */
        public var requestAttributes: Map<String, String>? = null
        /**
         * The identifier of the session in use.
         */
        public var sessionId: kotlin.String? = null
        /**
         * Represents the current state of the dialog between the user and the bot.
         *
         * Use this to determine the progress of the conversation and what the next action may be.
         */
        public var sessionState: aws.sdk.kotlin.services.lexruntimev2.model.SessionState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimev2.model.RecognizeTextResponse) : this() {
            this.interpretations = x.interpretations
            this.messages = x.messages
            this.requestAttributes = x.requestAttributes
            this.sessionId = x.sessionId
            this.sessionState = x.sessionState
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimev2.model.RecognizeTextResponse = RecognizeTextResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimev2.model.SessionState] inside the given [block]
         */
        public fun sessionState(block: aws.sdk.kotlin.services.lexruntimev2.model.SessionState.Builder.() -> kotlin.Unit) {
            this.sessionState = aws.sdk.kotlin.services.lexruntimev2.model.SessionState.invoke(block)
        }
    }
}
