// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimev2.model

import aws.smithy.kotlin.runtime.content.ByteStream

public class RecognizeUtteranceRequest private constructor(builder: Builder) {
    /**
     * The alias identifier in use for the bot that should receive the request.
     */
    public val botAliasId: kotlin.String? = requireNotNull(builder.botAliasId) { "A non-null value must be provided for botAliasId" }
    /**
     * The identifier of the bot that should receive the request.
     */
    public val botId: kotlin.String? = requireNotNull(builder.botId) { "A non-null value must be provided for botId" }
    /**
     * User input in PCM or Opus audio format or text format as described in the `requestContentType` parameter.
     */
    public val inputStream: aws.smithy.kotlin.runtime.content.ByteStream? = builder.inputStream
    /**
     * The locale where the session is in use.
     */
    public val localeId: kotlin.String? = requireNotNull(builder.localeId) { "A non-null value must be provided for localeId" }
    /**
     * Request-specific information passed between the client application and Amazon Lex V2
     *
     * The namespace `x-amz-lex:` is reserved for special attributes. Don't create any request attributes for prefix `x-amz-lex:`.
     *
     * The `requestAttributes` field must be compressed using gzip and then base64 encoded before sending to Amazon Lex V2.
     */
    public val requestAttributes: kotlin.String? = builder.requestAttributes
    /**
     * Indicates the format for audio input or that the content is text. The header must start with one of the following prefixes:
     * + PCM format, audio data must be in little-endian byte order.
     *    + audio/l16; rate=16000; channels=1
     *    + audio/x-l16; sample-rate=16000; channel-count=1
     *    + audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false
     * + Opus format
     *    + audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4
     * + Text format
     *    + text/plain; charset=utf-8
     */
    public val requestContentType: kotlin.String? = builder.requestContentType
    /**
     * The message that Amazon Lex V2 returns in the response can be either text or speech based on the `responseContentType` value.
     * + If the value is `text/plain;charset=utf-8`, Amazon Lex V2 returns text in the response.
     * + If the value begins with `audio/`, Amazon Lex V2 returns speech in the response. Amazon Lex V2 uses Amazon Polly to generate the speech using the configuration that you specified in the `requestContentType` parameter. For example, if you specify `audio/mpeg` as the value, Amazon Lex V2 returns speech in the MPEG format.
     * + If the value is `audio/pcm`, the speech returned is `audio/pcm` at 16 KHz in 16-bit, little-endian format.
     * + The following are the accepted values:
     *    + audio/mpeg
     *    + audio/ogg
     *    + audio/pcm (16 KHz)
     *    + audio&#47;* (defaults to mpeg)
     *    + text/plain; charset=utf-8
     */
    public val responseContentType: kotlin.String? = builder.responseContentType
    /**
     * The identifier of the session in use.
     */
    public val sessionId: kotlin.String? = requireNotNull(builder.sessionId) { "A non-null value must be provided for sessionId" }
    /**
     * Sets the state of the session with the user. You can use this to set the current intent, attributes, context, and dialog action. Use the dialog action to determine the next step that Amazon Lex V2 should use in the conversation with the user.
     *
     * The `sessionState` field must be compressed using gzip and then base64 encoded before sending to Amazon Lex V2.
     */
    public val sessionState: kotlin.String? = builder.sessionState

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimev2.model.RecognizeUtteranceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecognizeUtteranceRequest(")
        append("botAliasId=$botAliasId,")
        append("botId=$botId,")
        append("inputStream=$inputStream,")
        append("localeId=$localeId,")
        append("requestAttributes=*** Sensitive Data Redacted ***,")
        append("requestContentType=$requestContentType,")
        append("responseContentType=$responseContentType,")
        append("sessionId=$sessionId,")
        append("sessionState=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = botAliasId?.hashCode() ?: 0
        result = 31 * result + (botId?.hashCode() ?: 0)
        result = 31 * result + (inputStream?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (requestAttributes?.hashCode() ?: 0)
        result = 31 * result + (requestContentType?.hashCode() ?: 0)
        result = 31 * result + (responseContentType?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        result = 31 * result + (sessionState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecognizeUtteranceRequest

        if (botAliasId != other.botAliasId) return false
        if (botId != other.botId) return false
        if (inputStream != other.inputStream) return false
        if (localeId != other.localeId) return false
        if (requestAttributes != other.requestAttributes) return false
        if (requestContentType != other.requestContentType) return false
        if (responseContentType != other.responseContentType) return false
        if (sessionId != other.sessionId) return false
        if (sessionState != other.sessionState) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimev2.model.RecognizeUtteranceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The alias identifier in use for the bot that should receive the request.
         */
        public var botAliasId: kotlin.String? = null
        /**
         * The identifier of the bot that should receive the request.
         */
        public var botId: kotlin.String? = null
        /**
         * User input in PCM or Opus audio format or text format as described in the `requestContentType` parameter.
         */
        public var inputStream: aws.smithy.kotlin.runtime.content.ByteStream? = null
        /**
         * The locale where the session is in use.
         */
        public var localeId: kotlin.String? = null
        /**
         * Request-specific information passed between the client application and Amazon Lex V2
         *
         * The namespace `x-amz-lex:` is reserved for special attributes. Don't create any request attributes for prefix `x-amz-lex:`.
         *
         * The `requestAttributes` field must be compressed using gzip and then base64 encoded before sending to Amazon Lex V2.
         */
        public var requestAttributes: kotlin.String? = null
        /**
         * Indicates the format for audio input or that the content is text. The header must start with one of the following prefixes:
         * + PCM format, audio data must be in little-endian byte order.
         *    + audio/l16; rate=16000; channels=1
         *    + audio/x-l16; sample-rate=16000; channel-count=1
         *    + audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false
         * + Opus format
         *    + audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4
         * + Text format
         *    + text/plain; charset=utf-8
         */
        public var requestContentType: kotlin.String? = null
        /**
         * The message that Amazon Lex V2 returns in the response can be either text or speech based on the `responseContentType` value.
         * + If the value is `text/plain;charset=utf-8`, Amazon Lex V2 returns text in the response.
         * + If the value begins with `audio/`, Amazon Lex V2 returns speech in the response. Amazon Lex V2 uses Amazon Polly to generate the speech using the configuration that you specified in the `requestContentType` parameter. For example, if you specify `audio/mpeg` as the value, Amazon Lex V2 returns speech in the MPEG format.
         * + If the value is `audio/pcm`, the speech returned is `audio/pcm` at 16 KHz in 16-bit, little-endian format.
         * + The following are the accepted values:
         *    + audio/mpeg
         *    + audio/ogg
         *    + audio/pcm (16 KHz)
         *    + audio&#47;* (defaults to mpeg)
         *    + text/plain; charset=utf-8
         */
        public var responseContentType: kotlin.String? = null
        /**
         * The identifier of the session in use.
         */
        public var sessionId: kotlin.String? = null
        /**
         * Sets the state of the session with the user. You can use this to set the current intent, attributes, context, and dialog action. Use the dialog action to determine the next step that Amazon Lex V2 should use in the conversation with the user.
         *
         * The `sessionState` field must be compressed using gzip and then base64 encoded before sending to Amazon Lex V2.
         */
        public var sessionState: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimev2.model.RecognizeUtteranceRequest) : this() {
            this.botAliasId = x.botAliasId
            this.botId = x.botId
            this.inputStream = x.inputStream
            this.localeId = x.localeId
            this.requestAttributes = x.requestAttributes
            this.requestContentType = x.requestContentType
            this.responseContentType = x.responseContentType
            this.sessionId = x.sessionId
            this.sessionState = x.sessionState
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimev2.model.RecognizeUtteranceRequest = RecognizeUtteranceRequest(this)
    }
}
