// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimev2.model



/**
 * You can provide Amazon Lex V2 with hints to the phrases that a customer is likely to use for a slot. When a slot with hints is resolved, the phrases in the runtime hints are preferred in the resolution. You can provide hints for a maximum of 100 intents. You can provide a maximum of 100 slots.
 *
 * Before you can use runtime hints with an existing bot, you must first rebuild the bot.
 *
 * For more information, see [Using hints to improve accuracy](https://docs.aws.amazon.com/lexv2/latest/dg/using-hints.xml).
 */
public class RuntimeHints private constructor(builder: Builder) {
    /**
     * A list of the slots in the intent that should have runtime hints added, and the phrases that should be added for each slot.
     *
     * The first level of the `slotHints` map is the name of the intent. The second level is the name of the slot within the intent. For more information, see [Using hints to improve accuracy](https://docs.aws.amazon.com/lexv2/latest/dg/using-hints.xml).
     *
     * The intent name and slot name must exist.
     */
    public val slotHints: Map<String, Map<String, RuntimeHintDetails>>? = builder.slotHints

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimev2.model.RuntimeHints = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuntimeHints(")
        append("slotHints=$slotHints)")
    }

    override fun hashCode(): kotlin.Int {
        var result = slotHints?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuntimeHints

        if (slotHints != other.slotHints) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimev2.model.RuntimeHints = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of the slots in the intent that should have runtime hints added, and the phrases that should be added for each slot.
         *
         * The first level of the `slotHints` map is the name of the intent. The second level is the name of the slot within the intent. For more information, see [Using hints to improve accuracy](https://docs.aws.amazon.com/lexv2/latest/dg/using-hints.xml).
         *
         * The intent name and slot name must exist.
         */
        public var slotHints: Map<String, Map<String, RuntimeHintDetails>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimev2.model.RuntimeHints) : this() {
            this.slotHints = x.slotHints
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimev2.model.RuntimeHints = RuntimeHints(this)
    }
}
