// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimev2.model



/**
 * Provides information about the sentiment expressed in a user's response in a conversation. Sentiments are determined using Amazon Comprehend. Sentiments are only returned if they are enabled for the bot.
 *
 * For more information, see [ Determine Sentiment ](https://docs.aws.amazon.com/comprehend/latest/dg/how-sentiment.html) in the *Amazon Comprehend developer guide*.
 */
public class SentimentResponse private constructor(builder: Builder) {
    /**
     * The overall sentiment expressed in the user's response. This is the sentiment most likely expressed by the user based on the analysis by Amazon Comprehend.
     */
    public val sentiment: aws.sdk.kotlin.services.lexruntimev2.model.SentimentType? = builder.sentiment
    /**
     * The individual sentiment responses for the utterance.
     */
    public val sentimentScore: aws.sdk.kotlin.services.lexruntimev2.model.SentimentScore? = builder.sentimentScore

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimev2.model.SentimentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SentimentResponse(")
        append("sentiment=$sentiment,")
        append("sentimentScore=$sentimentScore)")
    }

    override fun hashCode(): kotlin.Int {
        var result = sentiment?.hashCode() ?: 0
        result = 31 * result + (sentimentScore?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SentimentResponse

        if (sentiment != other.sentiment) return false
        if (sentimentScore != other.sentimentScore) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimev2.model.SentimentResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The overall sentiment expressed in the user's response. This is the sentiment most likely expressed by the user based on the analysis by Amazon Comprehend.
         */
        public var sentiment: aws.sdk.kotlin.services.lexruntimev2.model.SentimentType? = null
        /**
         * The individual sentiment responses for the utterance.
         */
        public var sentimentScore: aws.sdk.kotlin.services.lexruntimev2.model.SentimentScore? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimev2.model.SentimentResponse) : this() {
            this.sentiment = x.sentiment
            this.sentimentScore = x.sentimentScore
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimev2.model.SentimentResponse = SentimentResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimev2.model.SentimentScore] inside the given [block]
         */
        public fun sentimentScore(block: aws.sdk.kotlin.services.lexruntimev2.model.SentimentScore.Builder.() -> kotlin.Unit) {
            this.sentimentScore = aws.sdk.kotlin.services.lexruntimev2.model.SentimentScore.invoke(block)
        }
    }
}
