// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimev2.model



/**
 * The state of the user's session with Amazon Lex V2.
 */
public class SessionState private constructor(builder: Builder) {
    /**
     * One or more contexts that indicate to Amazon Lex V2 the context of a request. When a context is active, Amazon Lex V2 considers intents with the matching context as a trigger as the next intent in a session.
     */
    public val activeContexts: List<ActiveContext>? = builder.activeContexts
    /**
     * The next step that Amazon Lex V2 should take in the conversation with a user.
     */
    public val dialogAction: aws.sdk.kotlin.services.lexruntimev2.model.DialogAction? = builder.dialogAction
    /**
     * The active intent that Amazon Lex V2 is processing.
     */
    public val intent: aws.sdk.kotlin.services.lexruntimev2.model.Intent? = builder.intent
    /**
     * A unique identifier for a specific request.
     */
    public val originatingRequestId: kotlin.String? = builder.originatingRequestId
    /**
     * Hints for phrases that a customer is likely to use for a slot. Amazon Lex V2 uses the hints to help determine the correct value of a slot.
     */
    public val runtimeHints: aws.sdk.kotlin.services.lexruntimev2.model.RuntimeHints? = builder.runtimeHints
    /**
     * Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex V2 and a client application.
     */
    public val sessionAttributes: Map<String, String>? = builder.sessionAttributes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimev2.model.SessionState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SessionState(")
        append("activeContexts=$activeContexts,")
        append("dialogAction=$dialogAction,")
        append("intent=$intent,")
        append("originatingRequestId=$originatingRequestId,")
        append("runtimeHints=$runtimeHints,")
        append("sessionAttributes=$sessionAttributes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeContexts?.hashCode() ?: 0
        result = 31 * result + (dialogAction?.hashCode() ?: 0)
        result = 31 * result + (intent?.hashCode() ?: 0)
        result = 31 * result + (originatingRequestId?.hashCode() ?: 0)
        result = 31 * result + (runtimeHints?.hashCode() ?: 0)
        result = 31 * result + (sessionAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SessionState

        if (activeContexts != other.activeContexts) return false
        if (dialogAction != other.dialogAction) return false
        if (intent != other.intent) return false
        if (originatingRequestId != other.originatingRequestId) return false
        if (runtimeHints != other.runtimeHints) return false
        if (sessionAttributes != other.sessionAttributes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimev2.model.SessionState = Builder(this).apply(block).build()

    public class Builder {
        /**
         * One or more contexts that indicate to Amazon Lex V2 the context of a request. When a context is active, Amazon Lex V2 considers intents with the matching context as a trigger as the next intent in a session.
         */
        public var activeContexts: List<ActiveContext>? = null
        /**
         * The next step that Amazon Lex V2 should take in the conversation with a user.
         */
        public var dialogAction: aws.sdk.kotlin.services.lexruntimev2.model.DialogAction? = null
        /**
         * The active intent that Amazon Lex V2 is processing.
         */
        public var intent: aws.sdk.kotlin.services.lexruntimev2.model.Intent? = null
        /**
         * A unique identifier for a specific request.
         */
        public var originatingRequestId: kotlin.String? = null
        /**
         * Hints for phrases that a customer is likely to use for a slot. Amazon Lex V2 uses the hints to help determine the correct value of a slot.
         */
        public var runtimeHints: aws.sdk.kotlin.services.lexruntimev2.model.RuntimeHints? = null
        /**
         * Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex V2 and a client application.
         */
        public var sessionAttributes: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimev2.model.SessionState) : this() {
            this.activeContexts = x.activeContexts
            this.dialogAction = x.dialogAction
            this.intent = x.intent
            this.originatingRequestId = x.originatingRequestId
            this.runtimeHints = x.runtimeHints
            this.sessionAttributes = x.sessionAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimev2.model.SessionState = SessionState(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimev2.model.DialogAction] inside the given [block]
         */
        public fun dialogAction(block: aws.sdk.kotlin.services.lexruntimev2.model.DialogAction.Builder.() -> kotlin.Unit) {
            this.dialogAction = aws.sdk.kotlin.services.lexruntimev2.model.DialogAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimev2.model.Intent] inside the given [block]
         */
        public fun intent(block: aws.sdk.kotlin.services.lexruntimev2.model.Intent.Builder.() -> kotlin.Unit) {
            this.intent = aws.sdk.kotlin.services.lexruntimev2.model.Intent.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimev2.model.RuntimeHints] inside the given [block]
         */
        public fun runtimeHints(block: aws.sdk.kotlin.services.lexruntimev2.model.RuntimeHints.Builder.() -> kotlin.Unit) {
            this.runtimeHints = aws.sdk.kotlin.services.lexruntimev2.model.RuntimeHints.invoke(block)
        }
    }
}
