// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimev2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lexruntimev2.model.DeleteSessionResponse
import aws.sdk.kotlin.services.lexruntimev2.model.LexRuntimeV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteSessionOperationDeserializer: HttpDeserialize<DeleteSessionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteSessionResponse {
        if (!response.status.isSuccess()) {
            throwDeleteSessionError(context, response)
        }
        val builder = DeleteSessionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteSessionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteSessionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LexRuntimeV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LexRuntimeV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteSessionOperationBody(builder: DeleteSessionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTALIASID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botAliasId"))
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val LOCALEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeId"))
    val SESSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sessionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTALIASID_DESCRIPTOR)
        field(BOTID_DESCRIPTOR)
        field(LOCALEID_DESCRIPTOR)
        field(SESSIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTALIASID_DESCRIPTOR.index -> builder.botAliasId = deserializeString()
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                LOCALEID_DESCRIPTOR.index -> builder.localeId = deserializeString()
                SESSIONID_DESCRIPTOR.index -> builder.sessionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
