// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimev2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lexruntimev2.model.GetSessionResponse
import aws.sdk.kotlin.services.lexruntimev2.model.Interpretation
import aws.sdk.kotlin.services.lexruntimev2.model.LexRuntimeV2Exception
import aws.sdk.kotlin.services.lexruntimev2.model.Message
import aws.sdk.kotlin.services.lexruntimev2.model.SessionState
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetSessionOperationDeserializer: HttpDeserialize<GetSessionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetSessionResponse {
        if (!response.status.isSuccess()) {
            throwGetSessionError(context, response)
        }
        val builder = GetSessionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSessionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetSessionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LexRuntimeV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LexRuntimeV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSessionOperationBody(builder: GetSessionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INTERPRETATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("interpretations"))
    val MESSAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("messages"))
    val SESSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sessionId"))
    val SESSIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sessionState"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INTERPRETATIONS_DESCRIPTOR)
        field(MESSAGES_DESCRIPTOR)
        field(SESSIONID_DESCRIPTOR)
        field(SESSIONSTATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INTERPRETATIONS_DESCRIPTOR.index -> builder.interpretations =
                    deserializer.deserializeList(INTERPRETATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Interpretation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInterpretationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MESSAGES_DESCRIPTOR.index -> builder.messages =
                    deserializer.deserializeList(MESSAGES_DESCRIPTOR) {
                        val col0 = mutableListOf<Message>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMessageDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SESSIONID_DESCRIPTOR.index -> builder.sessionId = deserializeString()
                SESSIONSTATE_DESCRIPTOR.index -> builder.sessionState = deserializeSessionStateDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
