// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimev2.transform

import aws.sdk.kotlin.services.lexruntimev2.model.Message
import aws.sdk.kotlin.services.lexruntimev2.model.PutSessionRequest
import aws.sdk.kotlin.services.lexruntimev2.model.SessionState
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutSessionOperationSerializer: HttpSerialize<PutSessionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutSessionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "bots",
                "${input.botId}".encodeLabel(),
                "botAliases",
                "${input.botAliasId}".encodeLabel(),
                "botLocales",
                "${input.localeId}".encodeLabel(),
                "sessions",
                "${input.sessionId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        builder.headers {
            if (input.responseContentType?.isNotEmpty() == true) append("ResponseContentType", input.responseContentType)
        }

        val payload = serializePutSessionOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializePutSessionOperationBody(context: ExecutionContext, input: PutSessionRequest): ByteArray {
    val serializer = JsonSerializer()
    val MESSAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("messages"))
    val REQUESTATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestAttributes"))
    val SESSIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sessionState"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MESSAGES_DESCRIPTOR)
        field(REQUESTATTRIBUTES_DESCRIPTOR)
        field(SESSIONSTATE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.messages != null) {
            listField(MESSAGES_DESCRIPTOR) {
                for (el0 in input.messages) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMessageDocument))
                }
            }
        }
        if (input.requestAttributes != null) {
            mapField(REQUESTATTRIBUTES_DESCRIPTOR) {
                input.requestAttributes.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.sessionState?.let { field(SESSIONSTATE_DESCRIPTOR, it, ::serializeSessionStateDocument) }
    }
    return serializer.toByteArray()
}
