// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimev2.transform

import aws.sdk.kotlin.services.lexruntimev2.model.RecognizeUtteranceRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.toHttpBody
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class RecognizeUtteranceOperationSerializer: HttpSerialize<RecognizeUtteranceRequest> {
    override suspend fun serialize(context: ExecutionContext, input: RecognizeUtteranceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "bots",
                "${input.botId}".encodeLabel(),
                "botAliases",
                "${input.botAliasId}".encodeLabel(),
                "botLocales",
                "${input.localeId}".encodeLabel(),
                "sessions",
                "${input.sessionId}".encodeLabel(),
                "utterance",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        builder.headers {
            if (input.requestAttributes?.isNotEmpty() == true) append("x-amz-lex-request-attributes", input.requestAttributes)
            if (input.requestContentType?.isNotEmpty() == true) append("Content-Type", input.requestContentType)
            if (input.responseContentType?.isNotEmpty() == true) append("Response-Content-Type", input.responseContentType)
            if (input.sessionState?.isNotEmpty() == true) append("x-amz-lex-session-state", input.sessionState)
        }

        if (input.inputStream != null) {
            builder.body = input.inputStream.toHttpBody() ?: HttpBody.Empty
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.inputStream == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
