// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.lightsail.endpoints.internal.ResolveEndpointMiddleware
import aws.sdk.kotlin.services.lightsail.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.lightsail.model.*
import aws.sdk.kotlin.services.lightsail.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Lightsail"
public const val ServiceApiVersion: String = "2016-11-28"
public const val SdkVersion: String = "0.19.0-beta"

internal class DefaultLightsailClient(override val config: LightsailClient.Config) : LightsailClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Allocates a static IP address.
     */
    override suspend fun allocateStaticIp(input: AllocateStaticIpRequest): AllocateStaticIpResponse {
        val op = SdkHttpOperation.build<AllocateStaticIpRequest, AllocateStaticIpResponse> {
            serializer = AllocateStaticIpOperationSerializer()
            deserializer = AllocateStaticIpOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AllocateStaticIp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("AllocateStaticIp-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Attaches an SSL/TLS certificate to your Amazon Lightsail content delivery network (CDN) distribution.
     *
     * After the certificate is attached, your distribution accepts HTTPS traffic for all of the domains that are associated with the certificate.
     *
     * Use the `CreateCertificate` action to create a certificate that you can attach to your distribution.
     *
     * Only certificates created in the `us-east-1` Amazon Web Services Region can be attached to Lightsail distributions. Lightsail distributions are global resources that can reference an origin in any Amazon Web Services Region, and distribute its content globally. However, all distributions are located in the `us-east-1` Region.
     */
    override suspend fun attachCertificateToDistribution(input: AttachCertificateToDistributionRequest): AttachCertificateToDistributionResponse {
        val op = SdkHttpOperation.build<AttachCertificateToDistributionRequest, AttachCertificateToDistributionResponse> {
            serializer = AttachCertificateToDistributionOperationSerializer()
            deserializer = AttachCertificateToDistributionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachCertificateToDistribution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("AttachCertificateToDistribution-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Attaches a block storage disk to a running or stopped Lightsail instance and exposes it to the instance with the specified disk name.
     *
     * The `attach disk` operation supports tag-based access control via resource tags applied to the resource identified by `disk name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun attachDisk(input: AttachDiskRequest): AttachDiskResponse {
        val op = SdkHttpOperation.build<AttachDiskRequest, AttachDiskResponse> {
            serializer = AttachDiskOperationSerializer()
            deserializer = AttachDiskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachDisk"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("AttachDisk-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Attaches one or more Lightsail instances to a load balancer.
     *
     * After some time, the instances are attached to the load balancer and the health check status is available.
     *
     * The `attach instances to load balancer` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun attachInstancesToLoadBalancer(input: AttachInstancesToLoadBalancerRequest): AttachInstancesToLoadBalancerResponse {
        val op = SdkHttpOperation.build<AttachInstancesToLoadBalancerRequest, AttachInstancesToLoadBalancerResponse> {
            serializer = AttachInstancesToLoadBalancerOperationSerializer()
            deserializer = AttachInstancesToLoadBalancerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachInstancesToLoadBalancer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("AttachInstancesToLoadBalancer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Attaches a Transport Layer Security (TLS) certificate to your load balancer. TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     *
     * Once you create and validate your certificate, you can attach it to your load balancer. You can also use this API to rotate the certificates on your account. Use the `AttachLoadBalancerTlsCertificate` action with the non-attached certificate, and it will replace the existing one and become the attached certificate.
     *
     * The `AttachLoadBalancerTlsCertificate` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun attachLoadBalancerTlsCertificate(input: AttachLoadBalancerTlsCertificateRequest): AttachLoadBalancerTlsCertificateResponse {
        val op = SdkHttpOperation.build<AttachLoadBalancerTlsCertificateRequest, AttachLoadBalancerTlsCertificateResponse> {
            serializer = AttachLoadBalancerTlsCertificateOperationSerializer()
            deserializer = AttachLoadBalancerTlsCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachLoadBalancerTlsCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("AttachLoadBalancerTlsCertificate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Attaches a static IP address to a specific Amazon Lightsail instance.
     */
    override suspend fun attachStaticIp(input: AttachStaticIpRequest): AttachStaticIpResponse {
        val op = SdkHttpOperation.build<AttachStaticIpRequest, AttachStaticIpResponse> {
            serializer = AttachStaticIpOperationSerializer()
            deserializer = AttachStaticIpOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachStaticIp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("AttachStaticIp-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Closes ports for a specific Amazon Lightsail instance.
     *
     * The `CloseInstancePublicPorts` action supports tag-based access control via resource tags applied to the resource identified by `instanceName`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun closeInstancePublicPorts(input: CloseInstancePublicPortsRequest): CloseInstancePublicPortsResponse {
        val op = SdkHttpOperation.build<CloseInstancePublicPortsRequest, CloseInstancePublicPortsResponse> {
            serializer = CloseInstancePublicPortsOperationSerializer()
            deserializer = CloseInstancePublicPortsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CloseInstancePublicPorts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CloseInstancePublicPorts-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Copies a manual snapshot of an instance or disk as another manual snapshot, or copies an automatic snapshot of an instance or disk as a manual snapshot. This operation can also be used to copy a manual or automatic snapshot of an instance or a disk from one Amazon Web Services Region to another in Amazon Lightsail.
     *
     * When copying a *manual snapshot*, be sure to define the `source region`, `source snapshot name`, and `target snapshot name` parameters.
     *
     * When copying an *automatic snapshot*, be sure to define the `source region`, `source resource name`, `target snapshot name`, and either the `restore date` or the `use latest restorable auto snapshot` parameters.
     */
    override suspend fun copySnapshot(input: CopySnapshotRequest): CopySnapshotResponse {
        val op = SdkHttpOperation.build<CopySnapshotRequest, CopySnapshotResponse> {
            serializer = CopySnapshotOperationSerializer()
            deserializer = CopySnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CopySnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CopySnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an Amazon Lightsail bucket.
     *
     * A bucket is a cloud storage resource available in the Lightsail object storage service. Use buckets to store objects such as data and its descriptive metadata. For more information about buckets, see [Buckets in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/buckets-in-amazon-lightsail) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun createBucket(input: CreateBucketRequest): CreateBucketResponse {
        val op = SdkHttpOperation.build<CreateBucketRequest, CreateBucketResponse> {
            serializer = CreateBucketOperationSerializer()
            deserializer = CreateBucketOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBucket"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateBucket-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new access key for the specified Amazon Lightsail bucket. Access keys consist of an access key ID and corresponding secret access key.
     *
     * Access keys grant full programmatic access to the specified bucket and its objects. You can have a maximum of two access keys per bucket. Use the [GetBucketAccessKeys](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBucketAccessKeys.html) action to get a list of current access keys for a specific bucket. For more information about access keys, see [Creating access keys for a bucket in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys) in the *Amazon Lightsail Developer Guide*.
     *
     * The `secretAccessKey` value is returned only in response to the `CreateBucketAccessKey` action. You can get a secret access key only when you first create an access key; you cannot get the secret access key later. If you lose the secret access key, you must create a new access key.
     */
    override suspend fun createBucketAccessKey(input: CreateBucketAccessKeyRequest): CreateBucketAccessKeyResponse {
        val op = SdkHttpOperation.build<CreateBucketAccessKeyRequest, CreateBucketAccessKeyResponse> {
            serializer = CreateBucketAccessKeyOperationSerializer()
            deserializer = CreateBucketAccessKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBucketAccessKey"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateBucketAccessKey-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an SSL/TLS certificate for an Amazon Lightsail content delivery network (CDN) distribution and a container service.
     *
     * After the certificate is valid, use the `AttachCertificateToDistribution` action to use the certificate and its domains with your distribution. Or use the `UpdateContainerService` action to use the certificate and its domains with your container service.
     *
     * Only certificates created in the `us-east-1` Amazon Web Services Region can be attached to Lightsail distributions. Lightsail distributions are global resources that can reference an origin in any Amazon Web Services Region, and distribute its content globally. However, all distributions are located in the `us-east-1` Region.
     */
    override suspend fun createCertificate(input: CreateCertificateRequest): CreateCertificateResponse {
        val op = SdkHttpOperation.build<CreateCertificateRequest, CreateCertificateResponse> {
            serializer = CreateCertificateOperationSerializer()
            deserializer = CreateCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateCertificate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an AWS CloudFormation stack, which creates a new Amazon EC2 instance from an exported Amazon Lightsail snapshot. This operation results in a CloudFormation stack record that can be used to track the AWS CloudFormation stack created. Use the `get cloud formation stack records` operation to get a list of the CloudFormation stacks created.
     *
     * Wait until after your new Amazon EC2 instance is created before running the `create cloud formation stack` operation again with the same export snapshot record.
     */
    override suspend fun createCloudFormationStack(input: CreateCloudFormationStackRequest): CreateCloudFormationStackResponse {
        val op = SdkHttpOperation.build<CreateCloudFormationStackRequest, CreateCloudFormationStackResponse> {
            serializer = CreateCloudFormationStackOperationSerializer()
            deserializer = CreateCloudFormationStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCloudFormationStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateCloudFormationStack-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an email or SMS text message contact method.
     *
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
     */
    override suspend fun createContactMethod(input: CreateContactMethodRequest): CreateContactMethodResponse {
        val op = SdkHttpOperation.build<CreateContactMethodRequest, CreateContactMethodResponse> {
            serializer = CreateContactMethodOperationSerializer()
            deserializer = CreateContactMethodOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateContactMethod"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateContactMethod-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an Amazon Lightsail container service.
     *
     * A Lightsail container service is a compute resource to which you can deploy containers. For more information, see [Container services in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-services) in the *Lightsail Dev Guide*.
     */
    override suspend fun createContainerService(input: CreateContainerServiceRequest): CreateContainerServiceResponse {
        val op = SdkHttpOperation.build<CreateContainerServiceRequest, CreateContainerServiceResponse> {
            serializer = CreateContainerServiceOperationSerializer()
            deserializer = CreateContainerServiceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateContainerService"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateContainerService-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a deployment for your Amazon Lightsail container service.
     *
     * A deployment specifies the containers that will be launched on the container service and their settings, such as the ports to open, the environment variables to apply, and the launch command to run. It also specifies the container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or HTTPS port to use, and the health check configuration.
     *
     * You can deploy containers to your container service using container images from a public registry such as Amazon ECR Public, or from your local machine. For more information, see [Creating container images for your Amazon Lightsail container services](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-container-images) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun createContainerServiceDeployment(input: CreateContainerServiceDeploymentRequest): CreateContainerServiceDeploymentResponse {
        val op = SdkHttpOperation.build<CreateContainerServiceDeploymentRequest, CreateContainerServiceDeploymentResponse> {
            serializer = CreateContainerServiceDeploymentOperationSerializer()
            deserializer = CreateContainerServiceDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateContainerServiceDeployment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateContainerServiceDeployment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a temporary set of log in credentials that you can use to log in to the Docker process on your local machine. After you're logged in, you can use the native Docker commands to push your local container images to the container image registry of your Amazon Lightsail account so that you can use them with your Lightsail container service. The log in credentials expire 12 hours after they are created, at which point you will need to create a new set of log in credentials.
     *
     * You can only push container images to the container service registry of your Lightsail account. You cannot pull container images or perform any other container image management actions on the container service registry.
     *
     * After you push your container images to the container image registry of your Lightsail account, use the `RegisterContainerImage` action to register the pushed images to a specific Lightsail container service.
     *
     * This action is not required if you install and use the Lightsail Control (lightsailctl) plugin to push container images to your Lightsail container service. For more information, see [Pushing and managing container images on your Amazon Lightsail container services](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun createContainerServiceRegistryLogin(input: CreateContainerServiceRegistryLoginRequest): CreateContainerServiceRegistryLoginResponse {
        val op = SdkHttpOperation.build<CreateContainerServiceRegistryLoginRequest, CreateContainerServiceRegistryLoginResponse> {
            serializer = CreateContainerServiceRegistryLoginOperationSerializer()
            deserializer = CreateContainerServiceRegistryLoginOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateContainerServiceRegistryLogin"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateContainerServiceRegistryLogin-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a block storage disk that can be attached to an Amazon Lightsail instance in the same Availability Zone (e.g., `us-east-2a`).
     *
     * The `create disk` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createDisk(input: CreateDiskRequest): CreateDiskResponse {
        val op = SdkHttpOperation.build<CreateDiskRequest, CreateDiskResponse> {
            serializer = CreateDiskOperationSerializer()
            deserializer = CreateDiskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDisk"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateDisk-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a block storage disk from a manual or automatic snapshot of a disk. The resulting disk can be attached to an Amazon Lightsail instance in the same Availability Zone (e.g., `us-east-2a`).
     *
     * The `create disk from snapshot` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `disk snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createDiskFromSnapshot(input: CreateDiskFromSnapshotRequest): CreateDiskFromSnapshotResponse {
        val op = SdkHttpOperation.build<CreateDiskFromSnapshotRequest, CreateDiskFromSnapshotResponse> {
            serializer = CreateDiskFromSnapshotOperationSerializer()
            deserializer = CreateDiskFromSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDiskFromSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateDiskFromSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a snapshot of a block storage disk. You can use snapshots for backups, to make copies of disks, and to save data before shutting down a Lightsail instance.
     *
     * You can take a snapshot of an attached disk that is in use; however, snapshots only capture data that has been written to your disk at the time the snapshot command is issued. This may exclude any data that has been cached by any applications or the operating system. If you can pause any file systems on the disk long enough to take a snapshot, your snapshot should be complete. Nevertheless, if you cannot pause all file writes to the disk, you should unmount the disk from within the Lightsail instance, issue the create disk snapshot command, and then remount the disk to ensure a consistent and complete snapshot. You may remount and use your disk while the snapshot status is pending.
     *
     * You can also use this operation to create a snapshot of an instance's system volume. You might want to do this, for example, to recover data from the system volume of a botched instance or to create a backup of the system volume like you would for a block storage disk. To create a snapshot of a system volume, just define the `instance name` parameter when issuing the snapshot command, and a snapshot of the defined instance's system volume will be created. After the snapshot is available, you can create a block storage disk from the snapshot and attach it to a running instance to access the data on the disk.
     *
     * The `create disk snapshot` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createDiskSnapshot(input: CreateDiskSnapshotRequest): CreateDiskSnapshotResponse {
        val op = SdkHttpOperation.build<CreateDiskSnapshotRequest, CreateDiskSnapshotResponse> {
            serializer = CreateDiskSnapshotOperationSerializer()
            deserializer = CreateDiskSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDiskSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateDiskSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an Amazon Lightsail content delivery network (CDN) distribution.
     *
     * A distribution is a globally distributed network of caching servers that improve the performance of your website or web application hosted on a Lightsail instance. For more information, see [Content delivery networks in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-content-delivery-network-distributions).
     */
    override suspend fun createDistribution(input: CreateDistributionRequest): CreateDistributionResponse {
        val op = SdkHttpOperation.build<CreateDistributionRequest, CreateDistributionResponse> {
            serializer = CreateDistributionOperationSerializer()
            deserializer = CreateDistributionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDistribution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateDistribution-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a domain resource for the specified domain (e.g., example.com).
     *
     * The `create domain` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse {
        val op = SdkHttpOperation.build<CreateDomainRequest, CreateDomainResponse> {
            serializer = CreateDomainOperationSerializer()
            deserializer = CreateDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateDomain-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates one of the following domain name system (DNS) records in a domain DNS zone: Address (A), canonical name (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text (TXT).
     *
     * The `create domain entry` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createDomainEntry(input: CreateDomainEntryRequest): CreateDomainEntryResponse {
        val op = SdkHttpOperation.build<CreateDomainEntryRequest, CreateDomainEntryResponse> {
            serializer = CreateDomainEntryOperationSerializer()
            deserializer = CreateDomainEntryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDomainEntry"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateDomainEntry-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a snapshot of a specific virtual private server, or *instance*. You can use a snapshot to create a new instance that is based on that snapshot.
     *
     * The `create instance snapshot` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createInstanceSnapshot(input: CreateInstanceSnapshotRequest): CreateInstanceSnapshotResponse {
        val op = SdkHttpOperation.build<CreateInstanceSnapshotRequest, CreateInstanceSnapshotResponse> {
            serializer = CreateInstanceSnapshotOperationSerializer()
            deserializer = CreateInstanceSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateInstanceSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateInstanceSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates one or more Amazon Lightsail instances.
     *
     * The `create instances` operation supports tag-based access control via request tags. For more information, see the [Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createInstances(input: CreateInstancesRequest): CreateInstancesResponse {
        val op = SdkHttpOperation.build<CreateInstancesRequest, CreateInstancesResponse> {
            serializer = CreateInstancesOperationSerializer()
            deserializer = CreateInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateInstances-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates one or more new instances from a manual or automatic snapshot of an instance.
     *
     * The `create instances from snapshot` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `instance snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createInstancesFromSnapshot(input: CreateInstancesFromSnapshotRequest): CreateInstancesFromSnapshotResponse {
        val op = SdkHttpOperation.build<CreateInstancesFromSnapshotRequest, CreateInstancesFromSnapshotResponse> {
            serializer = CreateInstancesFromSnapshotOperationSerializer()
            deserializer = CreateInstancesFromSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateInstancesFromSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateInstancesFromSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a custom SSH key pair that you can use with an Amazon Lightsail instance.
     *
     * Use the [DownloadDefaultKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DownloadDefaultKeyPair.html) action to create a Lightsail default key pair in an Amazon Web Services Region where a default key pair does not currently exist.
     *
     * The `create key pair` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createKeyPair(input: CreateKeyPairRequest): CreateKeyPairResponse {
        val op = SdkHttpOperation.build<CreateKeyPairRequest, CreateKeyPairResponse> {
            serializer = CreateKeyPairOperationSerializer()
            deserializer = CreateKeyPairOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateKeyPair"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateKeyPair-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a Lightsail load balancer. To learn more about deciding whether to load balance your application, see [Configure your Lightsail instances for load balancing](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/configure-lightsail-instances-for-load-balancing). You can create up to 5 load balancers per AWS Region in your account.
     *
     * When you create a load balancer, you can specify a unique name and port settings. To change additional load balancer settings, use the `UpdateLoadBalancerAttribute` operation.
     *
     * The `create load balancer` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createLoadBalancer(input: CreateLoadBalancerRequest): CreateLoadBalancerResponse {
        val op = SdkHttpOperation.build<CreateLoadBalancerRequest, CreateLoadBalancerResponse> {
            serializer = CreateLoadBalancerOperationSerializer()
            deserializer = CreateLoadBalancerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLoadBalancer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateLoadBalancer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an SSL/TLS certificate for an Amazon Lightsail load balancer.
     *
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     *
     * The `CreateLoadBalancerTlsCertificate` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createLoadBalancerTlsCertificate(input: CreateLoadBalancerTlsCertificateRequest): CreateLoadBalancerTlsCertificateResponse {
        val op = SdkHttpOperation.build<CreateLoadBalancerTlsCertificateRequest, CreateLoadBalancerTlsCertificateResponse> {
            serializer = CreateLoadBalancerTlsCertificateOperationSerializer()
            deserializer = CreateLoadBalancerTlsCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLoadBalancerTlsCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateLoadBalancerTlsCertificate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new database in Amazon Lightsail.
     *
     * The `create relational database` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createRelationalDatabase(input: CreateRelationalDatabaseRequest): CreateRelationalDatabaseResponse {
        val op = SdkHttpOperation.build<CreateRelationalDatabaseRequest, CreateRelationalDatabaseResponse> {
            serializer = CreateRelationalDatabaseOperationSerializer()
            deserializer = CreateRelationalDatabaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRelationalDatabase"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateRelationalDatabase-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new database from an existing database snapshot in Amazon Lightsail.
     *
     * You can create a new database from a snapshot in if something goes wrong with your original database, or to change it to a different plan, such as a high availability or standard plan.
     *
     * The `create relational database from snapshot` operation supports tag-based access control via request tags and resource tags applied to the resource identified by relationalDatabaseSnapshotName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createRelationalDatabaseFromSnapshot(input: CreateRelationalDatabaseFromSnapshotRequest): CreateRelationalDatabaseFromSnapshotResponse {
        val op = SdkHttpOperation.build<CreateRelationalDatabaseFromSnapshotRequest, CreateRelationalDatabaseFromSnapshotResponse> {
            serializer = CreateRelationalDatabaseFromSnapshotOperationSerializer()
            deserializer = CreateRelationalDatabaseFromSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRelationalDatabaseFromSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateRelationalDatabaseFromSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a snapshot of your database in Amazon Lightsail. You can use snapshots for backups, to make copies of a database, and to save data before deleting a database.
     *
     * The `create relational database snapshot` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createRelationalDatabaseSnapshot(input: CreateRelationalDatabaseSnapshotRequest): CreateRelationalDatabaseSnapshotResponse {
        val op = SdkHttpOperation.build<CreateRelationalDatabaseSnapshotRequest, CreateRelationalDatabaseSnapshotResponse> {
            serializer = CreateRelationalDatabaseSnapshotOperationSerializer()
            deserializer = CreateRelationalDatabaseSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRelationalDatabaseSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateRelationalDatabaseSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an alarm.
     *
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
     */
    override suspend fun deleteAlarm(input: DeleteAlarmRequest): DeleteAlarmResponse {
        val op = SdkHttpOperation.build<DeleteAlarmRequest, DeleteAlarmResponse> {
            serializer = DeleteAlarmOperationSerializer()
            deserializer = DeleteAlarmOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAlarm"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteAlarm-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an automatic snapshot of an instance or disk. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    override suspend fun deleteAutoSnapshot(input: DeleteAutoSnapshotRequest): DeleteAutoSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteAutoSnapshotRequest, DeleteAutoSnapshotResponse> {
            serializer = DeleteAutoSnapshotOperationSerializer()
            deserializer = DeleteAutoSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAutoSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteAutoSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a Amazon Lightsail bucket.
     *
     * When you delete your bucket, the bucket name is released and can be reused for a new bucket in your account or another Amazon Web Services account.
     */
    override suspend fun deleteBucket(input: DeleteBucketRequest): DeleteBucketResponse {
        val op = SdkHttpOperation.build<DeleteBucketRequest, DeleteBucketResponse> {
            serializer = DeleteBucketOperationSerializer()
            deserializer = DeleteBucketOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBucket"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteBucket-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an access key for the specified Amazon Lightsail bucket.
     *
     * We recommend that you delete an access key if the secret access key is compromised.
     *
     * For more information about access keys, see [Creating access keys for a bucket in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun deleteBucketAccessKey(input: DeleteBucketAccessKeyRequest): DeleteBucketAccessKeyResponse {
        val op = SdkHttpOperation.build<DeleteBucketAccessKeyRequest, DeleteBucketAccessKeyResponse> {
            serializer = DeleteBucketAccessKeyOperationSerializer()
            deserializer = DeleteBucketAccessKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBucketAccessKey"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteBucketAccessKey-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an SSL/TLS certificate for your Amazon Lightsail content delivery network (CDN) distribution.
     *
     * Certificates that are currently attached to a distribution cannot be deleted. Use the `DetachCertificateFromDistribution` action to detach a certificate from a distribution.
     */
    override suspend fun deleteCertificate(input: DeleteCertificateRequest): DeleteCertificateResponse {
        val op = SdkHttpOperation.build<DeleteCertificateRequest, DeleteCertificateResponse> {
            serializer = DeleteCertificateOperationSerializer()
            deserializer = DeleteCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteCertificate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a contact method.
     *
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
     */
    override suspend fun deleteContactMethod(input: DeleteContactMethodRequest): DeleteContactMethodResponse {
        val op = SdkHttpOperation.build<DeleteContactMethodRequest, DeleteContactMethodResponse> {
            serializer = DeleteContactMethodOperationSerializer()
            deserializer = DeleteContactMethodOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteContactMethod"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteContactMethod-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a container image that is registered to your Amazon Lightsail container service.
     */
    override suspend fun deleteContainerImage(input: DeleteContainerImageRequest): DeleteContainerImageResponse {
        val op = SdkHttpOperation.build<DeleteContainerImageRequest, DeleteContainerImageResponse> {
            serializer = DeleteContainerImageOperationSerializer()
            deserializer = DeleteContainerImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteContainerImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteContainerImage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes your Amazon Lightsail container service.
     */
    override suspend fun deleteContainerService(input: DeleteContainerServiceRequest): DeleteContainerServiceResponse {
        val op = SdkHttpOperation.build<DeleteContainerServiceRequest, DeleteContainerServiceResponse> {
            serializer = DeleteContainerServiceOperationSerializer()
            deserializer = DeleteContainerServiceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteContainerService"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteContainerService-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified block storage disk. The disk must be in the `available` state (not attached to a Lightsail instance).
     *
     * The disk may remain in the `deleting` state for several minutes.
     *
     * The `delete disk` operation supports tag-based access control via resource tags applied to the resource identified by `disk name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteDisk(input: DeleteDiskRequest): DeleteDiskResponse {
        val op = SdkHttpOperation.build<DeleteDiskRequest, DeleteDiskResponse> {
            serializer = DeleteDiskOperationSerializer()
            deserializer = DeleteDiskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDisk"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteDisk-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified disk snapshot.
     *
     * When you make periodic snapshots of a disk, the snapshots are incremental, and only the blocks on the device that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all active snapshots will have access to all the information needed to restore the disk.
     *
     * The `delete disk snapshot` operation supports tag-based access control via resource tags applied to the resource identified by `disk snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteDiskSnapshot(input: DeleteDiskSnapshotRequest): DeleteDiskSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteDiskSnapshotRequest, DeleteDiskSnapshotResponse> {
            serializer = DeleteDiskSnapshotOperationSerializer()
            deserializer = DeleteDiskSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDiskSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteDiskSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes your Amazon Lightsail content delivery network (CDN) distribution.
     */
    override suspend fun deleteDistribution(input: DeleteDistributionRequest): DeleteDistributionResponse {
        val op = SdkHttpOperation.build<DeleteDistributionRequest, DeleteDistributionResponse> {
            serializer = DeleteDistributionOperationSerializer()
            deserializer = DeleteDistributionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDistribution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteDistribution-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified domain recordset and all of its domain records.
     *
     * The `delete domain` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse {
        val op = SdkHttpOperation.build<DeleteDomainRequest, DeleteDomainResponse> {
            serializer = DeleteDomainOperationSerializer()
            deserializer = DeleteDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteDomain-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a specific domain entry.
     *
     * The `delete domain entry` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteDomainEntry(input: DeleteDomainEntryRequest): DeleteDomainEntryResponse {
        val op = SdkHttpOperation.build<DeleteDomainEntryRequest, DeleteDomainEntryResponse> {
            serializer = DeleteDomainEntryOperationSerializer()
            deserializer = DeleteDomainEntryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDomainEntry"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteDomainEntry-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an Amazon Lightsail instance.
     *
     * The `delete instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteInstance(input: DeleteInstanceRequest): DeleteInstanceResponse {
        val op = SdkHttpOperation.build<DeleteInstanceRequest, DeleteInstanceResponse> {
            serializer = DeleteInstanceOperationSerializer()
            deserializer = DeleteInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteInstance-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a specific snapshot of a virtual private server (or *instance*).
     *
     * The `delete instance snapshot` operation supports tag-based access control via resource tags applied to the resource identified by `instance snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteInstanceSnapshot(input: DeleteInstanceSnapshotRequest): DeleteInstanceSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteInstanceSnapshotRequest, DeleteInstanceSnapshotResponse> {
            serializer = DeleteInstanceSnapshotOperationSerializer()
            deserializer = DeleteInstanceSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInstanceSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteInstanceSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified key pair by removing the public key from Amazon Lightsail.
     *
     * You can delete key pairs that were created using the [ImportKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_ImportKeyPair.html) and [CreateKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateKeyPair.html) actions, as well as the Lightsail default key pair. A new default key pair will not be created unless you launch an instance without specifying a custom key pair, or you call the [DownloadDefaultKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DownloadDefaultKeyPair.html) API.
     *
     * The `delete key pair` operation supports tag-based access control via resource tags applied to the resource identified by `key pair name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteKeyPair(input: DeleteKeyPairRequest): DeleteKeyPairResponse {
        val op = SdkHttpOperation.build<DeleteKeyPairRequest, DeleteKeyPairResponse> {
            serializer = DeleteKeyPairOperationSerializer()
            deserializer = DeleteKeyPairOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteKeyPair"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteKeyPair-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the known host key or certificate used by the Amazon Lightsail browser-based SSH or RDP clients to authenticate an instance. This operation enables the Lightsail browser-based SSH or RDP clients to connect to the instance after a host key mismatch.
     *
     * Perform this operation only if you were expecting the host key or certificate mismatch or if you are familiar with the new host key or certificate on the instance. For more information, see [Troubleshooting connection issues when using the Amazon Lightsail browser-based SSH or RDP client](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-troubleshooting-browser-based-ssh-rdp-client-connection).
     */
    override suspend fun deleteKnownHostKeys(input: DeleteKnownHostKeysRequest): DeleteKnownHostKeysResponse {
        val op = SdkHttpOperation.build<DeleteKnownHostKeysRequest, DeleteKnownHostKeysResponse> {
            serializer = DeleteKnownHostKeysOperationSerializer()
            deserializer = DeleteKnownHostKeysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteKnownHostKeys"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteKnownHostKeys-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a Lightsail load balancer and all its associated SSL/TLS certificates. Once the load balancer is deleted, you will need to create a new load balancer, create a new certificate, and verify domain ownership again.
     *
     * The `delete load balancer` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteLoadBalancer(input: DeleteLoadBalancerRequest): DeleteLoadBalancerResponse {
        val op = SdkHttpOperation.build<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse> {
            serializer = DeleteLoadBalancerOperationSerializer()
            deserializer = DeleteLoadBalancerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLoadBalancer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteLoadBalancer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an SSL/TLS certificate associated with a Lightsail load balancer.
     *
     * The `DeleteLoadBalancerTlsCertificate` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteLoadBalancerTlsCertificate(input: DeleteLoadBalancerTlsCertificateRequest): DeleteLoadBalancerTlsCertificateResponse {
        val op = SdkHttpOperation.build<DeleteLoadBalancerTlsCertificateRequest, DeleteLoadBalancerTlsCertificateResponse> {
            serializer = DeleteLoadBalancerTlsCertificateOperationSerializer()
            deserializer = DeleteLoadBalancerTlsCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLoadBalancerTlsCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteLoadBalancerTlsCertificate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a database in Amazon Lightsail.
     *
     * The `delete relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteRelationalDatabase(input: DeleteRelationalDatabaseRequest): DeleteRelationalDatabaseResponse {
        val op = SdkHttpOperation.build<DeleteRelationalDatabaseRequest, DeleteRelationalDatabaseResponse> {
            serializer = DeleteRelationalDatabaseOperationSerializer()
            deserializer = DeleteRelationalDatabaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRelationalDatabase"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteRelationalDatabase-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a database snapshot in Amazon Lightsail.
     *
     * The `delete relational database snapshot` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteRelationalDatabaseSnapshot(input: DeleteRelationalDatabaseSnapshotRequest): DeleteRelationalDatabaseSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteRelationalDatabaseSnapshotRequest, DeleteRelationalDatabaseSnapshotResponse> {
            serializer = DeleteRelationalDatabaseSnapshotOperationSerializer()
            deserializer = DeleteRelationalDatabaseSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRelationalDatabaseSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteRelationalDatabaseSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Detaches an SSL/TLS certificate from your Amazon Lightsail content delivery network (CDN) distribution.
     *
     * After the certificate is detached, your distribution stops accepting traffic for all of the domains that are associated with the certificate.
     */
    override suspend fun detachCertificateFromDistribution(input: DetachCertificateFromDistributionRequest): DetachCertificateFromDistributionResponse {
        val op = SdkHttpOperation.build<DetachCertificateFromDistributionRequest, DetachCertificateFromDistributionResponse> {
            serializer = DetachCertificateFromDistributionOperationSerializer()
            deserializer = DetachCertificateFromDistributionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachCertificateFromDistribution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DetachCertificateFromDistribution-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Detaches a stopped block storage disk from a Lightsail instance. Make sure to unmount any file systems on the device within your operating system before stopping the instance and detaching the disk.
     *
     * The `detach disk` operation supports tag-based access control via resource tags applied to the resource identified by `disk name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun detachDisk(input: DetachDiskRequest): DetachDiskResponse {
        val op = SdkHttpOperation.build<DetachDiskRequest, DetachDiskResponse> {
            serializer = DetachDiskOperationSerializer()
            deserializer = DetachDiskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachDisk"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DetachDisk-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Detaches the specified instances from a Lightsail load balancer.
     *
     * This operation waits until the instances are no longer needed before they are detached from the load balancer.
     *
     * The `detach instances from load balancer` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun detachInstancesFromLoadBalancer(input: DetachInstancesFromLoadBalancerRequest): DetachInstancesFromLoadBalancerResponse {
        val op = SdkHttpOperation.build<DetachInstancesFromLoadBalancerRequest, DetachInstancesFromLoadBalancerResponse> {
            serializer = DetachInstancesFromLoadBalancerOperationSerializer()
            deserializer = DetachInstancesFromLoadBalancerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachInstancesFromLoadBalancer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DetachInstancesFromLoadBalancer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Detaches a static IP from the Amazon Lightsail instance to which it is attached.
     */
    override suspend fun detachStaticIp(input: DetachStaticIpRequest): DetachStaticIpResponse {
        val op = SdkHttpOperation.build<DetachStaticIpRequest, DetachStaticIpResponse> {
            serializer = DetachStaticIpOperationSerializer()
            deserializer = DetachStaticIpOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachStaticIp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DetachStaticIp-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disables an add-on for an Amazon Lightsail resource. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    override suspend fun disableAddOn(input: DisableAddOnRequest): DisableAddOnResponse {
        val op = SdkHttpOperation.build<DisableAddOnRequest, DisableAddOnResponse> {
            serializer = DisableAddOnOperationSerializer()
            deserializer = DisableAddOnOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableAddOn"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DisableAddOn-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Downloads the regional Amazon Lightsail default key pair.
     *
     * This action also creates a Lightsail default key pair if a default key pair does not currently exist in the Amazon Web Services Region.
     */
    override suspend fun downloadDefaultKeyPair(input: DownloadDefaultKeyPairRequest): DownloadDefaultKeyPairResponse {
        val op = SdkHttpOperation.build<DownloadDefaultKeyPairRequest, DownloadDefaultKeyPairResponse> {
            serializer = DownloadDefaultKeyPairOperationSerializer()
            deserializer = DownloadDefaultKeyPairOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DownloadDefaultKeyPair"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DownloadDefaultKeyPair-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Enables or modifies an add-on for an Amazon Lightsail resource. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    override suspend fun enableAddOn(input: EnableAddOnRequest): EnableAddOnResponse {
        val op = SdkHttpOperation.build<EnableAddOnRequest, EnableAddOnResponse> {
            serializer = EnableAddOnOperationSerializer()
            deserializer = EnableAddOnOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableAddOn"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("EnableAddOn-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Exports an Amazon Lightsail instance or block storage disk snapshot to Amazon Elastic Compute Cloud (Amazon EC2). This operation results in an export snapshot record that can be used with the `create cloud formation stack` operation to create new Amazon EC2 instances.
     *
     * Exported instance snapshots appear in Amazon EC2 as Amazon Machine Images (AMIs), and the instance system disk appears as an Amazon Elastic Block Store (Amazon EBS) volume. Exported disk snapshots appear in Amazon EC2 as Amazon EBS volumes. Snapshots are exported to the same Amazon Web Services Region in Amazon EC2 as the source Lightsail snapshot.
     *
     * The `export snapshot` operation supports tag-based access control via resource tags applied to the resource identified by `source snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     *
     * Use the `get instance snapshots` or `get disk snapshots` operations to get a list of snapshots that you can export to Amazon EC2.
     */
    override suspend fun exportSnapshot(input: ExportSnapshotRequest): ExportSnapshotResponse {
        val op = SdkHttpOperation.build<ExportSnapshotRequest, ExportSnapshotResponse> {
            serializer = ExportSnapshotOperationSerializer()
            deserializer = ExportSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ExportSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the names of all active (not deleted) resources.
     */
    override suspend fun getActiveNames(input: GetActiveNamesRequest): GetActiveNamesResponse {
        val op = SdkHttpOperation.build<GetActiveNamesRequest, GetActiveNamesResponse> {
            serializer = GetActiveNamesOperationSerializer()
            deserializer = GetActiveNamesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetActiveNames"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetActiveNames-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about the configured alarms. Specify an alarm name in your request to return information about a specific alarm, or specify a monitored resource name to return information about all alarms for a specific resource.
     *
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
     */
    override suspend fun getAlarms(input: GetAlarmsRequest): GetAlarmsResponse {
        val op = SdkHttpOperation.build<GetAlarmsRequest, GetAlarmsResponse> {
            serializer = GetAlarmsOperationSerializer()
            deserializer = GetAlarmsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAlarms"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetAlarms-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the available automatic snapshots for an instance or disk. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    override suspend fun getAutoSnapshots(input: GetAutoSnapshotsRequest): GetAutoSnapshotsResponse {
        val op = SdkHttpOperation.build<GetAutoSnapshotsRequest, GetAutoSnapshotsResponse> {
            serializer = GetAutoSnapshotsOperationSerializer()
            deserializer = GetAutoSnapshotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAutoSnapshots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetAutoSnapshots-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the list of available instance images, or *blueprints*. You can use a blueprint to create a new instance already running a specific operating system, as well as a preinstalled app or development stack. The software each instance is running depends on the blueprint image you choose.
     *
     * Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when they become outdated due to operating system updates or new application releases.
     */
    override suspend fun getBlueprints(input: GetBlueprintsRequest): GetBlueprintsResponse {
        val op = SdkHttpOperation.build<GetBlueprintsRequest, GetBlueprintsResponse> {
            serializer = GetBlueprintsOperationSerializer()
            deserializer = GetBlueprintsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBlueprints"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetBlueprints-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the existing access key IDs for the specified Amazon Lightsail bucket.
     *
     * This action does not return the secret access key value of an access key. You can get a secret access key only when you create it from the response of the [CreateBucketAccessKey](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateBucketAccessKey.html) action. If you lose the secret access key, you must create a new access key.
     */
    override suspend fun getBucketAccessKeys(input: GetBucketAccessKeysRequest): GetBucketAccessKeysResponse {
        val op = SdkHttpOperation.build<GetBucketAccessKeysRequest, GetBucketAccessKeysResponse> {
            serializer = GetBucketAccessKeysOperationSerializer()
            deserializer = GetBucketAccessKeysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBucketAccessKeys"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetBucketAccessKeys-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the bundles that you can apply to a Amazon Lightsail bucket.
     *
     * The bucket bundle specifies the monthly cost, storage quota, and data transfer quota for a bucket.
     *
     * Use the [UpdateBucketBundle](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateBucketBundle.html) action to update the bundle for a bucket.
     */
    override suspend fun getBucketBundles(input: GetBucketBundlesRequest): GetBucketBundlesResponse {
        val op = SdkHttpOperation.build<GetBucketBundlesRequest, GetBucketBundlesResponse> {
            serializer = GetBucketBundlesOperationSerializer()
            deserializer = GetBucketBundlesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBucketBundles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetBucketBundles-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the data points of a specific metric for an Amazon Lightsail bucket.
     *
     * Metrics report the utilization of a bucket. View and collect metric data regularly to monitor the number of objects stored in a bucket (including object versions) and the storage space used by those objects.
     */
    override suspend fun getBucketMetricData(input: GetBucketMetricDataRequest): GetBucketMetricDataResponse {
        val op = SdkHttpOperation.build<GetBucketMetricDataRequest, GetBucketMetricDataResponse> {
            serializer = GetBucketMetricDataOperationSerializer()
            deserializer = GetBucketMetricDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBucketMetricData"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetBucketMetricData-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about one or more Amazon Lightsail buckets. The information returned includes the synchronization status of the Amazon Simple Storage Service (Amazon S3) account-level block public access feature for your Lightsail buckets.
     *
     * For more information about buckets, see [Buckets in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/buckets-in-amazon-lightsail) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun getBuckets(input: GetBucketsRequest): GetBucketsResponse {
        val op = SdkHttpOperation.build<GetBucketsRequest, GetBucketsResponse> {
            serializer = GetBucketsOperationSerializer()
            deserializer = GetBucketsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBuckets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetBuckets-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the bundles that you can apply to an Amazon Lightsail instance when you create it.
     *
     * A bundle describes the specifications of an instance, such as the monthly cost, amount of memory, the number of vCPUs, amount of storage space, and monthly network data transfer quota.
     *
     * Bundles are referred to as *instance plans* in the Lightsail console.
     */
    override suspend fun getBundles(input: GetBundlesRequest): GetBundlesResponse {
        val op = SdkHttpOperation.build<GetBundlesRequest, GetBundlesResponse> {
            serializer = GetBundlesOperationSerializer()
            deserializer = GetBundlesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBundles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetBundles-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about one or more Amazon Lightsail SSL/TLS certificates.
     *
     * To get a summary of a certificate, ommit `includeCertificateDetails` from your request. The response will include only the certificate Amazon Resource Name (ARN), certificate name, domain name, and tags.
     */
    override suspend fun getCertificates(input: GetCertificatesRequest): GetCertificatesResponse {
        val op = SdkHttpOperation.build<GetCertificatesRequest, GetCertificatesResponse> {
            serializer = GetCertificatesOperationSerializer()
            deserializer = GetCertificatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCertificates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetCertificates-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the CloudFormation stack record created as a result of the `create cloud formation stack` operation.
     *
     * An AWS CloudFormation stack is used to create a new Amazon EC2 instance from an exported Lightsail snapshot.
     */
    override suspend fun getCloudFormationStackRecords(input: GetCloudFormationStackRecordsRequest): GetCloudFormationStackRecordsResponse {
        val op = SdkHttpOperation.build<GetCloudFormationStackRecordsRequest, GetCloudFormationStackRecordsResponse> {
            serializer = GetCloudFormationStackRecordsOperationSerializer()
            deserializer = GetCloudFormationStackRecordsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCloudFormationStackRecords"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetCloudFormationStackRecords-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about the configured contact methods. Specify a protocol in your request to return information about a specific contact method.
     *
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
     */
    override suspend fun getContactMethods(input: GetContactMethodsRequest): GetContactMethodsResponse {
        val op = SdkHttpOperation.build<GetContactMethodsRequest, GetContactMethodsResponse> {
            serializer = GetContactMethodsOperationSerializer()
            deserializer = GetContactMethodsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContactMethods"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetContactMethods-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about Amazon Lightsail containers, such as the current version of the Lightsail Control (lightsailctl) plugin.
     */
    override suspend fun getContainerApiMetadata(input: GetContainerApiMetadataRequest): GetContainerApiMetadataResponse {
        val op = SdkHttpOperation.build<GetContainerApiMetadataRequest, GetContainerApiMetadataResponse> {
            serializer = GetContainerAPIMetadataOperationSerializer()
            deserializer = GetContainerAPIMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContainerAPIMetadata"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetContainerAPIMetadata-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the container images that are registered to your Amazon Lightsail container service.
     *
     * If you created a deployment on your Lightsail container service that uses container images from a public registry like Docker Hub, those images are not returned as part of this action. Those images are not registered to your Lightsail container service.
     */
    override suspend fun getContainerImages(input: GetContainerImagesRequest): GetContainerImagesResponse {
        val op = SdkHttpOperation.build<GetContainerImagesRequest, GetContainerImagesResponse> {
            serializer = GetContainerImagesOperationSerializer()
            deserializer = GetContainerImagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContainerImages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetContainerImages-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the log events of a container of your Amazon Lightsail container service.
     *
     * If your container service has more than one node (i.e., a scale greater than 1), then the log events that are returned for the specified container are merged from all nodes on your container service.
     *
     * Container logs are retained for a certain amount of time. For more information, see [Amazon Lightsail endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/lightsail.html) in the *Amazon Web Services General Reference*.
     */
    override suspend fun getContainerLog(input: GetContainerLogRequest): GetContainerLogResponse {
        val op = SdkHttpOperation.build<GetContainerLogRequest, GetContainerLogResponse> {
            serializer = GetContainerLogOperationSerializer()
            deserializer = GetContainerLogOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContainerLog"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetContainerLog-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the deployments for your Amazon Lightsail container service
     *
     * A deployment specifies the settings, such as the ports and launch command, of containers that are deployed to your container service.
     *
     * The deployments are ordered by version in ascending order. The newest version is listed at the top of the response.
     *
     * A set number of deployments are kept before the oldest one is replaced with the newest one. For more information, see [Amazon Lightsail endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/lightsail.html) in the *Amazon Web Services General Reference*.
     */
    override suspend fun getContainerServiceDeployments(input: GetContainerServiceDeploymentsRequest): GetContainerServiceDeploymentsResponse {
        val op = SdkHttpOperation.build<GetContainerServiceDeploymentsRequest, GetContainerServiceDeploymentsResponse> {
            serializer = GetContainerServiceDeploymentsOperationSerializer()
            deserializer = GetContainerServiceDeploymentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContainerServiceDeployments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetContainerServiceDeployments-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the data points of a specific metric of your Amazon Lightsail container service.
     *
     * Metrics report the utilization of your resources. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
     */
    override suspend fun getContainerServiceMetricData(input: GetContainerServiceMetricDataRequest): GetContainerServiceMetricDataResponse {
        val op = SdkHttpOperation.build<GetContainerServiceMetricDataRequest, GetContainerServiceMetricDataResponse> {
            serializer = GetContainerServiceMetricDataOperationSerializer()
            deserializer = GetContainerServiceMetricDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContainerServiceMetricData"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetContainerServiceMetricData-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the list of powers that can be specified for your Amazon Lightsail container services.
     *
     * The power specifies the amount of memory, the number of vCPUs, and the base price of the container service.
     */
    override suspend fun getContainerServicePowers(input: GetContainerServicePowersRequest): GetContainerServicePowersResponse {
        val op = SdkHttpOperation.build<GetContainerServicePowersRequest, GetContainerServicePowersResponse> {
            serializer = GetContainerServicePowersOperationSerializer()
            deserializer = GetContainerServicePowersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContainerServicePowers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetContainerServicePowers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about one or more of your Amazon Lightsail container services.
     */
    override suspend fun getContainerServices(input: GetContainerServicesRequest): GetContainerServicesResponse {
        val op = SdkHttpOperation.build<GetContainerServicesRequest, GetContainerServicesResponse> {
            serializer = GetContainerServicesOperationSerializer()
            deserializer = GetContainerServicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContainerServices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetContainerServices-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a specific block storage disk.
     */
    override suspend fun getDisk(input: GetDiskRequest): GetDiskResponse {
        val op = SdkHttpOperation.build<GetDiskRequest, GetDiskResponse> {
            serializer = GetDiskOperationSerializer()
            deserializer = GetDiskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDisk"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetDisk-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a specific block storage disk snapshot.
     */
    override suspend fun getDiskSnapshot(input: GetDiskSnapshotRequest): GetDiskSnapshotResponse {
        val op = SdkHttpOperation.build<GetDiskSnapshotRequest, GetDiskSnapshotResponse> {
            serializer = GetDiskSnapshotOperationSerializer()
            deserializer = GetDiskSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDiskSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetDiskSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about all block storage disk snapshots in your AWS account and region.
     */
    override suspend fun getDiskSnapshots(input: GetDiskSnapshotsRequest): GetDiskSnapshotsResponse {
        val op = SdkHttpOperation.build<GetDiskSnapshotsRequest, GetDiskSnapshotsResponse> {
            serializer = GetDiskSnapshotsOperationSerializer()
            deserializer = GetDiskSnapshotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDiskSnapshots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetDiskSnapshots-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about all block storage disks in your AWS account and region.
     */
    override suspend fun getDisks(input: GetDisksRequest): GetDisksResponse {
        val op = SdkHttpOperation.build<GetDisksRequest, GetDisksResponse> {
            serializer = GetDisksOperationSerializer()
            deserializer = GetDisksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDisks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetDisks-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the bundles that can be applied to your Amazon Lightsail content delivery network (CDN) distributions.
     *
     * A distribution bundle specifies the monthly network transfer quota and monthly cost of your distribution.
     */
    override suspend fun getDistributionBundles(input: GetDistributionBundlesRequest): GetDistributionBundlesResponse {
        val op = SdkHttpOperation.build<GetDistributionBundlesRequest, GetDistributionBundlesResponse> {
            serializer = GetDistributionBundlesOperationSerializer()
            deserializer = GetDistributionBundlesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDistributionBundles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetDistributionBundles-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the timestamp and status of the last cache reset of a specific Amazon Lightsail content delivery network (CDN) distribution.
     */
    override suspend fun getDistributionLatestCacheReset(input: GetDistributionLatestCacheResetRequest): GetDistributionLatestCacheResetResponse {
        val op = SdkHttpOperation.build<GetDistributionLatestCacheResetRequest, GetDistributionLatestCacheResetResponse> {
            serializer = GetDistributionLatestCacheResetOperationSerializer()
            deserializer = GetDistributionLatestCacheResetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDistributionLatestCacheReset"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetDistributionLatestCacheReset-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the data points of a specific metric for an Amazon Lightsail content delivery network (CDN) distribution.
     *
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
     */
    override suspend fun getDistributionMetricData(input: GetDistributionMetricDataRequest): GetDistributionMetricDataResponse {
        val op = SdkHttpOperation.build<GetDistributionMetricDataRequest, GetDistributionMetricDataResponse> {
            serializer = GetDistributionMetricDataOperationSerializer()
            deserializer = GetDistributionMetricDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDistributionMetricData"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetDistributionMetricData-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about one or more of your Amazon Lightsail content delivery network (CDN) distributions.
     */
    override suspend fun getDistributions(input: GetDistributionsRequest): GetDistributionsResponse {
        val op = SdkHttpOperation.build<GetDistributionsRequest, GetDistributionsResponse> {
            serializer = GetDistributionsOperationSerializer()
            deserializer = GetDistributionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDistributions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetDistributions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a specific domain recordset.
     */
    override suspend fun getDomain(input: GetDomainRequest): GetDomainResponse {
        val op = SdkHttpOperation.build<GetDomainRequest, GetDomainResponse> {
            serializer = GetDomainOperationSerializer()
            deserializer = GetDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetDomain-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of all domains in the user's account.
     */
    override suspend fun getDomains(input: GetDomainsRequest): GetDomainsResponse {
        val op = SdkHttpOperation.build<GetDomainsRequest, GetDomainsResponse> {
            serializer = GetDomainsOperationSerializer()
            deserializer = GetDomainsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDomains"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetDomains-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns all export snapshot records created as a result of the `export snapshot` operation.
     *
     * An export snapshot record can be used to create a new Amazon EC2 instance and its related resources with the [CreateCloudFormationStack](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateCloudFormationStack.html) action.
     */
    override suspend fun getExportSnapshotRecords(input: GetExportSnapshotRecordsRequest): GetExportSnapshotRecordsResponse {
        val op = SdkHttpOperation.build<GetExportSnapshotRecordsRequest, GetExportSnapshotRecordsResponse> {
            serializer = GetExportSnapshotRecordsOperationSerializer()
            deserializer = GetExportSnapshotRecordsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetExportSnapshotRecords"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetExportSnapshotRecords-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a specific Amazon Lightsail instance, which is a virtual private server.
     */
    override suspend fun getInstance(input: GetInstanceRequest): GetInstanceResponse {
        val op = SdkHttpOperation.build<GetInstanceRequest, GetInstanceResponse> {
            serializer = GetInstanceOperationSerializer()
            deserializer = GetInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetInstance-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns temporary SSH keys you can use to connect to a specific virtual private server, or *instance*.
     *
     * The `get instance access details` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun getInstanceAccessDetails(input: GetInstanceAccessDetailsRequest): GetInstanceAccessDetailsResponse {
        val op = SdkHttpOperation.build<GetInstanceAccessDetailsRequest, GetInstanceAccessDetailsResponse> {
            serializer = GetInstanceAccessDetailsOperationSerializer()
            deserializer = GetInstanceAccessDetailsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInstanceAccessDetails"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetInstanceAccessDetails-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the data points for the specified Amazon Lightsail instance metric, given an instance name.
     *
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
     */
    override suspend fun getInstanceMetricData(input: GetInstanceMetricDataRequest): GetInstanceMetricDataResponse {
        val op = SdkHttpOperation.build<GetInstanceMetricDataRequest, GetInstanceMetricDataResponse> {
            serializer = GetInstanceMetricDataOperationSerializer()
            deserializer = GetInstanceMetricDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInstanceMetricData"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetInstanceMetricData-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the firewall port states for a specific Amazon Lightsail instance, the IP addresses allowed to connect to the instance through the ports, and the protocol.
     */
    override suspend fun getInstancePortStates(input: GetInstancePortStatesRequest): GetInstancePortStatesResponse {
        val op = SdkHttpOperation.build<GetInstancePortStatesRequest, GetInstancePortStatesResponse> {
            serializer = GetInstancePortStatesOperationSerializer()
            deserializer = GetInstancePortStatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInstancePortStates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetInstancePortStates-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a specific instance snapshot.
     */
    override suspend fun getInstanceSnapshot(input: GetInstanceSnapshotRequest): GetInstanceSnapshotResponse {
        val op = SdkHttpOperation.build<GetInstanceSnapshotRequest, GetInstanceSnapshotResponse> {
            serializer = GetInstanceSnapshotOperationSerializer()
            deserializer = GetInstanceSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInstanceSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetInstanceSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns all instance snapshots for the user's account.
     */
    override suspend fun getInstanceSnapshots(input: GetInstanceSnapshotsRequest): GetInstanceSnapshotsResponse {
        val op = SdkHttpOperation.build<GetInstanceSnapshotsRequest, GetInstanceSnapshotsResponse> {
            serializer = GetInstanceSnapshotsOperationSerializer()
            deserializer = GetInstanceSnapshotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInstanceSnapshots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetInstanceSnapshots-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the state of a specific instance. Works on one instance at a time.
     */
    override suspend fun getInstanceState(input: GetInstanceStateRequest): GetInstanceStateResponse {
        val op = SdkHttpOperation.build<GetInstanceStateRequest, GetInstanceStateResponse> {
            serializer = GetInstanceStateOperationSerializer()
            deserializer = GetInstanceStateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInstanceState"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetInstanceState-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about all Amazon Lightsail virtual private servers, or *instances*.
     */
    override suspend fun getInstances(input: GetInstancesRequest): GetInstancesResponse {
        val op = SdkHttpOperation.build<GetInstancesRequest, GetInstancesResponse> {
            serializer = GetInstancesOperationSerializer()
            deserializer = GetInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetInstances-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a specific key pair.
     */
    override suspend fun getKeyPair(input: GetKeyPairRequest): GetKeyPairResponse {
        val op = SdkHttpOperation.build<GetKeyPairRequest, GetKeyPairResponse> {
            serializer = GetKeyPairOperationSerializer()
            deserializer = GetKeyPairOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetKeyPair"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetKeyPair-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about all key pairs in the user's account.
     */
    override suspend fun getKeyPairs(input: GetKeyPairsRequest): GetKeyPairsResponse {
        val op = SdkHttpOperation.build<GetKeyPairsRequest, GetKeyPairsResponse> {
            serializer = GetKeyPairsOperationSerializer()
            deserializer = GetKeyPairsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetKeyPairs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetKeyPairs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about the specified Lightsail load balancer.
     */
    override suspend fun getLoadBalancer(input: GetLoadBalancerRequest): GetLoadBalancerResponse {
        val op = SdkHttpOperation.build<GetLoadBalancerRequest, GetLoadBalancerResponse> {
            serializer = GetLoadBalancerOperationSerializer()
            deserializer = GetLoadBalancerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLoadBalancer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetLoadBalancer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about health metrics for your Lightsail load balancer.
     *
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
     */
    override suspend fun getLoadBalancerMetricData(input: GetLoadBalancerMetricDataRequest): GetLoadBalancerMetricDataResponse {
        val op = SdkHttpOperation.build<GetLoadBalancerMetricDataRequest, GetLoadBalancerMetricDataResponse> {
            serializer = GetLoadBalancerMetricDataOperationSerializer()
            deserializer = GetLoadBalancerMetricDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLoadBalancerMetricData"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetLoadBalancerMetricData-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about the TLS certificates that are associated with the specified Lightsail load balancer.
     *
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     *
     * You can have a maximum of 2 certificates associated with a Lightsail load balancer. One is active and the other is inactive.
     */
    override suspend fun getLoadBalancerTlsCertificates(input: GetLoadBalancerTlsCertificatesRequest): GetLoadBalancerTlsCertificatesResponse {
        val op = SdkHttpOperation.build<GetLoadBalancerTlsCertificatesRequest, GetLoadBalancerTlsCertificatesResponse> {
            serializer = GetLoadBalancerTlsCertificatesOperationSerializer()
            deserializer = GetLoadBalancerTlsCertificatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLoadBalancerTlsCertificates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetLoadBalancerTlsCertificates-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of TLS security policies that you can apply to Lightsail load balancers.
     *
     * For more information about load balancer TLS security policies, see [Configuring TLS security policies on your Amazon Lightsail load balancers](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configure-load-balancer-tls-security-policy) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun getLoadBalancerTlsPolicies(input: GetLoadBalancerTlsPoliciesRequest): GetLoadBalancerTlsPoliciesResponse {
        val op = SdkHttpOperation.build<GetLoadBalancerTlsPoliciesRequest, GetLoadBalancerTlsPoliciesResponse> {
            serializer = GetLoadBalancerTlsPoliciesOperationSerializer()
            deserializer = GetLoadBalancerTlsPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLoadBalancerTlsPolicies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetLoadBalancerTlsPolicies-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about all load balancers in an account.
     */
    override suspend fun getLoadBalancers(input: GetLoadBalancersRequest): GetLoadBalancersResponse {
        val op = SdkHttpOperation.build<GetLoadBalancersRequest, GetLoadBalancersResponse> {
            serializer = GetLoadBalancersOperationSerializer()
            deserializer = GetLoadBalancersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLoadBalancers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetLoadBalancers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a specific operation. Operations include events such as when you create an instance, allocate a static IP, attach a static IP, and so on.
     */
    override suspend fun getOperation(input: GetOperationRequest): GetOperationResponse {
        val op = SdkHttpOperation.build<GetOperationRequest, GetOperationResponse> {
            serializer = GetOperationOperationSerializer()
            deserializer = GetOperationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOperation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetOperation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about all operations.
     *
     * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each subsequent call to `GetOperations` use the maximum (last) `statusChangedAt` value from the previous request.
     */
    override suspend fun getOperations(input: GetOperationsRequest): GetOperationsResponse {
        val op = SdkHttpOperation.build<GetOperationsRequest, GetOperationsResponse> {
            serializer = GetOperationsOperationSerializer()
            deserializer = GetOperationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOperations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetOperations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets operations for a specific resource (e.g., an instance or a static IP).
     */
    override suspend fun getOperationsForResource(input: GetOperationsForResourceRequest): GetOperationsForResourceResponse {
        val op = SdkHttpOperation.build<GetOperationsForResourceRequest, GetOperationsForResourceResponse> {
            serializer = GetOperationsForResourceOperationSerializer()
            deserializer = GetOperationsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOperationsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetOperationsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of all valid regions for Amazon Lightsail. Use the `include availability zones` parameter to also return the Availability Zones in a region.
     */
    override suspend fun getRegions(input: GetRegionsRequest): GetRegionsResponse {
        val op = SdkHttpOperation.build<GetRegionsRequest, GetRegionsResponse> {
            serializer = GetRegionsOperationSerializer()
            deserializer = GetRegionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRegions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRegions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a specific database in Amazon Lightsail.
     */
    override suspend fun getRelationalDatabase(input: GetRelationalDatabaseRequest): GetRelationalDatabaseResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseRequest, GetRelationalDatabaseResponse> {
            serializer = GetRelationalDatabaseOperationSerializer()
            deserializer = GetRelationalDatabaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRelationalDatabase"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRelationalDatabase-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of available database blueprints in Amazon Lightsail. A blueprint describes the major engine version of a database.
     *
     * You can use a blueprint ID to create a new database that runs a specific database engine.
     */
    override suspend fun getRelationalDatabaseBlueprints(input: GetRelationalDatabaseBlueprintsRequest): GetRelationalDatabaseBlueprintsResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseBlueprintsRequest, GetRelationalDatabaseBlueprintsResponse> {
            serializer = GetRelationalDatabaseBlueprintsOperationSerializer()
            deserializer = GetRelationalDatabaseBlueprintsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRelationalDatabaseBlueprints"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRelationalDatabaseBlueprints-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the list of bundles that are available in Amazon Lightsail. A bundle describes the performance specifications for a database.
     *
     * You can use a bundle ID to create a new database with explicit performance specifications.
     */
    override suspend fun getRelationalDatabaseBundles(input: GetRelationalDatabaseBundlesRequest): GetRelationalDatabaseBundlesResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseBundlesRequest, GetRelationalDatabaseBundlesResponse> {
            serializer = GetRelationalDatabaseBundlesOperationSerializer()
            deserializer = GetRelationalDatabaseBundlesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRelationalDatabaseBundles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRelationalDatabaseBundles-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of events for a specific database in Amazon Lightsail.
     */
    override suspend fun getRelationalDatabaseEvents(input: GetRelationalDatabaseEventsRequest): GetRelationalDatabaseEventsResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseEventsRequest, GetRelationalDatabaseEventsResponse> {
            serializer = GetRelationalDatabaseEventsOperationSerializer()
            deserializer = GetRelationalDatabaseEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRelationalDatabaseEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRelationalDatabaseEvents-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of log events for a database in Amazon Lightsail.
     */
    override suspend fun getRelationalDatabaseLogEvents(input: GetRelationalDatabaseLogEventsRequest): GetRelationalDatabaseLogEventsResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseLogEventsRequest, GetRelationalDatabaseLogEventsResponse> {
            serializer = GetRelationalDatabaseLogEventsOperationSerializer()
            deserializer = GetRelationalDatabaseLogEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRelationalDatabaseLogEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRelationalDatabaseLogEvents-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of available log streams for a specific database in Amazon Lightsail.
     */
    override suspend fun getRelationalDatabaseLogStreams(input: GetRelationalDatabaseLogStreamsRequest): GetRelationalDatabaseLogStreamsResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseLogStreamsRequest, GetRelationalDatabaseLogStreamsResponse> {
            serializer = GetRelationalDatabaseLogStreamsOperationSerializer()
            deserializer = GetRelationalDatabaseLogStreamsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRelationalDatabaseLogStreams"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRelationalDatabaseLogStreams-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the current, previous, or pending versions of the master user password for a Lightsail database.
     *
     * The `GetRelationalDatabaseMasterUserPassword` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName.
     */
    override suspend fun getRelationalDatabaseMasterUserPassword(input: GetRelationalDatabaseMasterUserPasswordRequest): GetRelationalDatabaseMasterUserPasswordResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseMasterUserPasswordRequest, GetRelationalDatabaseMasterUserPasswordResponse> {
            serializer = GetRelationalDatabaseMasterUserPasswordOperationSerializer()
            deserializer = GetRelationalDatabaseMasterUserPasswordOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRelationalDatabaseMasterUserPassword"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRelationalDatabaseMasterUserPassword-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the data points of the specified metric for a database in Amazon Lightsail.
     *
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
     */
    override suspend fun getRelationalDatabaseMetricData(input: GetRelationalDatabaseMetricDataRequest): GetRelationalDatabaseMetricDataResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseMetricDataRequest, GetRelationalDatabaseMetricDataResponse> {
            serializer = GetRelationalDatabaseMetricDataOperationSerializer()
            deserializer = GetRelationalDatabaseMetricDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRelationalDatabaseMetricData"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRelationalDatabaseMetricData-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns all of the runtime parameters offered by the underlying database software, or engine, for a specific database in Amazon Lightsail.
     *
     * In addition to the parameter names and values, this operation returns other information about each parameter. This information includes whether changes require a reboot, whether the parameter is modifiable, the allowed values, and the data types.
     */
    override suspend fun getRelationalDatabaseParameters(input: GetRelationalDatabaseParametersRequest): GetRelationalDatabaseParametersResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseParametersRequest, GetRelationalDatabaseParametersResponse> {
            serializer = GetRelationalDatabaseParametersOperationSerializer()
            deserializer = GetRelationalDatabaseParametersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRelationalDatabaseParameters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRelationalDatabaseParameters-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a specific database snapshot in Amazon Lightsail.
     */
    override suspend fun getRelationalDatabaseSnapshot(input: GetRelationalDatabaseSnapshotRequest): GetRelationalDatabaseSnapshotResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseSnapshotRequest, GetRelationalDatabaseSnapshotResponse> {
            serializer = GetRelationalDatabaseSnapshotOperationSerializer()
            deserializer = GetRelationalDatabaseSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRelationalDatabaseSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRelationalDatabaseSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about all of your database snapshots in Amazon Lightsail.
     */
    override suspend fun getRelationalDatabaseSnapshots(input: GetRelationalDatabaseSnapshotsRequest): GetRelationalDatabaseSnapshotsResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseSnapshotsRequest, GetRelationalDatabaseSnapshotsResponse> {
            serializer = GetRelationalDatabaseSnapshotsOperationSerializer()
            deserializer = GetRelationalDatabaseSnapshotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRelationalDatabaseSnapshots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRelationalDatabaseSnapshots-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about all of your databases in Amazon Lightsail.
     */
    override suspend fun getRelationalDatabases(input: GetRelationalDatabasesRequest): GetRelationalDatabasesResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabasesRequest, GetRelationalDatabasesResponse> {
            serializer = GetRelationalDatabasesOperationSerializer()
            deserializer = GetRelationalDatabasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRelationalDatabases"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRelationalDatabases-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about an Amazon Lightsail static IP.
     */
    override suspend fun getStaticIp(input: GetStaticIpRequest): GetStaticIpResponse {
        val op = SdkHttpOperation.build<GetStaticIpRequest, GetStaticIpResponse> {
            serializer = GetStaticIpOperationSerializer()
            deserializer = GetStaticIpOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetStaticIp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetStaticIp-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about all static IPs in the user's account.
     */
    override suspend fun getStaticIps(input: GetStaticIpsRequest): GetStaticIpsResponse {
        val op = SdkHttpOperation.build<GetStaticIpsRequest, GetStaticIpsResponse> {
            serializer = GetStaticIpsOperationSerializer()
            deserializer = GetStaticIpsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetStaticIps"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetStaticIps-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Imports a public SSH key from a specific key pair.
     */
    override suspend fun importKeyPair(input: ImportKeyPairRequest): ImportKeyPairResponse {
        val op = SdkHttpOperation.build<ImportKeyPairRequest, ImportKeyPairResponse> {
            serializer = ImportKeyPairOperationSerializer()
            deserializer = ImportKeyPairOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportKeyPair"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ImportKeyPair-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a Boolean value indicating whether your Lightsail VPC is peered.
     */
    override suspend fun isVpcPeered(input: IsVpcPeeredRequest): IsVpcPeeredResponse {
        val op = SdkHttpOperation.build<IsVpcPeeredRequest, IsVpcPeeredResponse> {
            serializer = IsVpcPeeredOperationSerializer()
            deserializer = IsVpcPeeredOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "IsVpcPeered"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("IsVpcPeered-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol.
     *
     * The `OpenInstancePublicPorts` action supports tag-based access control via resource tags applied to the resource identified by `instanceName`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun openInstancePublicPorts(input: OpenInstancePublicPortsRequest): OpenInstancePublicPortsResponse {
        val op = SdkHttpOperation.build<OpenInstancePublicPortsRequest, OpenInstancePublicPortsResponse> {
            serializer = OpenInstancePublicPortsOperationSerializer()
            deserializer = OpenInstancePublicPortsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "OpenInstancePublicPorts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("OpenInstancePublicPorts-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Peers the Lightsail VPC with the user's default VPC.
     */
    override suspend fun peerVpc(input: PeerVpcRequest): PeerVpcResponse {
        val op = SdkHttpOperation.build<PeerVpcRequest, PeerVpcResponse> {
            serializer = PeerVpcOperationSerializer()
            deserializer = PeerVpcOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PeerVpc"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("PeerVpc-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates or updates an alarm, and associates it with the specified metric.
     *
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
     *
     * When this action creates an alarm, the alarm state is immediately set to `INSUFFICIENT_DATA`. The alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then executed.
     *
     * When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous configuration of the alarm. The alarm is then evaluated with the updated configuration.
     */
    override suspend fun putAlarm(input: PutAlarmRequest): PutAlarmResponse {
        val op = SdkHttpOperation.build<PutAlarmRequest, PutAlarmResponse> {
            serializer = PutAlarmOperationSerializer()
            deserializer = PutAlarmOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutAlarm"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("PutAlarm-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol. This action also closes all currently open ports that are not included in the request. Include all of the ports and the protocols you want to open in your `PutInstancePublicPorts`request. Or use the `OpenInstancePublicPorts` action to open ports without closing currently open ports.
     *
     * The `PutInstancePublicPorts` action supports tag-based access control via resource tags applied to the resource identified by `instanceName`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun putInstancePublicPorts(input: PutInstancePublicPortsRequest): PutInstancePublicPortsResponse {
        val op = SdkHttpOperation.build<PutInstancePublicPortsRequest, PutInstancePublicPortsResponse> {
            serializer = PutInstancePublicPortsOperationSerializer()
            deserializer = PutInstancePublicPortsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutInstancePublicPorts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("PutInstancePublicPorts-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Restarts a specific instance.
     *
     * The `reboot instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun rebootInstance(input: RebootInstanceRequest): RebootInstanceResponse {
        val op = SdkHttpOperation.build<RebootInstanceRequest, RebootInstanceResponse> {
            serializer = RebootInstanceOperationSerializer()
            deserializer = RebootInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RebootInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("RebootInstance-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Restarts a specific database in Amazon Lightsail.
     *
     * The `reboot relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun rebootRelationalDatabase(input: RebootRelationalDatabaseRequest): RebootRelationalDatabaseResponse {
        val op = SdkHttpOperation.build<RebootRelationalDatabaseRequest, RebootRelationalDatabaseResponse> {
            serializer = RebootRelationalDatabaseOperationSerializer()
            deserializer = RebootRelationalDatabaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RebootRelationalDatabase"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("RebootRelationalDatabase-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Registers a container image to your Amazon Lightsail container service.
     *
     * This action is not required if you install and use the Lightsail Control (lightsailctl) plugin to push container images to your Lightsail container service. For more information, see [Pushing and managing container images on your Amazon Lightsail container services](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun registerContainerImage(input: RegisterContainerImageRequest): RegisterContainerImageResponse {
        val op = SdkHttpOperation.build<RegisterContainerImageRequest, RegisterContainerImageResponse> {
            serializer = RegisterContainerImageOperationSerializer()
            deserializer = RegisterContainerImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterContainerImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("RegisterContainerImage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a specific static IP from your account.
     */
    override suspend fun releaseStaticIp(input: ReleaseStaticIpRequest): ReleaseStaticIpResponse {
        val op = SdkHttpOperation.build<ReleaseStaticIpRequest, ReleaseStaticIpResponse> {
            serializer = ReleaseStaticIpOperationSerializer()
            deserializer = ReleaseStaticIpOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReleaseStaticIp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ReleaseStaticIp-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes currently cached content from your Amazon Lightsail content delivery network (CDN) distribution.
     *
     * After resetting the cache, the next time a content request is made, your distribution pulls, serves, and caches it from the origin.
     */
    override suspend fun resetDistributionCache(input: ResetDistributionCacheRequest): ResetDistributionCacheResponse {
        val op = SdkHttpOperation.build<ResetDistributionCacheRequest, ResetDistributionCacheResponse> {
            serializer = ResetDistributionCacheOperationSerializer()
            deserializer = ResetDistributionCacheOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResetDistributionCache"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ResetDistributionCache-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Sends a verification request to an email contact method to ensure it's owned by the requester. SMS contact methods don't need to be verified.
     *
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
     *
     * A verification request is sent to the contact method when you initially create it. Use this action to send another verification request if a previous verification request was deleted, or has expired.
     *
     * Notifications are not sent to an email contact method until after it is verified, and confirmed as valid.
     */
    override suspend fun sendContactMethodVerification(input: SendContactMethodVerificationRequest): SendContactMethodVerificationResponse {
        val op = SdkHttpOperation.build<SendContactMethodVerificationRequest, SendContactMethodVerificationResponse> {
            serializer = SendContactMethodVerificationOperationSerializer()
            deserializer = SendContactMethodVerificationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendContactMethodVerification"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("SendContactMethodVerification-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Sets the IP address type for an Amazon Lightsail resource.
     *
     * Use this action to enable dual-stack for a resource, which enables IPv4 and IPv6 for the specified resource. Alternately, you can use this action to disable dual-stack, and enable IPv4 only.
     */
    override suspend fun setIpAddressType(input: SetIpAddressTypeRequest): SetIpAddressTypeResponse {
        val op = SdkHttpOperation.build<SetIpAddressTypeRequest, SetIpAddressTypeResponse> {
            serializer = SetIpAddressTypeOperationSerializer()
            deserializer = SetIpAddressTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetIpAddressType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("SetIpAddressType-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Sets the Amazon Lightsail resources that can access the specified Lightsail bucket.
     *
     * Lightsail buckets currently support setting access for Lightsail instances in the same Amazon Web Services Region.
     */
    override suspend fun setResourceAccessForBucket(input: SetResourceAccessForBucketRequest): SetResourceAccessForBucketResponse {
        val op = SdkHttpOperation.build<SetResourceAccessForBucketRequest, SetResourceAccessForBucketResponse> {
            serializer = SetResourceAccessForBucketOperationSerializer()
            deserializer = SetResourceAccessForBucketOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetResourceAccessForBucket"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("SetResourceAccessForBucket-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the `reboot instance` operation.
     *
     * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP address after stopping and starting an instance, create a static IP address and attach it to the instance. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-create-static-ip).
     *
     * The `start instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun startInstance(input: StartInstanceRequest): StartInstanceResponse {
        val op = SdkHttpOperation.build<StartInstanceRequest, StartInstanceResponse> {
            serializer = StartInstanceOperationSerializer()
            deserializer = StartInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("StartInstance-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts a specific database from a stopped state in Amazon Lightsail. To restart a database, use the `reboot relational database` operation.
     *
     * The `start relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun startRelationalDatabase(input: StartRelationalDatabaseRequest): StartRelationalDatabaseResponse {
        val op = SdkHttpOperation.build<StartRelationalDatabaseRequest, StartRelationalDatabaseResponse> {
            serializer = StartRelationalDatabaseOperationSerializer()
            deserializer = StartRelationalDatabaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartRelationalDatabase"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("StartRelationalDatabase-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops a specific Amazon Lightsail instance that is currently running.
     *
     * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP address after stopping and starting an instance, create a static IP address and attach it to the instance. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-create-static-ip).
     *
     * The `stop instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun stopInstance(input: StopInstanceRequest): StopInstanceResponse {
        val op = SdkHttpOperation.build<StopInstanceRequest, StopInstanceResponse> {
            serializer = StopInstanceOperationSerializer()
            deserializer = StopInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("StopInstance-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops a specific database that is currently running in Amazon Lightsail.
     *
     * The `stop relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun stopRelationalDatabase(input: StopRelationalDatabaseRequest): StopRelationalDatabaseResponse {
        val op = SdkHttpOperation.build<StopRelationalDatabaseRequest, StopRelationalDatabaseResponse> {
            serializer = StopRelationalDatabaseOperationSerializer()
            deserializer = StopRelationalDatabaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopRelationalDatabase"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("StopRelationalDatabase-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds one or more tags to the specified Amazon Lightsail resource. Each resource can have a maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     *
     * The `tag resource` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `resource name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Tests an alarm by displaying a banner on the Amazon Lightsail console. If a notification trigger is configured for the specified alarm, the test also sends a notification to the notification protocol (`Email` and/or `SMS`) configured for the alarm.
     *
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
     */
    override suspend fun testAlarm(input: TestAlarmRequest): TestAlarmResponse {
        val op = SdkHttpOperation.build<TestAlarmRequest, TestAlarmResponse> {
            serializer = TestAlarmOperationSerializer()
            deserializer = TestAlarmOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestAlarm"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("TestAlarm-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Unpeers the Lightsail VPC from the user's default VPC.
     */
    override suspend fun unpeerVpc(input: UnpeerVpcRequest): UnpeerVpcResponse {
        val op = SdkHttpOperation.build<UnpeerVpcRequest, UnpeerVpcResponse> {
            serializer = UnpeerVpcOperationSerializer()
            deserializer = UnpeerVpcOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UnpeerVpc"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UnpeerVpc-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified set of tag keys and their values from the specified Amazon Lightsail resource.
     *
     * The `untag resource` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `resource name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing Amazon Lightsail bucket.
     *
     * Use this action to update the configuration of an existing bucket, such as versioning, public accessibility, and the Amazon Web Services accounts that can access the bucket.
     */
    override suspend fun updateBucket(input: UpdateBucketRequest): UpdateBucketResponse {
        val op = SdkHttpOperation.build<UpdateBucketRequest, UpdateBucketResponse> {
            serializer = UpdateBucketOperationSerializer()
            deserializer = UpdateBucketOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBucket"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateBucket-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the bundle, or storage plan, of an existing Amazon Lightsail bucket.
     *
     * A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket. You can update a bucket's bundle only one time within a monthly Amazon Web Services billing cycle. To determine if you can update a bucket's bundle, use the [GetBuckets](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBuckets.html) action. The `ableToUpdateBundle` parameter in the response will indicate whether you can currently update a bucket's bundle.
     *
     * Update a bucket's bundle if it's consistently going over its storage space or data transfer quota, or if a bucket's usage is consistently in the lower range of its storage space or data transfer quota. Due to the unpredictable usage fluctuations that a bucket might experience, we strongly recommend that you update a bucket's bundle only as a long-term strategy, instead of as a short-term, monthly cost-cutting measure. Choose a bucket bundle that will provide the bucket with ample storage space and data transfer for a long time to come.
     */
    override suspend fun updateBucketBundle(input: UpdateBucketBundleRequest): UpdateBucketBundleResponse {
        val op = SdkHttpOperation.build<UpdateBucketBundleRequest, UpdateBucketBundleResponse> {
            serializer = UpdateBucketBundleOperationSerializer()
            deserializer = UpdateBucketBundleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBucketBundle"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateBucketBundle-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the configuration of your Amazon Lightsail container service, such as its power, scale, and public domain names.
     */
    override suspend fun updateContainerService(input: UpdateContainerServiceRequest): UpdateContainerServiceResponse {
        val op = SdkHttpOperation.build<UpdateContainerServiceRequest, UpdateContainerServiceResponse> {
            serializer = UpdateContainerServiceOperationSerializer()
            deserializer = UpdateContainerServiceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateContainerService"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateContainerService-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing Amazon Lightsail content delivery network (CDN) distribution.
     *
     * Use this action to update the configuration of your existing distribution.
     */
    override suspend fun updateDistribution(input: UpdateDistributionRequest): UpdateDistributionResponse {
        val op = SdkHttpOperation.build<UpdateDistributionRequest, UpdateDistributionResponse> {
            serializer = UpdateDistributionOperationSerializer()
            deserializer = UpdateDistributionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDistribution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateDistribution-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the bundle of your Amazon Lightsail content delivery network (CDN) distribution.
     *
     * A distribution bundle specifies the monthly network transfer quota and monthly cost of your distribution.
     *
     * Update your distribution's bundle if your distribution is going over its monthly network transfer quota and is incurring an overage fee.
     *
     * You can update your distribution's bundle only one time within your monthly Amazon Web Services billing cycle. To determine if you can update your distribution's bundle, use the `GetDistributions` action. The `ableToUpdateBundle` parameter in the result will indicate whether you can currently update your distribution's bundle.
     */
    override suspend fun updateDistributionBundle(input: UpdateDistributionBundleRequest): UpdateDistributionBundleResponse {
        val op = SdkHttpOperation.build<UpdateDistributionBundleRequest, UpdateDistributionBundleResponse> {
            serializer = UpdateDistributionBundleOperationSerializer()
            deserializer = UpdateDistributionBundleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDistributionBundle"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateDistributionBundle-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a domain recordset after it is created.
     *
     * The `update domain entry` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun updateDomainEntry(input: UpdateDomainEntryRequest): UpdateDomainEntryResponse {
        val op = SdkHttpOperation.build<UpdateDomainEntryRequest, UpdateDomainEntryResponse> {
            serializer = UpdateDomainEntryOperationSerializer()
            deserializer = UpdateDomainEntryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDomainEntry"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateDomainEntry-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Modifies the Amazon Lightsail instance metadata parameters on a running or stopped instance. When you modify the parameters on a running instance, the `GetInstance` or `GetInstances` API operation initially responds with a state of `pending`. After the parameter modifications are successfully applied, the state changes to `applied` in subsequent `GetInstance` or `GetInstances` API calls. For more information, see [Use IMDSv2 with an Amazon Lightsail instance](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-instance-metadata-service) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun updateInstanceMetadataOptions(input: UpdateInstanceMetadataOptionsRequest): UpdateInstanceMetadataOptionsResponse {
        val op = SdkHttpOperation.build<UpdateInstanceMetadataOptionsRequest, UpdateInstanceMetadataOptionsResponse> {
            serializer = UpdateInstanceMetadataOptionsOperationSerializer()
            deserializer = UpdateInstanceMetadataOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateInstanceMetadataOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateInstanceMetadataOptions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the specified attribute for a load balancer. You can only update one attribute at a time.
     *
     * The `update load balancer attribute` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun updateLoadBalancerAttribute(input: UpdateLoadBalancerAttributeRequest): UpdateLoadBalancerAttributeResponse {
        val op = SdkHttpOperation.build<UpdateLoadBalancerAttributeRequest, UpdateLoadBalancerAttributeResponse> {
            serializer = UpdateLoadBalancerAttributeOperationSerializer()
            deserializer = UpdateLoadBalancerAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLoadBalancerAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateLoadBalancerAttribute-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Allows the update of one or more attributes of a database in Amazon Lightsail.
     *
     * Updates are applied immediately, or in cases where the updates could result in an outage, are applied during the database's predefined maintenance window.
     *
     * The `update relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun updateRelationalDatabase(input: UpdateRelationalDatabaseRequest): UpdateRelationalDatabaseResponse {
        val op = SdkHttpOperation.build<UpdateRelationalDatabaseRequest, UpdateRelationalDatabaseResponse> {
            serializer = UpdateRelationalDatabaseOperationSerializer()
            deserializer = UpdateRelationalDatabaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRelationalDatabase"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateRelationalDatabase-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Allows the update of one or more parameters of a database in Amazon Lightsail.
     *
     * Parameter updates don't cause outages; therefore, their application is not subject to the preferred maintenance window. However, there are two ways in which parameter updates are applied: `dynamic` or `pending-reboot`. Parameters marked with a `dynamic` apply type are applied immediately. Parameters marked with a `pending-reboot` apply type are applied only after the database is rebooted using the `reboot relational database` operation.
     *
     * The `update relational database parameters` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun updateRelationalDatabaseParameters(input: UpdateRelationalDatabaseParametersRequest): UpdateRelationalDatabaseParametersResponse {
        val op = SdkHttpOperation.build<UpdateRelationalDatabaseParametersRequest, UpdateRelationalDatabaseParametersResponse> {
            serializer = UpdateRelationalDatabaseParametersOperationSerializer()
            deserializer = UpdateRelationalDatabaseParametersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRelationalDatabaseParameters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lightsail"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateRelationalDatabaseParameters-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "lightsail")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
