// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the last time an access key was used.
 *
 * This object does not include data in the response of a [CreateBucketAccessKey](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateBucketAccessKey.html) action.
 */
public class AccessKeyLastUsed private constructor(builder: Builder) {
    /**
     * The date and time when the access key was most recently used.
     *
     * This value is null if the access key has not been used.
     */
    public val lastUsedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUsedDate
    /**
     * The Amazon Web Services Region where this access key was most recently used.
     *
     * This value is `N/A` if the access key has not been used.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The name of the Amazon Web Services service with which this access key was most recently used.
     *
     * This value is `N/A` if the access key has not been used.
     */
    public val serviceName: kotlin.String? = builder.serviceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.AccessKeyLastUsed = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessKeyLastUsed(")
        append("lastUsedDate=$lastUsedDate,")
        append("region=$region,")
        append("serviceName=$serviceName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastUsedDate?.hashCode() ?: 0
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessKeyLastUsed

        if (lastUsedDate != other.lastUsedDate) return false
        if (region != other.region) return false
        if (serviceName != other.serviceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.AccessKeyLastUsed = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time when the access key was most recently used.
         *
         * This value is null if the access key has not been used.
         */
        public var lastUsedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Web Services Region where this access key was most recently used.
         *
         * This value is `N/A` if the access key has not been used.
         */
        public var region: kotlin.String? = null
        /**
         * The name of the Amazon Web Services service with which this access key was most recently used.
         *
         * This value is `N/A` if the access key has not been used.
         */
        public var serviceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.AccessKeyLastUsed) : this() {
            this.lastUsedDate = x.lastUsedDate
            this.region = x.region
            this.serviceName = x.serviceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.AccessKeyLastUsed = AccessKeyLastUsed(this)
    }
}
