// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes a bundle, which is a set of specs describing your virtual private server (or *instance*).
 */
public class Bundle private constructor(builder: Builder) {
    /**
     * The bundle ID (e.g., `micro_1_0`).
     */
    public val bundleId: kotlin.String? = builder.bundleId
    /**
     * The number of vCPUs included in the bundle (e.g., `2`).
     */
    public val cpuCount: kotlin.Int? = builder.cpuCount
    /**
     * The size of the SSD (e.g., `30`).
     */
    public val diskSizeInGb: kotlin.Int? = builder.diskSizeInGb
    /**
     * The Amazon EC2 instance type (e.g., `t2.micro`).
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * A Boolean value indicating whether the bundle is active.
     */
    public val isActive: kotlin.Boolean? = builder.isActive
    /**
     * A friendly name for the bundle (e.g., `Micro`).
     */
    public val name: kotlin.String? = builder.name
    /**
     * A numeric value that represents the power of the bundle (e.g., `500`). You can use the bundle's power value in conjunction with a blueprint's minimum power value to determine whether the blueprint will run on the bundle. For example, you need a bundle with a power value of 500 or more to create an instance that uses a blueprint with a minimum power value of 500.
     */
    public val power: kotlin.Int? = builder.power
    /**
     * The price in US dollars (e.g., `5.0`) of the bundle.
     */
    public val price: kotlin.Float? = builder.price
    /**
     * The amount of RAM in GB (e.g., `2.0`).
     */
    public val ramSizeInGb: kotlin.Float? = builder.ramSizeInGb
    /**
     * The operating system platform (Linux/Unix-based or Windows Server-based) that the bundle supports. You can only launch a `WINDOWS` bundle on a blueprint that supports the `WINDOWS` platform. `LINUX_UNIX` blueprints require a `LINUX_UNIX` bundle.
     */
    public val supportedPlatforms: List<InstancePlatform>? = builder.supportedPlatforms
    /**
     * The data transfer rate per month in GB (e.g., `2000`).
     */
    public val transferPerMonthInGb: kotlin.Int? = builder.transferPerMonthInGb

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.Bundle = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Bundle(")
        append("bundleId=$bundleId,")
        append("cpuCount=$cpuCount,")
        append("diskSizeInGb=$diskSizeInGb,")
        append("instanceType=$instanceType,")
        append("isActive=$isActive,")
        append("name=$name,")
        append("power=$power,")
        append("price=$price,")
        append("ramSizeInGb=$ramSizeInGb,")
        append("supportedPlatforms=$supportedPlatforms,")
        append("transferPerMonthInGb=$transferPerMonthInGb)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bundleId?.hashCode() ?: 0
        result = 31 * result + (cpuCount ?: 0)
        result = 31 * result + (diskSizeInGb ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (isActive?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (power ?: 0)
        result = 31 * result + (price?.hashCode() ?: 0)
        result = 31 * result + (ramSizeInGb?.hashCode() ?: 0)
        result = 31 * result + (supportedPlatforms?.hashCode() ?: 0)
        result = 31 * result + (transferPerMonthInGb ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Bundle

        if (bundleId != other.bundleId) return false
        if (cpuCount != other.cpuCount) return false
        if (diskSizeInGb != other.diskSizeInGb) return false
        if (instanceType != other.instanceType) return false
        if (isActive != other.isActive) return false
        if (name != other.name) return false
        if (power != other.power) return false
        if (price != other.price) return false
        if (ramSizeInGb != other.ramSizeInGb) return false
        if (supportedPlatforms != other.supportedPlatforms) return false
        if (transferPerMonthInGb != other.transferPerMonthInGb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.Bundle = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The bundle ID (e.g., `micro_1_0`).
         */
        public var bundleId: kotlin.String? = null
        /**
         * The number of vCPUs included in the bundle (e.g., `2`).
         */
        public var cpuCount: kotlin.Int? = null
        /**
         * The size of the SSD (e.g., `30`).
         */
        public var diskSizeInGb: kotlin.Int? = null
        /**
         * The Amazon EC2 instance type (e.g., `t2.micro`).
         */
        public var instanceType: kotlin.String? = null
        /**
         * A Boolean value indicating whether the bundle is active.
         */
        public var isActive: kotlin.Boolean? = null
        /**
         * A friendly name for the bundle (e.g., `Micro`).
         */
        public var name: kotlin.String? = null
        /**
         * A numeric value that represents the power of the bundle (e.g., `500`). You can use the bundle's power value in conjunction with a blueprint's minimum power value to determine whether the blueprint will run on the bundle. For example, you need a bundle with a power value of 500 or more to create an instance that uses a blueprint with a minimum power value of 500.
         */
        public var power: kotlin.Int? = null
        /**
         * The price in US dollars (e.g., `5.0`) of the bundle.
         */
        public var price: kotlin.Float? = null
        /**
         * The amount of RAM in GB (e.g., `2.0`).
         */
        public var ramSizeInGb: kotlin.Float? = null
        /**
         * The operating system platform (Linux/Unix-based or Windows Server-based) that the bundle supports. You can only launch a `WINDOWS` bundle on a blueprint that supports the `WINDOWS` platform. `LINUX_UNIX` blueprints require a `LINUX_UNIX` bundle.
         */
        public var supportedPlatforms: List<InstancePlatform>? = null
        /**
         * The data transfer rate per month in GB (e.g., `2000`).
         */
        public var transferPerMonthInGb: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.Bundle) : this() {
            this.bundleId = x.bundleId
            this.cpuCount = x.cpuCount
            this.diskSizeInGb = x.diskSizeInGb
            this.instanceType = x.instanceType
            this.isActive = x.isActive
            this.name = x.name
            this.power = x.power
            this.price = x.price
            this.ramSizeInGb = x.ramSizeInGb
            this.supportedPlatforms = x.supportedPlatforms
            this.transferPerMonthInGb = x.transferPerMonthInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.Bundle = Bundle(this)
    }
}
