// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes an Amazon Lightsail SSL/TLS certificate.
 */
public class CertificateSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the certificate.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * An object that describes a certificate in detail.
     */
    public val certificateDetail: aws.sdk.kotlin.services.lightsail.model.Certificate? = builder.certificateDetail
    /**
     * The name of the certificate.
     */
    public val certificateName: kotlin.String? = builder.certificateName
    /**
     * The domain name of the certificate.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CertificateSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateSummary(")
        append("certificateArn=$certificateArn,")
        append("certificateDetail=$certificateDetail,")
        append("certificateName=$certificateName,")
        append("domainName=$domainName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (certificateDetail?.hashCode() ?: 0)
        result = 31 * result + (certificateName?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CertificateSummary

        if (certificateArn != other.certificateArn) return false
        if (certificateDetail != other.certificateDetail) return false
        if (certificateName != other.certificateName) return false
        if (domainName != other.domainName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CertificateSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the certificate.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * An object that describes a certificate in detail.
         */
        public var certificateDetail: aws.sdk.kotlin.services.lightsail.model.Certificate? = null
        /**
         * The name of the certificate.
         */
        public var certificateName: kotlin.String? = null
        /**
         * The domain name of the certificate.
         */
        public var domainName: kotlin.String? = null
        /**
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CertificateSummary) : this() {
            this.certificateArn = x.certificateArn
            this.certificateDetail = x.certificateDetail
            this.certificateName = x.certificateName
            this.domainName = x.domainName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CertificateSummary = CertificateSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.Certificate] inside the given [block]
         */
        public fun certificateDetail(block: aws.sdk.kotlin.services.lightsail.model.Certificate.Builder.() -> kotlin.Unit) {
            this.certificateDetail = aws.sdk.kotlin.services.lightsail.model.Certificate.invoke(block)
        }
    }
}
