// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes whether an Amazon Lightsail content delivery network (CDN) distribution forwards cookies to the origin and, if so, which ones.
 *
 * For the cookies that you specify, your distribution caches separate versions of the specified content based on the cookie values in viewer requests.
 */
public class CookieObject private constructor(builder: Builder) {
    /**
     * The specific cookies to forward to your distribution's origin.
     */
    public val cookiesAllowList: List<String>? = builder.cookiesAllowList
    /**
     * Specifies which cookies to forward to the distribution's origin for a cache behavior: `all`, `none`, or `allow-list` to forward only the cookies specified in the `cookiesAllowList` parameter.
     */
    public val option: aws.sdk.kotlin.services.lightsail.model.ForwardValues? = builder.option

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CookieObject = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CookieObject(")
        append("cookiesAllowList=$cookiesAllowList,")
        append("option=$option)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cookiesAllowList?.hashCode() ?: 0
        result = 31 * result + (option?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CookieObject

        if (cookiesAllowList != other.cookiesAllowList) return false
        if (option != other.option) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CookieObject = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The specific cookies to forward to your distribution's origin.
         */
        public var cookiesAllowList: List<String>? = null
        /**
         * Specifies which cookies to forward to the distribution's origin for a cache behavior: `all`, `none`, or `allow-list` to forward only the cookies specified in the `cookiesAllowList` parameter.
         */
        public var option: aws.sdk.kotlin.services.lightsail.model.ForwardValues? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CookieObject) : this() {
            this.cookiesAllowList = x.cookiesAllowList
            this.option = x.option
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CookieObject = CookieObject(this)
    }
}
