// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class CreateContactMethodRequest private constructor(builder: Builder) {
    /**
     * The destination of the contact method, such as an email address or a mobile phone number.
     *
     * Use the E.164 format when specifying a mobile phone number. E.164 is a standard for the phone number structure used for international telecommunication. Phone numbers that follow this format can have a maximum of 15 digits, and they are prefixed with the plus character (+) and the country code. For example, a U.S. phone number in E.164 format would be specified as +1XXX5550100. For more information, see [E.164](https://en.wikipedia.org/wiki/E.164) on *Wikipedia*.
     */
    public val contactEndpoint: kotlin.String? = builder.contactEndpoint
    /**
     * The protocol of the contact method, such as `Email` or `SMS` (text messaging).
     *
     * The `SMS` protocol is supported only in the following Amazon Web Services Regions.
     * + US East (N. Virginia) (`us-east-1`)
     * + US West (Oregon) (`us-west-2`)
     * + Europe (Ireland) (`eu-west-1`)
     * + Asia Pacific (Tokyo) (`ap-northeast-1`)
     * + Asia Pacific (Singapore) (`ap-southeast-1`)
     * + Asia Pacific (Sydney) (`ap-southeast-2`)
     *
     * For a list of countries/regions where SMS text messages can be sent, and the latest Amazon Web Services Regions where SMS text messaging is supported, see [Supported Regions and Countries](https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html) in the *Amazon SNS Developer Guide*.
     *
     * For more information about notifications in Amazon Lightsail, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
     */
    public val protocol: aws.sdk.kotlin.services.lightsail.model.ContactProtocol? = builder.protocol

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CreateContactMethodRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateContactMethodRequest(")
        append("contactEndpoint=$contactEndpoint,")
        append("protocol=$protocol)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactEndpoint?.hashCode() ?: 0
        result = 31 * result + (protocol?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateContactMethodRequest

        if (contactEndpoint != other.contactEndpoint) return false
        if (protocol != other.protocol) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CreateContactMethodRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The destination of the contact method, such as an email address or a mobile phone number.
         *
         * Use the E.164 format when specifying a mobile phone number. E.164 is a standard for the phone number structure used for international telecommunication. Phone numbers that follow this format can have a maximum of 15 digits, and they are prefixed with the plus character (+) and the country code. For example, a U.S. phone number in E.164 format would be specified as +1XXX5550100. For more information, see [E.164](https://en.wikipedia.org/wiki/E.164) on *Wikipedia*.
         */
        public var contactEndpoint: kotlin.String? = null
        /**
         * The protocol of the contact method, such as `Email` or `SMS` (text messaging).
         *
         * The `SMS` protocol is supported only in the following Amazon Web Services Regions.
         * + US East (N. Virginia) (`us-east-1`)
         * + US West (Oregon) (`us-west-2`)
         * + Europe (Ireland) (`eu-west-1`)
         * + Asia Pacific (Tokyo) (`ap-northeast-1`)
         * + Asia Pacific (Singapore) (`ap-southeast-1`)
         * + Asia Pacific (Sydney) (`ap-southeast-2`)
         *
         * For a list of countries/regions where SMS text messages can be sent, and the latest Amazon Web Services Regions where SMS text messaging is supported, see [Supported Regions and Countries](https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html) in the *Amazon SNS Developer Guide*.
         *
         * For more information about notifications in Amazon Lightsail, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
         */
        public var protocol: aws.sdk.kotlin.services.lightsail.model.ContactProtocol? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CreateContactMethodRequest) : this() {
            this.contactEndpoint = x.contactEndpoint
            this.protocol = x.protocol
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CreateContactMethodRequest = CreateContactMethodRequest(this)
    }
}
